/*
 * Decompiled with CFR 0.152.
 */
package com.lying.entity;

import com.lying.entity.WheelchairsRideable;
import com.lying.init.WHCItems;
import com.lying.utility.WHCUtils;
import java.util.OptionalInt;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PlayerRideable;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector2d;
import org.joml.Vector2dc;

public class StoolEntity
extends WheelchairsRideable
implements PlayerRideable {
    public static final int DEFAULT_COLOR = 0x1D1D21;
    public static final EntityDataAccessor<OptionalInt> COLOR = SynchedEntityData.defineId(StoolEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UNSIGNED_INT);
    public float spin = 0.0f;
    private Vector2d prevCaster;
    private Vector2d caster;

    public StoolEntity(EntityType<? extends LivingEntity> entityType, Level world) {
        super(entityType, world);
        double randX = (this.getRandom().nextDouble() - 0.5) * 2.0;
        double randY = (this.getRandom().nextDouble() - 0.5) * 2.0;
        this.prevCaster = this.caster = new Vector2d(randX, randY);
    }

    public void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(COLOR, (Object)OptionalInt.empty());
    }

    public static AttributeSupplier.Builder createStoolAttributes() {
        return StoolEntity.createMountAttributes().add(Attributes.STEP_HEIGHT, (double)0.6f);
    }

    public void readAdditionalSaveData(CompoundTag data) {
        super.readAdditionalSaveData(data);
        if (data.contains("Color", 3)) {
            this.getEntityData().set(COLOR, (Object)OptionalInt.of(data.getInt("Color")));
        }
    }

    public void addAdditionalSaveData(CompoundTag data) {
        super.addAdditionalSaveData(data);
        if (this.hasColor()) {
            data.putInt("Color", this.getColor());
        }
    }

    @Override
    public <T extends WheelchairsRideable> ItemStack entityToItem(T chair) {
        StoolEntity stool = (StoolEntity)chair;
        ItemStack stack = ((Item)WHCItems.STOOL.get()).getDefaultInstance().copy();
        if (stool.hasColor() && stack.has(DataComponents.DYED_COLOR)) {
            stack.set(DataComponents.DYED_COLOR, (Object)new DyedItemColor(stool.getColor(), true));
        }
        return stack;
    }

    @Override
    public void copyFromItem(ItemStack stack) {
        this.getEntityData().set(COLOR, (Object)(stack.has(DataComponents.DYED_COLOR) ? OptionalInt.of(DyedItemColor.getOrDefault((ItemStack)stack, (int)-1)) : OptionalInt.empty()));
    }

    public LivingEntity getControllingPassenger() {
        return this.getFirstPassenger() instanceof LivingEntity ? (LivingEntity)this.getFirstPassenger() : null;
    }

    protected float getRiddenSpeed(Player controllingPlayer) {
        return (float)controllingPlayer.getAttributeValue(Attributes.MOVEMENT_SPEED);
    }

    protected Vec3 getRiddenInput(Player controllingPlayer, Vec3 movementInput) {
        return new Vec3((double)controllingPlayer.xxa, 0.0, (double)controllingPlayer.zza);
    }

    protected Vec3 getPassengerAttachmentPoint(Entity passenger, EntityDimensions dimensions, float scaleFactor) {
        return new Vec3(0.0, (double)(dimensions.height() * 0.85f * scaleFactor), 0.0);
    }

    @Override
    protected void clampPassengerYaw(Entity passenger) {
        passenger.setYBodyRot(this.getYRot());
        float f = Mth.wrapDegrees((float)(passenger.getYRot() - this.getYRot()));
        float g = Mth.clamp((float)f, (float)-105.0f, (float)105.0f);
        passenger.yRotO += g - f;
        passenger.setYRot(passenger.getYRot() + g - f);
        passenger.setYHeadRot(passenger.getYRot());
    }

    public boolean hasColor() {
        return ((OptionalInt)this.getEntityData().get(COLOR)).isPresent();
    }

    public int getColor() {
        return this.hasColor() ? ((OptionalInt)this.getEntityData().get(COLOR)).getAsInt() : 0x1D1D21;
    }

    public Iterable<ItemStack> getArmorSlots() {
        return NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    }

    public boolean canEquip(ItemStack stack) {
        return false;
    }

    public void setItemSlot(EquipmentSlot var1, ItemStack var2) {
    }

    public ItemStack getItemBySlot(EquipmentSlot slot) {
        return ItemStack.EMPTY;
    }

    @Override
    public float getActualStepHeight() {
        return 0.6f;
    }

    @Override
    protected void orientToRider(LivingEntity controllingPlayer, Vec3 movementInput) {
        if (movementInput.length() > 0.0) {
            Vec2 orientation = this.getControlledRotation(controllingPlayer);
            this.setRot(orientation.y, orientation.x);
        } else {
            this.setRot(controllingPlayer.yBodyRot, 0.0f);
        }
        this.yRotO = this.yHeadRot;
        this.yBodyRot = this.yHeadRot = this.getYRot();
    }

    public void travel(Vec3 movementInput) {
        super.travel(movementInput);
        Vector2d lateral = new Vector2d(movementInput.x, movementInput.z);
        if (lateral.length() == 0.0) {
            return;
        }
        double speed = WHCUtils.calculateSpin((float)(movementInput.length() * (double)this.getSpeed()), 0.3125f);
        this.spin = WHCUtils.wrapDegrees(this.spin + (float)speed);
        Vec3 global = WHCUtils.localToGlobal(movementInput, this.getYRot());
        lateral = new Vector2d(global.x, global.z).mul(0.5);
        this.caster.get(this.prevCaster);
        this.caster.add((Vector2dc)lateral).normalize();
    }

    public float casterWheelYaw(float tickDelta) {
        Vector2d origin = this.prevCaster.get(new Vector2d());
        Vector2d current = this.caster.get(new Vector2d());
        origin.add((Vector2dc)current.sub((Vector2dc)origin).mul((double)tickDelta));
        return (float)Math.toDegrees(Math.atan2(origin.y, origin.x));
    }
}

