/*
 * Decompiled with CFR 0.152.
 */
package com.lying.entity;

import com.lying.component.type.WheelComponent;
import com.lying.entity.IParentedEntity;
import com.lying.init.WHCItems;
import com.lying.item.WalkerItem;
import com.lying.utility.WHCUtils;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2d;
import org.joml.Vector2dc;

public class WalkerEntity
extends LivingEntity
implements IParentedEntity {
    private static final EntityDataAccessor<ItemStack> ITEM = SynchedEntityData.defineId(WalkerEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<ItemStack> LEFT_WHEEL = SynchedEntityData.defineId(WalkerEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<ItemStack> RIGHT_WHEEL = SynchedEntityData.defineId(WalkerEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<Optional<UUID>> USER_ID = SynchedEntityData.defineId(WalkerEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Boolean> HAS_INV = SynchedEntityData.defineId(WalkerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private LivingEntity user = null;
    private Vector2d prevCaster;
    private Vector2d caster;
    public float spinLeft = 0.0f;
    public float spinRight = 0.0f;
    protected SimpleContainer items;

    public WalkerEntity(EntityType<? extends WalkerEntity> entityType, Level world) {
        super(entityType, world);
        double randX = (this.getRandom().nextDouble() - 0.5) * 2.0;
        double randY = (this.getRandom().nextDouble() - 0.5) * 2.0;
        this.prevCaster = this.caster = new Vector2d(randX, randY);
    }

    public void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ITEM, (Object)((Item)WHCItems.WALKER_OAK.get()).getDefaultInstance());
        builder.define(LEFT_WHEEL, (Object)WheelComponent.DEFAULT_WHEEL.get());
        builder.define(RIGHT_WHEEL, (Object)WheelComponent.DEFAULT_WHEEL.get());
        builder.define(USER_ID, Optional.empty());
        builder.define(HAS_INV, (Object)false);
    }

    public static AttributeSupplier.Builder createWalkerAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 1.0).add(Attributes.MOVEMENT_SPEED, (double)0.1f).add(Attributes.STEP_HEIGHT, 0.5);
    }

    public void readAdditionalSaveData(CompoundTag data) {
        super.readAdditionalSaveData(data);
        if (data.contains("Item", 10)) {
            this.getEntityData().set(ITEM, (Object)((ItemStack)ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)data.getCompound("Item")).get()));
        } else if (data.contains("Chair", 10)) {
            this.getEntityData().set(ITEM, (Object)((ItemStack)ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)data.getCompound("Chair")).get()));
        }
        if (data.contains("Wheels", 10)) {
            CompoundTag wheels = data.getCompound("Wheels");
            this.getEntityData().set(LEFT_WHEEL, (Object)((ItemStack)ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)wheels.getCompound("Left")).get()));
            this.getEntityData().set(RIGHT_WHEEL, (Object)((ItemStack)ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)wheels.getCompound("Right")).get()));
        }
        this.setHasInventory(data.getBoolean("Chested"));
        if (data.contains("Items", 9)) {
            ListTag items = data.getList("Items", 10);
            for (int i = 0; i < items.size(); ++i) {
                CompoundTag nbt = items.getCompound(i);
                int j = nbt.getByte("Slot") & 0xFF;
                if (j >= this.items.getContainerSize()) continue;
                this.items.setItem(j, (ItemStack)ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)nbt).get());
            }
        }
    }

    public void addAdditionalSaveData(CompoundTag data) {
        super.addAdditionalSaveData(data);
        data.put("Item", ((ItemStack)this.getEntityData().get(ITEM)).save((HolderLookup.Provider)this.registryAccess()));
        CompoundTag wheels = new CompoundTag();
        wheels.put("Left", this.getLeftWheel().save((HolderLookup.Provider)this.registryAccess()));
        wheels.put("Right", this.getRightWheel().save((HolderLookup.Provider)this.registryAccess()));
        data.put("Wheels", (Tag)wheels);
        data.putBoolean("Chested", this.hasInventory());
        if (this.hasInventory()) {
            ListTag items = new ListTag();
            for (int i = 0; i < this.items.getContainerSize(); ++i) {
                ItemStack stack = this.items.getItem(i);
                if (stack.isEmpty()) continue;
                CompoundTag nbt = (CompoundTag)stack.save((HolderLookup.Provider)this.registryAccess());
                nbt.putByte("Slot", (byte)i);
                items.add((Object)nbt);
            }
            data.put("Items", (Tag)items);
        }
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        boolean shouldRespond = !this.hasParent() || this.isParent((Entity)player);
        boolean isServer = !this.level().isClientSide();
        ItemStack heldStack = player.getItemInHand(hand);
        if (player.isSecondaryUseActive()) {
            boolean hasInv = this.hasInventory();
            if (!hasInv && (heldStack.is(Items.CHEST) || heldStack.is(Items.TRAPPED_CHEST))) {
                this.addInventory();
                if (!player.getAbilities().instabuild) {
                    heldStack.shrink(1);
                }
            } else if (hasInv && heldStack.is(ItemTags.AXES)) {
                if (isServer) {
                    this.spawnAtLocation((ServerLevel)this.level(), (ItemLike)Items.CHEST);
                }
                this.setHasInventory(false);
                if (!player.isCreative()) {
                    heldStack.hurtWithoutBreaking(1, player);
                }
                this.playSound(SoundEvents.AXE_STRIP, this.getSoundVolume(), this.getVoicePitch());
            } else if (shouldRespond) {
                this.convertToItem(null);
            }
            return InteractionResult.CONSUME;
        }
        if (!this.level().isClientSide()) {
            return shouldRespond && IParentedEntity.bindToPlayer(player, this) ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    public static ItemStack chairToItem(WalkerEntity chair) {
        ItemStack stack = chair.getFrame();
        WalkerItem.setWheels(stack, chair.getLeftWheel(), chair.getRightWheel());
        WalkerItem.setHasChest(stack, chair.hasInventory());
        return stack;
    }

    public void copyFromItem(ItemStack stack) {
        this.getEntityData().set(ITEM, (Object)stack.copy());
        this.getEntityData().set(LEFT_WHEEL, (Object)WalkerItem.getWheel(stack, HumanoidArm.LEFT));
        this.getEntityData().set(RIGHT_WHEEL, (Object)WalkerItem.getWheel(stack, HumanoidArm.RIGHT));
        if (WalkerItem.hasChest(stack)) {
            this.setHasInventory(true);
            List storedItems = ((ItemContainerContents)stack.get(DataComponents.CONTAINER)).stream().toList();
            for (int i = 0; i < storedItems.size(); ++i) {
                this.items.setItem(i, (ItemStack)storedItems.get(i));
            }
        }
    }

    @Override
    @Nullable
    public LivingEntity getParent() {
        if (!this.hasParent()) {
            return null;
        }
        return this.user == null ? (this.user = IParentedEntity.getParentOf(this)) : this.user;
    }

    public void convertToItem(@Nullable Player player) {
        if (!this.level().isClientSide()) {
            ItemStack stack = WalkerEntity.chairToItem(this);
            ItemEntity item = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), stack);
            this.dropEquipment((ServerLevel)this.level());
            if (player == null || !player.getInventory().add(stack)) {
                this.level().addFreshEntity((Entity)item);
            }
            this.discard();
        }
    }

    public void doPush(Entity entity) {
        if (!this.isParent(entity)) {
            super.doPush(entity);
        }
    }

    public void push(Entity entity) {
        if (!this.isParent(entity)) {
            super.push(entity);
        }
    }

    public boolean isInvulnerableTo(ServerLevel world, DamageSource damageSource) {
        DamageSources sources = world.damageSources();
        return damageSource != sources.fellOutOfWorld() && damageSource != sources.genericKill();
    }

    public boolean canBeAffected(MobEffectInstance effect) {
        return false;
    }

    public int getAirSupply() {
        return 20;
    }

    public Iterable<ItemStack> getArmorSlots() {
        return NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    }

    public boolean canEquip(ItemStack stack) {
        return false;
    }

    public ItemStack getItemBySlot(EquipmentSlot slot) {
        return slot == EquipmentSlot.FEET ? WalkerEntity.getEnchantments(this.getFrame()) : ItemStack.EMPTY;
    }

    public static ItemStack getEnchantments(ItemStack chair) {
        ItemStack spoof = Items.STONE.getDefaultInstance();
        spoof.set(DataComponents.ENCHANTMENTS, (Object)((ItemEnchantments)chair.get(DataComponents.ENCHANTMENTS)));
        return spoof;
    }

    public void setItemSlot(EquipmentSlot var1, ItemStack var2) {
    }

    public HumanoidArm getMainArm() {
        return HumanoidArm.RIGHT;
    }

    public ItemStack getFrame() {
        ItemStack stack = (ItemStack)this.getEntityData().get(ITEM);
        return stack.getItem() instanceof WalkerItem ? stack : new ItemStack(WHCItems.WHEELCHAIR_OAK);
    }

    public ItemStack getWheel(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.getLeftWheel() : this.getRightWheel();
    }

    protected ItemStack getWheel(ItemStack actualWheel) {
        ItemStack wheel = actualWheel.getItem().getDefaultInstance().copy();
        wheel.set(DataComponents.ENCHANTMENTS, (Object)((ItemEnchantments)this.getFrame().get(DataComponents.ENCHANTMENTS)));
        return wheel;
    }

    public ItemStack getLeftWheel() {
        return this.getWheel((ItemStack)this.getEntityData().get(LEFT_WHEEL));
    }

    public ItemStack getRightWheel() {
        return this.getWheel((ItemStack)this.getEntityData().get(RIGHT_WHEEL));
    }

    @Override
    public boolean hasParent() {
        return ((Optional)this.getEntityData().get(USER_ID)).isPresent();
    }

    @Override
    public boolean isParent(Entity entity) {
        return this.hasParent() && entity.getUUID().equals(((Optional)this.getEntityData().get(USER_ID)).get());
    }

    @Override
    public void parentTo(@Nullable LivingEntity entity) {
        if (this.level().isClientSide()) {
            return;
        }
        this.getEntityData().set(USER_ID, entity == null ? Optional.empty() : Optional.of(entity.getUUID()));
    }

    @Override
    public Vec3 getParentOffset(LivingEntity parent, float yaw, float pitch) {
        return IParentedEntity.rotateOffset(new Vec3(0.0, 0.0, 0.5), yaw);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide()) {
            this.serverTick();
        }
    }

    private void serverTick() {
        if (this.hasParent() && this.getParent() == null) {
            this.clearParent();
        }
    }

    @Override
    public void tickParented(@NotNull LivingEntity parent, float yaw, float pitch) {
        this.yRotO = yaw;
        this.yBodyRot = yaw;
        this.xRotO = 0.0f;
        this.setXRot(0.0f);
        if (!this.canParentToChild(parent, this)) {
            this.clearParent();
        }
    }

    public void move(MoverType movementType, Vec3 movement) {
        super.move(movementType, movement);
        Vector2d delta = new Vector2d(movement.x, movement.z);
        if (delta.length() == 0.0 || !this.level().isClientSide()) {
            return;
        }
        float spin = WHCUtils.calculateSpin((float)delta.length(), 0.3125f);
        this.spinLeft = WHCUtils.wrapDegrees(this.spinLeft + spin);
        this.spinRight = WHCUtils.wrapDegrees(this.spinRight + spin);
        this.caster.get(this.prevCaster);
        this.caster.add((Vector2dc)delta.mul(0.5)).normalize();
    }

    public float casterWheelYaw(float tickDelta) {
        Vector2d origin = this.prevCaster.get(new Vector2d());
        Vector2d current = this.caster.get(new Vector2d());
        origin.add((Vector2dc)current.sub((Vector2dc)origin).mul((double)tickDelta));
        return (float)Math.toDegrees(Math.atan2(origin.y, origin.x));
    }

    public boolean hasInventory() {
        return (Boolean)this.getEntityData().get(HAS_INV);
    }

    public void addInventory() {
        if (this.hasInventory()) {
            return;
        }
        this.setHasInventory(true);
        this.playSound((SoundEvent)SoundEvents.ARMOR_EQUIP_IRON.value(), this.getSoundVolume(), this.getVoicePitch());
    }

    public void setHasInventory(boolean bool) {
        this.getEntityData().set(HAS_INV, (Object)bool);
        this.onChestedStatusChanged();
    }

    public Container getInventory() {
        return this.items;
    }

    protected void onChestedStatusChanged() {
        if (!this.hasInventory() && !this.level().isClientSide()) {
            this.dropEquipment((ServerLevel)this.level());
        }
        SimpleContainer inv = this.items;
        this.items = new SimpleContainer(15);
        if (inv != null) {
            for (int j = 0; j < Math.min(inv.getContainerSize(), this.items.getContainerSize()); ++j) {
                ItemStack stack = inv.getItem(j);
                if (stack.isEmpty()) continue;
                this.items.setItem(j, stack.copy());
            }
        }
    }

    public void dropEquipment(ServerLevel world) {
        super.dropEquipment(world);
        if (this.items != null) {
            for (int i = 0; i < this.items.getContainerSize(); ++i) {
                ItemStack stack = this.items.getItem(i);
                if (stack.isEmpty() || EnchantmentHelper.has((ItemStack)stack, (DataComponentType)EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP)) continue;
                this.spawnAtLocation(world, stack);
                this.items.setItem(i, ItemStack.EMPTY);
            }
        }
    }
}

