/*
 * Decompiled with CFR 0.152.
 */
package com.lying.entity;

import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.lying.block.FrostedLavaBlock;
import com.lying.component.type.UpgradesComponent;
import com.lying.component.type.WheelComponent;
import com.lying.entity.ChairUpgrade;
import com.lying.entity.IFlyingMount;
import com.lying.entity.IParentedEntity;
import com.lying.entity.WheelchairsRideable;
import com.lying.init.WHCBlocks;
import com.lying.init.WHCChairUpgrades;
import com.lying.init.WHCDataComponentTypes;
import com.lying.init.WHCEnchantments;
import com.lying.init.WHCItems;
import com.lying.item.WheelchairItem;
import com.lying.mixin.AccessorEntity;
import com.lying.utility.ServerEvents;
import com.lying.utility.WHCUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.ItemBasedSteering;
import net.minecraft.world.entity.ItemSteerable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.effects.ReplaceDisk;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WheelchairEntity
extends WheelchairsRideable
implements PlayerRideableJumping,
ItemSteerable,
IFlyingMount,
IParentedEntity {
    private static final int REBIND_COOLDOWN = 60;
    public static final EntityDataSerializer<List<ChairUpgrade>> UPGRADE_LIST = EntityDataSerializer.forValueType((StreamCodec)ChairUpgrade.PACKET_CODEC.apply(ByteBufCodecs.list()));
    public static final EntityDataAccessor<ItemStack> CHAIR = SynchedEntityData.defineId(WheelchairEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    public static final EntityDataAccessor<OptionalInt> COLOR = SynchedEntityData.defineId(WheelchairEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UNSIGNED_INT);
    public static final EntityDataAccessor<ItemStack> LEFT_WHEEL = SynchedEntityData.defineId(WheelchairEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    public static final EntityDataAccessor<ItemStack> RIGHT_WHEEL = SynchedEntityData.defineId(WheelchairEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    public static final EntityDataAccessor<List<ChairUpgrade>> UPGRADES = SynchedEntityData.defineId(WheelchairEntity.class, UPGRADE_LIST);
    public static final EntityDataAccessor<Boolean> POWERED = SynchedEntityData.defineId(WheelchairEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Optional<UUID>> USER_ID = SynchedEntityData.defineId(WheelchairEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    public static final EntityDataAccessor<Integer> REBIND = SynchedEntityData.defineId(WheelchairEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> FLYING = SynchedEntityData.defineId(WheelchairEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> BOOST_TIME = SynchedEntityData.defineId(WheelchairEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final ItemBasedSteering saddledComponent = new ItemBasedSteering(this.entityData, BOOST_TIME, POWERED);
    protected SimpleContainer items;
    protected float jumpStrength = 0.0f;
    private LivingEntity user = null;
    public float spinLeft;
    public float spinRight;

    public WheelchairEntity(EntityType<? extends WheelchairEntity> entityType, Level world) {
        super(entityType, world);
        this.onChestedStatusChanged();
    }

    public void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(CHAIR, (Object)((Item)WHCItems.WHEELCHAIR_OAK.get()).getDefaultInstance());
        builder.define(COLOR, (Object)OptionalInt.of(-6265536));
        builder.define(LEFT_WHEEL, (Object)WheelComponent.DEFAULT_WHEEL.get());
        builder.define(RIGHT_WHEEL, (Object)WheelComponent.DEFAULT_WHEEL.get());
        builder.define(UPGRADES, (Object)Lists.newArrayList());
        builder.define(POWERED, (Object)false);
        builder.define(USER_ID, Optional.empty());
        builder.define(REBIND, (Object)0);
        builder.define(FLYING, (Object)false);
        builder.define(BOOST_TIME, (Object)0);
    }

    public static AttributeSupplier.Builder createWheelchairAttributes() {
        return WheelchairEntity.createMountAttributes().add(Attributes.STEP_HEIGHT, 1.0);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> data) {
        if (BOOST_TIME.equals(data) && this.level().isClientSide()) {
            this.saddledComponent.onSynced();
        }
        super.onSyncedDataUpdated(data);
    }

    public void readAdditionalSaveData(CompoundTag data) {
        super.readAdditionalSaveData(data);
        if (data.contains("Chair", 10)) {
            this.getEntityData().set(CHAIR, (Object)((ItemStack)ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)data.getCompound("Chair")).get()));
        }
        if (data.contains("Color", 3)) {
            this.getEntityData().set(COLOR, (Object)OptionalInt.of(data.getInt("Color")));
        }
        if (data.contains("Wheels", 10)) {
            CompoundTag wheels = data.getCompound("Wheels");
            this.getEntityData().set(LEFT_WHEEL, (Object)((ItemStack)ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)wheels.getCompound("Left")).get()));
            this.getEntityData().set(RIGHT_WHEEL, (Object)((ItemStack)ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)wheels.getCompound("Right")).get()));
        }
        if (data.contains("Upgrades")) {
            this.setUpgrades(ChairUpgrade.decodeList(NbtOps.INSTANCE, data.get("Upgrades")));
        }
        this.onChestedStatusChanged();
        if (this.hasUpgrade(WHCChairUpgrades.STORAGE.get())) {
            ListTag items = data.getList("Items", 10);
            for (int i = 0; i < items.size(); ++i) {
                CompoundTag nbt = items.getCompound(i);
                int j = nbt.getByte("Slot") & 0xFF;
                if (j >= this.items.getContainerSize()) continue;
                this.items.setItem(j, ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)nbt).orElse(ItemStack.EMPTY));
            }
        }
    }

    public void addAdditionalSaveData(CompoundTag data) {
        super.addAdditionalSaveData(data);
        data.put("Chair", ((ItemStack)this.getEntityData().get(CHAIR)).save((HolderLookup.Provider)this.registryAccess()));
        if (((OptionalInt)this.getEntityData().get(COLOR)).isPresent()) {
            data.putInt("Color", this.getColor());
        }
        CompoundTag wheels = new CompoundTag();
        wheels.put("Left", this.getLeftWheel().save((HolderLookup.Provider)this.registryAccess()));
        wheels.put("Right", this.getRightWheel().save((HolderLookup.Provider)this.registryAccess()));
        data.put("Wheels", (Tag)wheels);
        if (!this.getUpgrades().isEmpty()) {
            data.put("Upgrades", (Tag)ChairUpgrade.encodeList(NbtOps.INSTANCE, this.getUpgrades()));
            if (this.hasUpgrade(WHCChairUpgrades.STORAGE.get())) {
                ListTag items = new ListTag();
                for (int i = 0; i < this.items.getContainerSize(); ++i) {
                    ItemStack stack = this.items.getItem(i);
                    if (stack.isEmpty()) continue;
                    CompoundTag nbt = new CompoundTag();
                    nbt.putByte("Slot", (byte)i);
                    items.add((Object)stack.save((HolderLookup.Provider)this.registryAccess(), (Tag)nbt));
                }
                data.put("Items", (Tag)items);
            }
        }
    }

    public List<ChairUpgrade> getUpgrades() {
        return Lists.newArrayList((Iterable)((Iterable)this.getEntityData().get(UPGRADES)));
    }

    public boolean hasUpgrade(ChairUpgrade upgrade) {
        return this.getUpgrades().stream().anyMatch(u -> u.equals(upgrade));
    }

    protected void setUpgrades(List<ChairUpgrade> newSet) {
        List<ChairUpgrade> oldSet = this.getUpgrades();
        List upgrades = newSet.stream().filter(Predicates.notNull()).toList();
        oldSet.stream().filter(u -> !upgrades.contains(u)).forEach(u -> u.removeFrom(this));
        upgrades.stream().filter(u -> !oldSet.contains(u)).forEach(u -> u.applyTo(this));
        this.getEntityData().set(UPGRADES, upgrades);
    }

    public void addUpgrade(ChairUpgrade upgrade) {
        if (this.hasUpgrade(upgrade)) {
            return;
        }
        List<ChairUpgrade> upgrades = this.getUpgrades();
        upgrades.add(upgrade);
        this.setUpgrades(upgrades);
        this.onChestedStatusChanged();
        this.playSound((SoundEvent)SoundEvents.ARMOR_EQUIP_IRON.value(), this.getSoundVolume(), this.getVoicePitch());
    }

    public void removeUpgrade(ChairUpgrade upgrade) {
        if (!this.hasUpgrade(upgrade) || this.isVehicle()) {
            return;
        }
        List<ChairUpgrade> upgrades = this.getUpgrades();
        upgrades.removeIf(u -> u.equals(upgrade));
        this.setUpgrades(upgrades);
        this.onChestedStatusChanged();
        this.dropItem((ItemLike)upgrade.dropItem());
        this.playSound(SoundEvents.AXE_STRIP, this.getSoundVolume(), this.getVoicePitch());
    }

    public boolean hasInventory() {
        return this.hasUpgrade(WHCChairUpgrades.STORAGE.get()) || this.hasUpgrade(WHCChairUpgrades.PLACER.get());
    }

    public Container getInventory() {
        return this.items;
    }

    protected void onChestedStatusChanged() {
        if (!this.hasInventory() && !this.level().isClientSide()) {
            this.dropEquipment((ServerLevel)this.level());
        }
        SimpleContainer inv = this.items;
        this.items = new SimpleContainer(16);
        if (inv != null) {
            ItemStack stackInPlacer = inv.getItem(0);
            if (!stackInPlacer.isEmpty()) {
                if (this.hasUpgrade(WHCChairUpgrades.PLACER.get())) {
                    this.items.setItem(0, stackInPlacer.copy());
                } else if (!EnchantmentHelper.has((ItemStack)stackInPlacer, (DataComponentType)EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP)) {
                    this.dropStack(stackInPlacer);
                }
            }
            for (int i = 1; i < inv.getContainerSize(); ++i) {
                ItemStack stack = inv.getItem(i);
                if (stack.isEmpty()) continue;
                if (this.hasUpgrade(WHCChairUpgrades.STORAGE.get())) {
                    this.items.setItem(i, stack.copy());
                    continue;
                }
                if (EnchantmentHelper.has((ItemStack)stack, (DataComponentType)EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP)) continue;
                this.dropStack(stack);
            }
        }
    }

    public void dropEquipment(ServerLevel world) {
        super.dropEquipment(world);
        if (this.items != null) {
            for (int i = 0; i < this.items.getContainerSize(); ++i) {
                ItemStack stack = this.items.getItem(i);
                if (stack.isEmpty() || EnchantmentHelper.has((ItemStack)stack, (DataComponentType)EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP)) continue;
                this.spawnAtLocation(world, stack);
                this.items.setItem(i, ItemStack.EMPTY);
            }
        }
    }

    @Override
    public InteractionResult interact(Player player, InteractionHand hand) {
        ItemStack heldStack = player.getItemInHand(hand);
        if (player.isSecondaryUseActive() && !this.isVehicle() && !this.hasParent()) {
            if (heldStack.is(ItemTags.AXES)) {
                List<ChairUpgrade> upgrades = this.getUpgrades();
                if (upgrades.isEmpty()) {
                    return InteractionResult.FAIL;
                }
                this.removeUpgrade(upgrades.get(upgrades.size() - 1));
                if (!player.isCreative()) {
                    heldStack.hurtWithoutBreaking(1, player);
                }
                return InteractionResult.SUCCESS_SERVER.heldItemTransformedTo(heldStack);
            }
            ArrayList possibleUpgrades = Lists.newArrayList();
            possibleUpgrades.addAll(WHCChairUpgrades.fromItem(heldStack, this));
            if (!possibleUpgrades.isEmpty()) {
                this.addUpgrade((ChairUpgrade)possibleUpgrades.stream().findFirst().get());
                if (!player.getAbilities().instabuild) {
                    heldStack.shrink(1);
                }
                return InteractionResult.SUCCESS_SERVER.heldItemTransformedTo(heldStack);
            }
        }
        if (player.isSecondaryUseActive() && !this.isVehicle() && !this.hasParent()) {
            this.convertToItem(null);
            return InteractionResult.CONSUME;
        }
        if (!this.level().isClientSide()) {
            if (this.isVehicle() && !this.hasPassenger((Entity)player) && this.hasUpgrade(WHCChairUpgrades.HANDLES.get()) && this.rebindCooldown() <= 0) {
                return IParentedEntity.bindToPlayer(player, this) ? InteractionResult.CONSUME : InteractionResult.PASS;
            }
            if (!this.isVehicle()) {
                return this.putPlayerInSaddle(player) ? InteractionResult.CONSUME : InteractionResult.PASS;
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public <T extends WheelchairsRideable> ItemStack entityToItem(T entity) {
        WheelchairEntity chair = (WheelchairEntity)entity;
        ItemStack stack = chair.getChair();
        WheelchairItem.setWheels(stack, chair.getLeftWheel(), chair.getRightWheel());
        if (chair.hasColor() && stack.getItem() instanceof WheelchairItem) {
            stack.set(DataComponents.DYED_COLOR, (Object)new DyedItemColor(chair.getColor(), true));
        }
        stack.set((DataComponentType)WHCDataComponentTypes.UPGRADES.get(), (Object)UpgradesComponent.fromList(chair.getUpgrades()));
        return stack;
    }

    @Override
    public void copyFromItem(ItemStack stack) {
        List<ChairUpgrade> upgrades;
        stack.getComponents().has(DataComponents.DYED_COLOR);
        this.getEntityData().set(CHAIR, (Object)stack.copy());
        this.getEntityData().set(COLOR, (Object)(stack.getComponents().has(DataComponents.DYED_COLOR) ? OptionalInt.of(DyedItemColor.getOrDefault((ItemStack)stack, (int)-1)) : OptionalInt.empty()));
        this.getEntityData().set(LEFT_WHEEL, (Object)WheelchairItem.getWheel(stack, HumanoidArm.LEFT));
        this.getEntityData().set(RIGHT_WHEEL, (Object)WheelchairItem.getWheel(stack, HumanoidArm.RIGHT));
        if (stack.has((DataComponentType)WHCDataComponentTypes.UPGRADES.get()) && !(upgrades = ((UpgradesComponent)stack.get((DataComponentType)WHCDataComponentTypes.UPGRADES.get())).asList()).isEmpty()) {
            this.setUpgrades(upgrades);
        }
    }

    @Override
    public void convertToItem(@Nullable Player player) {
        if (!this.level().isClientSide()) {
            ItemStack stack = this.entityToItem(this);
            ItemEntity item = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), stack);
            this.dropEquipment((ServerLevel)this.level());
            if (player == null || !player.getInventory().add(stack)) {
                this.level().addFreshEntity((Entity)item);
            }
            this.discard();
        }
    }

    public LivingEntity getControllingPassenger() {
        return !this.hasParent() && this.getFirstPassenger() instanceof LivingEntity ? (LivingEntity)this.getFirstPassenger() : null;
    }

    protected float getFlyingSpeed() {
        return this.getSpeed() * 0.1f;
    }

    public void aiStep() {
        LivingEntity rider = null;
        if (this.isFallFlying() && (rider = (LivingEntity)this.getFirstPassenger()) != null) {
            this.orientToRider(rider, Vec3.ZERO);
        }
        super.aiStep();
    }

    public boolean isManual(Player controllingPlayer) {
        return !this.isAutomatic(controllingPlayer);
    }

    public boolean isAutomatic(Player controllingPlayer) {
        return this.hasUpgrade(WHCChairUpgrades.POWERED.get()) && controllingPlayer.isHolding((Item)WHCItems.CONTROLLER.get());
    }

    public boolean isShiftKeyDown() {
        return super.isShiftKeyDown() || this.isVehicle() && this.getFirstPassenger() instanceof LivingEntity && this.getFirstPassenger().isShiftKeyDown();
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.clientTick();
        } else {
            this.serverTick();
        }
    }

    private void clientTick() {
        if (this.saddledComponent.boostFactor() > 1.0f) {
            this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX(), this.getY() + 0.5, this.getZ(), 0.0, 0.0, 0.0);
        }
        if (this.hasUpgrade(WHCChairUpgrades.DIVING.get()) && this.isEyeInFluid(FluidTags.WATER)) {
            this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, this.getX(), this.getY() + 1.5, this.getZ(), 0.0, 0.0, 0.0);
        }
    }

    private void serverTick() {
        if (this.hasControllingPassenger() && this.onGround() && !this.isFallFlying() && this.tickCount % 5 == 0 && this.hasUpgrade(WHCChairUpgrades.PLACER.get())) {
            Container inv = this.getInventory();
            ItemStack stack = inv.getItem(0);
            this.tryPlaceBlock(stack);
        }
        if (this.hasParent() && this.getParent() == null) {
            this.parentTo(null);
        }
        if (this.rebindCooldown() > 0) {
            this.getEntityData().set(REBIND, (Object)(this.rebindCooldown() - 1));
        }
    }

    private boolean tryPlaceBlock(ItemStack stack) {
        if (stack.isEmpty() || !(stack.getItem() instanceof BlockItem) || this.level().isClientSide()) {
            return false;
        }
        BlockItem item = (BlockItem)stack.getItem();
        ServerLevel world = (ServerLevel)this.level();
        Direction direction = Direction.DOWN;
        BlockPos blockPos = this.blockPosition().relative(direction);
        if (world.getBlockState(blockPos).getBlock() == item.getBlock()) {
            return false;
        }
        return item.place((BlockPlaceContext)new DirectionalPlaceContext((Level)world, blockPos, direction, stack, direction)).consumesAction();
    }

    @Override
    protected void tickRidden(Player controllingPlayer, Vec3 movementInput) {
        super.tickRidden(controllingPlayer, this.stuckSpeedMultiplier);
        if (!this.isManual(controllingPlayer) && this.isSprinting()) {
            this.setSprinting(false);
            controllingPlayer.setSprinting(false);
        }
        this.orientToRider((LivingEntity)controllingPlayer, movementInput);
        this.saddledComponent.tickBoost();
        ItemStack chair = this.getChair();
        ItemEnchantments comp = (ItemEnchantments)chair.get(DataComponents.ENCHANTMENTS);
        if (comp != null && !comp.isEmpty()) {
            if (!controllingPlayer.isOnFire()) {
                WHCEnchantments.getFireProtection(this.registryAccess()).ifPresent(f -> {
                    int fireProtectionLevel = comp.getLevel((Holder)f);
                    if (fireProtectionLevel > 0) {
                        controllingPlayer.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 100 * fireProtectionLevel, 0, false, false, true));
                    }
                });
            }
            if (!this.isEyeInFluid(FluidTags.WATER)) {
                WHCEnchantments.getRespiration(this.registryAccess()).ifPresent(r -> {
                    int respirationLevel = comp.getLevel((Holder)r);
                    if (respirationLevel > 0) {
                        controllingPlayer.addEffect(new MobEffectInstance(MobEffects.WATER_BREATHING, 100 * respirationLevel, 0, false, false, true));
                    }
                });
            }
        }
        if (this.jumpStrength > 0.0f) {
            if (!this.onGround() && this.canStartFlying()) {
                ((ServerEvents.DoubleJumpEvent)ServerEvents.ON_DOUBLE_JUMP.invoker()).onDoubleJump(this);
                this.startFlying();
            } else {
                this.jumpFromGround();
            }
        }
        this.jumpStrength = 0.0f;
    }

    @Override
    protected void orientToRider(LivingEntity controllingPlayer, Vec3 movementInput) {
        if (movementInput.length() > 0.0 || !this.hasUpgrade(WHCChairUpgrades.POWERED.get())) {
            super.orientToRider(controllingPlayer, movementInput);
        }
    }

    public boolean isCrouching() {
        return super.isCrouching() || this.isShiftKeyDown();
    }

    protected Vec3 maybeBackOffFromEdge(Vec3 movement, MoverType type) {
        if (movement.y <= 0.0 && (type == MoverType.SELF || type == MoverType.PLAYER) && this.isShiftKeyDown() && this.shouldClipMovement()) {
            double deltaX = movement.x;
            double deltaZ = movement.z;
            while (deltaX != 0.0 && this.level().noCollision((Entity)this, this.getBoundingBox().move(deltaX, (double)(-this.maxUpStep()), 0.0))) {
                if (deltaX < 0.05 && deltaX >= -0.05) {
                    deltaX = 0.0;
                    continue;
                }
                if (deltaX > 0.0) {
                    deltaX -= 0.05;
                    continue;
                }
                deltaX += 0.05;
            }
            while (deltaZ != 0.0 && this.level().noCollision((Entity)this, this.getBoundingBox().move(0.0, (double)(-this.maxUpStep()), deltaZ))) {
                if (deltaZ < 0.05 && deltaZ >= -0.05) {
                    deltaZ = 0.0;
                    continue;
                }
                if (deltaZ > 0.0) {
                    deltaZ -= 0.05;
                    continue;
                }
                deltaZ += 0.05;
            }
            while (deltaX != 0.0 && deltaZ != 0.0 && this.level().noCollision((Entity)this, this.getBoundingBox().move(deltaX, (double)(-this.maxUpStep()), deltaZ))) {
                double d = deltaX < 0.05 && deltaX >= -0.05 ? 0.0 : (deltaX = deltaX > 0.0 ? (deltaX = deltaX - 0.05) : (deltaX = deltaX + 0.05));
                if (deltaZ < 0.05 && deltaZ >= -0.05) {
                    deltaZ = 0.0;
                    continue;
                }
                if (deltaZ > 0.0) {
                    deltaZ -= 0.05;
                    continue;
                }
                deltaZ += 0.05;
            }
            movement = new Vec3(deltaX, movement.y, deltaZ);
        }
        return movement;
    }

    public boolean shouldClipMovement() {
        return this.onGround() || this.fallDistance < this.maxUpStep() && !this.level().noCollision((Entity)this, this.getBoundingBox().move(0.0, (double)(this.fallDistance - this.maxUpStep()), 0.0));
    }

    @Override
    protected void positionRider(Entity passenger, Entity.MoveFunction positionUpdater) {
        super.positionRider(passenger, positionUpdater);
        if (passenger instanceof LivingEntity) {
            this.clampPassengerYaw(passenger);
        }
    }

    @Override
    protected void clampPassengerYaw(Entity passenger) {
        passenger.setYBodyRot(this.getYRot());
        float f = Mth.wrapDegrees((float)(passenger.getYRot() - this.getYRot()));
        float g = Mth.clamp((float)f, (float)-105.0f, (float)105.0f);
        passenger.yRotO += g - f;
        passenger.setYRot(passenger.getYRot() + g - f);
        passenger.setYHeadRot(passenger.getYRot());
    }

    public void setRot(float yaw, float pitch) {
        float prevYaw = this.getYRot();
        super.setRot(yaw, pitch);
        float amount = this.getYRot() - prevYaw;
        if (amount == 0.0f || amount == 360.0f) {
            return;
        }
        if (this.isFallFlying()) {
            return;
        }
        this.spinLeft = WHCUtils.wrapDegrees(this.spinLeft + amount);
        this.spinRight = WHCUtils.wrapDegrees(this.spinRight - amount);
    }

    public boolean onClimbable() {
        return super.onClimbable() && !this.hasUpgrade(WHCChairUpgrades.POWERED.get());
    }

    @Override
    public boolean isSaddled() {
        return true;
    }

    @Override
    protected Vec2 getControlledRotation(LivingEntity controllingPassenger) {
        return new Vec2(controllingPassenger.getXRot(), controllingPassenger.getYRot());
    }

    protected Vec3 getRiddenInput(Player controllingPlayer, Vec3 movementInput) {
        if (this.isFallFlying()) {
            return this.getDeltaMovement();
        }
        double modifier = 1.0;
        if (!this.onGround() && !this.hasUpgrade(WHCChairUpgrades.GLIDING.get())) {
            modifier = this.shouldBobUp() ? 0.9 : 0.7;
        }
        Vec3 speed = this.isAutomatic(controllingPlayer) ? new Vec3(0.0, 0.0, 1.0) : new Vec3(0.0, 0.0, (double)controllingPlayer.zza);
        return speed.scale(modifier);
    }

    protected float getRiddenSpeed(Player controllingPlayer) {
        return (float)controllingPlayer.getAttributeValue(Attributes.MOVEMENT_SPEED) * (this.isManual(controllingPlayer) ? 1.0f : this.saddledComponent.boostFactor());
    }

    @Override
    public void move(MoverType type, Vec3 movementInput) {
        double x = this.getX();
        double z = this.getZ();
        for (Entity rider : this.getPassengers()) {
            movementInput = ((AccessorEntity)rider).adjustToPreventCollision(movementInput);
        }
        super.move(type, movementInput);
        this.tickExhaustion(this.getX() - x, this.getZ() - z);
        if (this.level().isClientSide() && !this.isFallFlying()) {
            Vec3 local = WHCUtils.globalToLocal(movementInput, this.getYRot());
            double speed = WHCUtils.calculateSpin((float)local.z(), 1.0f);
            this.spinLeft = WHCUtils.wrapDegrees(this.spinLeft + (float)speed);
            this.spinRight = WHCUtils.wrapDegrees(this.spinRight + (float)speed);
        }
    }

    @Override
    public float getActualStepHeight() {
        return 1.0f;
    }

    public void travelControlled(Player controllingPlayer, Vec3 movementInput) {
        if (this.shouldBobUp()) {
            this.push(0.0, 0.08, 0.0);
        }
        super.travel(movementInput);
    }

    protected boolean shouldBobUp() {
        double swimHeight = this.getFluidJumpThreshold();
        return this.hasUpgrade(WHCChairUpgrades.FLOATING.get()) && (this.getFluidHeight(FluidTags.WATER) > swimHeight || this.hasUpgrade(WHCChairUpgrades.NETHERITE.get()) && this.getFluidHeight(FluidTags.LAVA) > swimHeight);
    }

    public void onChangedBlock(ServerLevel world, BlockPos pos) {
        super.onChangedBlock(world, pos);
        ItemStack chair = this.getChair();
        ItemEnchantments comp = (ItemEnchantments)chair.get(DataComponents.ENCHANTMENTS);
        if (comp == null || comp.isEmpty()) {
            return;
        }
        if (this.onGround() && this.hasUpgrade(WHCChairUpgrades.NETHERITE.get())) {
            List<Holder> frostWalkers = comp.keySet().stream().filter(ench -> {
                DataComponentMap effects = ((Enchantment)ench.value()).effects();
                if (!effects.has(EnchantmentEffectComponents.LOCATION_CHANGED)) {
                    return false;
                }
                return ((List)effects.get(EnchantmentEffectComponents.LOCATION_CHANGED)).stream().filter(e -> e.effect() instanceof ReplaceDisk && ((ReplaceDisk)e.effect()).blockState().getState(this.getRandom(), this.blockPosition()).is(Blocks.FROSTED_ICE)).findFirst().isPresent();
            }).toList();
            frostWalkers.stream().map(e -> EnchantmentHelper.getItemEnchantmentLevel((Holder)e, (ItemStack)chair)).sorted().findFirst().ifPresent(level -> WheelchairEntity.freezeLava(this, this.level(), this.blockPosition(), level));
        }
    }

    public boolean causeFallDamage(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        if (this.isFlying()) {
            if (!this.level().isClientSide()) {
                this.stopFlying();
            }
            return false;
        }
        return !this.isFlying() && super.causeFallDamage(fallDistance, damageMultiplier, damageSource);
    }

    protected static void freezeLava(LivingEntity entity, Level world, BlockPos blockPos, int level) {
        BlockState frosted = ((Block)WHCBlocks.FROSTED_LAVA.get()).defaultBlockState();
        int range = Math.min(16, 2 + level);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)blockPos.offset(-range, -1, -range), (BlockPos)blockPos.offset(range, -1, range))) {
            if (!pos.closerToCenterThan((Position)entity.position(), (double)range)) continue;
            mutable.set(pos.getX(), pos.getY() + 1, pos.getZ());
            BlockState stateAbove = world.getBlockState((BlockPos)mutable);
            if (!stateAbove.isAir() || world.getBlockState(pos) != FrostedLavaBlock.getMeltedState() || !frosted.canSurvive((LevelReader)world, pos) || !world.isUnobstructed(frosted, pos, CollisionContext.empty())) continue;
            world.setBlockAndUpdate(pos, frosted);
            world.scheduleTick(pos, (Block)WHCBlocks.FROSTED_LAVA.get(), Mth.nextInt((RandomSource)entity.getRandom(), (int)60, (int)120));
        }
    }

    public boolean canSprint() {
        return !this.hasUpgrade(WHCChairUpgrades.POWERED.get()) && this.getControllingPassenger() != null && this.getControllingPassenger().getType() == EntityType.PLAYER;
    }

    public int getEnchantmentLevel(Holder<Enchantment> ench) {
        return EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)((ItemStack)this.getEntityData().get(CHAIR))).getLevel(ench);
    }

    protected Vec3 getPassengerAttachmentPoint(Entity passenger, EntityDimensions dimensions, float scaleFactor) {
        return new Vec3(0.0, (double)(dimensions.height() * 0.85f * scaleFactor), 0.0);
    }

    public boolean hasEffect(Holder<MobEffect> effect) {
        if (this.isVehicle() && this.getControllingPassenger() instanceof LivingEntity) {
            return this.getControllingPassenger().hasEffect(effect);
        }
        return false;
    }

    public MobEffectInstance getEffect(Holder<MobEffect> effect) {
        if (this.isVehicle() && this.getControllingPassenger() instanceof LivingEntity) {
            return this.getControllingPassenger().getEffect(effect);
        }
        return null;
    }

    public Iterable<ItemStack> getArmorSlots() {
        return NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    }

    public boolean canEquip(ItemStack stack) {
        return false;
    }

    public ItemStack getItemBySlot(EquipmentSlot slot) {
        return slot == EquipmentSlot.FEET ? WheelchairEntity.getEnchantments(this.getChair()) : ItemStack.EMPTY;
    }

    public static ItemStack getEnchantments(ItemStack chair) {
        ItemStack spoof = Items.STONE.getDefaultInstance();
        spoof.set(DataComponents.ENCHANTMENTS, (Object)((ItemEnchantments)chair.get(DataComponents.ENCHANTMENTS)));
        return spoof;
    }

    public void setItemSlot(EquipmentSlot var1, ItemStack var2) {
    }

    public ItemStack getChair() {
        ItemStack stack = (ItemStack)this.getEntityData().get(CHAIR);
        return stack.getItem() instanceof WheelchairItem ? stack : new ItemStack(WHCItems.WHEELCHAIR_OAK);
    }

    public boolean hasColor() {
        return ((OptionalInt)this.getEntityData().get(COLOR)).isPresent();
    }

    public int getColor() {
        return ((OptionalInt)this.getEntityData().get(COLOR)).orElse(-1);
    }

    public ItemStack getWheel(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.getLeftWheel() : this.getRightWheel();
    }

    protected ItemStack getWheel(ItemStack actualWheel) {
        ItemStack wheel = actualWheel.getItem().getDefaultInstance().copy();
        wheel.set(DataComponents.ENCHANTMENTS, (Object)((ItemEnchantments)this.getChair().get(DataComponents.ENCHANTMENTS)));
        return wheel;
    }

    public ItemStack getLeftWheel() {
        return this.getWheel((ItemStack)this.getEntityData().get(LEFT_WHEEL));
    }

    public ItemStack getRightWheel() {
        return this.getWheel((ItemStack)this.getEntityData().get(RIGHT_WHEEL));
    }

    public boolean boost() {
        return this.saddledComponent.boost(this.getRandom());
    }

    public void onPlayerJump(int strength) {
        if (strength < 0) {
            strength = 0;
        }
        this.jumpStrength = strength > 0 ? 1.0f : 0.0f;
    }

    public boolean canJump() {
        return this.hasUpgrade(WHCChairUpgrades.DIVING.get()) && this.isEyeInFluid(FluidTags.WATER) || this.canStartFlying();
    }

    public void handleStartJump(int var1) {
    }

    public void handleStopJump() {
    }

    @Override
    public boolean canFly() {
        return this.hasUpgrade(WHCChairUpgrades.GLIDING.get());
    }

    @Override
    public boolean isFlying() {
        return (Boolean)this.getEntityData().get(FLYING);
    }

    public boolean isFallFlying() {
        return this.isFlying() || super.isFallFlying();
    }

    @Override
    public boolean canUseRocket() {
        return true;
    }

    @Override
    public void startFlying() {
        this.getEntityData().set(FLYING, (Object)true);
        this.playSound((SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), this.getSoundVolume(), this.getVoicePitch());
    }

    @Override
    public void stopFlying() {
        this.getEntityData().set(FLYING, (Object)false);
        this.playSound((SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), this.getSoundVolume(), this.getVoicePitch() * 0.5f);
    }

    @Override
    public boolean hasParent() {
        return this.hasUpgrade(WHCChairUpgrades.HANDLES.get()) && ((Optional)this.getEntityData().get(USER_ID)).isPresent();
    }

    @Override
    public boolean isParent(Entity entity) {
        return this.hasParent() && ((UUID)((Optional)this.getEntityData().get(USER_ID)).get()).equals(entity.getUUID());
    }

    @Override
    @Nullable
    public LivingEntity getParent() {
        if (!this.hasParent()) {
            return null;
        }
        return this.user == null ? (this.user = IParentedEntity.getParentOf(this)) : this.user;
    }

    @Override
    public void parentTo(@Nullable LivingEntity parent) {
        if (!this.hasUpgrade(WHCChairUpgrades.HANDLES.get()) || this.hasPassenger((Entity)parent)) {
            return;
        }
        this.getEntityData().set(USER_ID, parent == null ? Optional.empty() : Optional.of(parent.getUUID()));
    }

    @Override
    public Vec3 getParentOffset(LivingEntity parent, float yaw, float pitch) {
        return WHCUtils.localToGlobal(new Vec3(0.0, 0.0, 0.75), parent.yBodyRot);
    }

    @Override
    public void tickParented(@NotNull LivingEntity parent, float yaw, float pitch) {
        this.setRot(parent.yBodyRot, 0.0f);
        if (!this.canParentToChild(parent, this)) {
            this.clearParent();
        }
    }

    public void doPush(Entity entity) {
        if (!this.isParent(entity)) {
            super.doPush(entity);
        }
    }

    public void push(Entity entity) {
        if (!this.isParent(entity)) {
            super.push(entity);
        }
    }

    public void forceUnbind() {
        if (!this.hasParent()) {
            return;
        }
        this.clearParent();
        this.resetRebindCooldown();
    }

    public int rebindCooldown() {
        return (Integer)this.getEntityData().get(REBIND);
    }

    public void resetRebindCooldown() {
        this.getEntityData().set(REBIND, (Object)60);
    }
}

