/*
 * Decompiled with CFR 0.152.
 */
package com.lying.entity;

import com.lying.mixin.AccessorEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class WheelchairsRideable
extends LivingEntity {
    protected WheelchairsRideable(EntityType<? extends LivingEntity> entityType, Level world) {
        super(entityType, world);
    }

    public static AttributeSupplier.Builder createMountAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 1.0).add(Attributes.MOVEMENT_SPEED, (double)0.1f).add(Attributes.STEP_HEIGHT, 1.0);
    }

    public abstract void copyFromItem(ItemStack var1);

    public abstract <T extends WheelchairsRideable> ItemStack entityToItem(T var1);

    public void convertToItem(@Nullable Player player) {
        if (this.level().isClientSide()) {
            return;
        }
        ItemStack stack = this.entityToItem(this);
        ItemEntity item = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), stack);
        this.dropEquipment((ServerLevel)this.level());
        if (player == null || !player.getInventory().add(stack)) {
            this.level().addFreshEntity((Entity)item);
        }
        this.discard();
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        if (player.isSecondaryUseActive() && !this.isVehicle()) {
            this.convertToItem(null);
            return InteractionResult.CONSUME;
        }
        if (!this.level().isClientSide() && !this.isVehicle()) {
            return this.putPlayerInSaddle(player) ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    public HumanoidArm getMainArm() {
        return HumanoidArm.RIGHT;
    }

    public boolean canRide(Entity entity) {
        return false;
    }

    protected void tickRidden(Player controllingPlayer, Vec3 movementInput) {
        super.tickRidden(controllingPlayer, this.stuckSpeedMultiplier);
        this.orientToRider((LivingEntity)controllingPlayer, movementInput);
    }

    protected void orientToRider(LivingEntity controllingPlayer, Vec3 movementInput) {
        Vec2 orientation = this.getControlledRotation(controllingPlayer);
        this.setRot(orientation.y, orientation.x);
        this.yRotO = this.yHeadRot;
        this.yBodyRot = this.yHeadRot = this.getYRot();
    }

    public boolean isSaddled() {
        return true;
    }

    public int getDimensionChangingDelay() {
        return 10;
    }

    public boolean canUsePortals() {
        return !this.isPassenger() && !this.isSleeping();
    }

    protected boolean putPlayerInSaddle(Player player) {
        if (this.isVehicle() || this.level().isClientSide()) {
            return false;
        }
        player.setYRot(this.getYRot());
        player.setXRot(this.getXRot());
        player.startRiding((Entity)this);
        return true;
    }

    protected boolean canAddPassenger(Entity passenger) {
        return !this.isVehicle() && passenger instanceof LivingEntity;
    }

    protected Vec2 getControlledRotation(LivingEntity controllingPassenger) {
        return new Vec2(controllingPassenger.getXRot(), controllingPassenger.getYRot());
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity passenger) {
        Vec3 dismountRight = AbstractHorse.getCollisionHorizontalEscapeVector((double)this.getBbWidth(), (double)passenger.getBbWidth(), (float)(this.getYRot() + (passenger.getMainArm() == HumanoidArm.RIGHT ? 90.0f : -90.0f)));
        Vec3 dismountPos = this.locateSafeDismountingPos(dismountRight, passenger);
        if (dismountPos != null) {
            return dismountPos;
        }
        Vec3 dismountLeft = AbstractHorse.getCollisionHorizontalEscapeVector((double)this.getBbWidth(), (double)passenger.getBbWidth(), (float)(this.getYRot() + (passenger.getMainArm() == HumanoidArm.LEFT ? 90.0f : -90.0f)));
        dismountPos = this.locateSafeDismountingPos(dismountLeft, passenger);
        if (dismountPos != null) {
            return dismountPos;
        }
        return this.position();
    }

    @Nullable
    private Vec3 locateSafeDismountingPos(Vec3 offset, LivingEntity passenger) {
        double d = this.getX() + offset.x;
        double e = this.getBoundingBox().minY;
        double f = this.getZ() + offset.z;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        block0: for (Pose entityPose : passenger.getDismountPoses()) {
            mutable.set(d, e, f);
            double g = this.getBoundingBox().maxY + 0.75;
            do {
                double h = this.level().getBlockFloorHeight((BlockPos)mutable);
                if ((double)mutable.getY() + h > g) continue block0;
                if (DismountHelper.isBlockFloorValid((double)h)) {
                    AABB box = passenger.getLocalBoundsForPose(entityPose);
                    Vec3 vec3d = new Vec3(d, (double)mutable.getY() + h, f);
                    if (DismountHelper.canDismountTo((CollisionGetter)this.level(), (LivingEntity)passenger, (AABB)box.move(vec3d))) {
                        passenger.setPose(entityPose);
                        return vec3d;
                    }
                }
                mutable.move(Direction.UP);
            } while ((double)mutable.getY() < g);
        }
        return null;
    }

    protected void positionRider(Entity passenger, Entity.MoveFunction positionUpdater) {
        super.positionRider(passenger, positionUpdater);
        if (passenger instanceof LivingEntity) {
            this.clampPassengerYaw(passenger);
        }
    }

    public void onPassengerTurned(Entity passenger) {
        this.clampPassengerYaw(passenger);
    }

    protected abstract void clampPassengerYaw(Entity var1);

    public boolean isInvulnerableTo(ServerLevel world, DamageSource damageSource) {
        DamageSources sources = world.damageSources();
        return damageSource != sources.fellOutOfWorld() && damageSource != sources.genericKill();
    }

    public boolean canBeAffected(MobEffectInstance effect) {
        return false;
    }

    public int getAirSupply() {
        return 20;
    }

    protected void tickExhaustion(double deltaX, double deltaZ) {
        Player rider;
        if (this.level().isClientSide() || !this.isVehicle()) {
            return;
        }
        Player player = rider = this.getControllingPassenger() == null || this.getControllingPassenger().getType() != EntityType.PLAYER ? null : (Player)this.getControllingPassenger();
        if (rider == null) {
            return;
        }
        int i = Math.round((float)Math.sqrt(deltaX * deltaX + deltaZ * deltaZ) * 100.0f);
        if (i > 0) {
            float exhaust = 0.0f;
            exhaust = rider.isSprinting() ? 0.1f * (float)i * 0.01f : (rider.isShiftKeyDown() ? 0.0f * (float)i * 0.01f : 0.0f * (float)i * 0.01f);
            rider.causeFoodExhaustion(exhaust);
        }
    }

    public void move(MoverType type, Vec3 movementInput) {
        double x = this.getX();
        double z = this.getZ();
        for (Entity rider : this.getPassengers()) {
            movementInput = ((AccessorEntity)rider).adjustToPreventCollision(movementInput);
        }
        super.move(type, movementInput);
        this.tickExhaustion(this.getX() - x, this.getZ() - z);
    }

    public float maxUpStep() {
        float stepHeight = this.getActualStepHeight();
        return this.getPassengers().stream().anyMatch(rider -> WheelchairsRideable.willSuffocateRider(rider.getBoundingBox(), new Vec3(0.0, (double)stepHeight, 0.0), this.level())) ? 0.0f : stepHeight;
    }

    public static boolean willSuffocateRider(AABB riderBounds, Vec3 offset, Level world) {
        AABB bounds = riderBounds.move(offset);
        return BlockPos.betweenClosedStream((AABB)bounds).anyMatch(pos -> {
            BlockState state = world.getBlockState(pos);
            return !state.isAir() && state.isSuffocating((BlockGetter)world, pos) && Shapes.joinIsNotEmpty((VoxelShape)state.getCollisionShape((BlockGetter)world, pos).move((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()), (VoxelShape)Shapes.create((AABB)bounds), (BooleanOp)BooleanOp.AND);
        });
    }

    public abstract float getActualStepHeight();

    public void dropItem(ItemLike itemIn) {
        if (!this.level().isClientSide()) {
            super.spawnAtLocation((ServerLevel)this.level(), itemIn);
        }
    }

    public void dropStack(ItemStack itemIn) {
        if (!this.level().isClientSide()) {
            super.spawnAtLocation((ServerLevel)this.level(), itemIn);
        }
    }
}

