/*
 * Decompiled with CFR 0.152.
 */
package com.lying.init;

import com.lying.block.FrostedLavaBlock;
import com.lying.reference.Reference;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class WHCBlocks {
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((String)"wheelchairs", (ResourceKey)Registries.BLOCK);
    public static final RegistrySupplier<Block> FROSTED_LAVA = WHCBlocks.register("frosted_lava", settings -> new FrostedLavaBlock(settings.noOcclusion().randomTicks().lightLevel(state -> 3 + (Integer)state.getValue((Property)FrostedLavaBlock.AGE) * 2).strength(1.5f).isValidSpawn((state, world, pos, entityType) -> entityType.fireImmune())));

    private static RegistrySupplier<Block> register(String nameIn, Function<BlockBehaviour.Properties, Block> blockIn) {
        ResourceLocation id = Reference.ModInfo.prefix(nameIn);
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)id);
        BlockBehaviour.Properties settings = BlockBehaviour.Properties.of().setId(key);
        return BLOCKS.register(id, () -> (Block)blockIn.apply(settings));
    }

    public static void registerFakeBlock(String nameIn) {
        WHCBlocks.register(nameIn, settings -> new FakeBlock((BlockBehaviour.Properties)settings));
    }

    public static void init() {
        BLOCKS.register();
    }

    private static Boolean never(BlockState state, BlockGetter world, BlockPos pos, EntityType<?> type) {
        return false;
    }

    private static final class FakeBlock
    extends Block {
        public FakeBlock(BlockBehaviour.Properties settings) {
            super(settings.isValidSpawn(WHCBlocks::never).noLootTable());
        }
    }
}

