/*
 * Decompiled with CFR 0.152.
 */
package com.lying.init;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.lying.Wheelchairs;
import com.lying.entity.ChairUpgrade;
import com.lying.entity.WheelchairEntity;
import com.lying.init.WHCBlocks;
import com.lying.reference.Reference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;

public class WHCChairUpgrades {
    private static final Map<ResourceLocation, Supplier<ChairUpgrade>> UPGRADES = new HashMap<ResourceLocation, Supplier<ChairUpgrade>>();
    public static final Supplier<ChairUpgrade> POWERED = WHCChairUpgrades.register("powered", b -> b.modelled().keyItem(Items.FURNACE_MINECART).applied(chair -> chair.getEntityData().set(WheelchairEntity.POWERED, (Object)true)).removed(chair -> chair.getEntityData().set(WheelchairEntity.POWERED, (Object)false)));
    public static final Supplier<ChairUpgrade> STORAGE = WHCChairUpgrades.register("storage", b -> b.modelled().enablesScreen().keyItem((Predicate<ItemStack>)((Predicate)stack -> stack.is(Items.CHEST) || stack.is(Items.TRAPPED_CHEST))).dropItem(Items.CHEST));
    public static final Supplier<ChairUpgrade> FLOATING = WHCChairUpgrades.register("floating", b -> b.modelled().keyItem(Items.PUMPKIN));
    public static final Supplier<ChairUpgrade> NETHERITE = WHCChairUpgrades.register("netherite", b -> b.modelled().keyItem(Items.NETHERITE_INGOT));
    public static final Supplier<ChairUpgrade> DIVING = WHCChairUpgrades.register("diving", b -> b.modelled().keyItem(Items.LEATHER).incompatible(() -> List.of(FLOATING, POWERED)));
    public static final Supplier<ChairUpgrade> GLIDING = WHCChairUpgrades.register("gliding", b -> b.keyItem(Items.ELYTRA).incompatible(() -> List.of(POWERED)));
    public static final Supplier<ChairUpgrade> PLACER = WHCChairUpgrades.register("placer", b -> b.modelled().enablesScreen().keyItem(Items.DISPENSER));
    public static final Supplier<ChairUpgrade> HANDLES = WHCChairUpgrades.register("handles", b -> b.modelled().enablesScreen().keyItem(Items.IRON_BARS));

    private static Supplier<ChairUpgrade> register(String nameIn, Consumer<ChairUpgrade.Builder> consumer) {
        ChairUpgrade.Builder builder = ChairUpgrade.Builder.of(nameIn);
        consumer.accept(builder);
        Supplier<ChairUpgrade> supplier = () -> builder.build();
        UPGRADES.put(Reference.ModInfo.prefix(nameIn), supplier);
        return supplier;
    }

    public static void init() {
        UPGRADES.values().stream().map(s -> (ChairUpgrade)s.get()).filter(ChairUpgrade::hasModel).forEach(acc -> WHCBlocks.registerFakeBlock("upgrade_" + acc.registryName().getPath()));
        Wheelchairs.LOGGER.info(" # Registered {} wheelchair upgrades", (Object)UPGRADES.size());
    }

    @Nullable
    public static ChairUpgrade get(ResourceLocation nameIn) {
        return UPGRADES.getOrDefault(nameIn, () -> null).get();
    }

    @Nullable
    public static Set<ChairUpgrade> fromItem(ItemStack stack, WheelchairEntity chair) {
        List<ChairUpgrade> existing = chair.getUpgrades();
        ArrayList upgrades = Lists.newArrayList();
        for (ResourceLocation id : UPGRADES.keySet()) {
            ChairUpgrade upgrade = WHCChairUpgrades.get(id);
            if (!upgrade.matches(stack) || !existing.stream().allMatch(upg -> ChairUpgrade.canCombineWith(upg, upgrade)) || !upgrade.canApplyTo(chair)) continue;
            upgrades.add(upgrade);
        }
        return Set.of(upgrades.toArray(new ChairUpgrade[0]));
    }

    public static List<ChairUpgrade> idsToList(List<ResourceLocation> list) {
        ArrayList upgrades = Lists.newArrayList();
        for (int i = 0; i < list.size(); ++i) {
            ChairUpgrade upgrade = WHCChairUpgrades.get(list.get(i));
            if (upgrade == null) continue;
            upgrades.add(upgrade);
        }
        return upgrades;
    }

    public static List<ResourceLocation> listToIds(List<ChairUpgrade> upgrades) {
        ArrayList list = Lists.newArrayList();
        upgrades.forEach(upg -> list.add(upg.registryName()));
        return list;
    }
}

