/*
 * Decompiled with CFR 0.152.
 */
package com.lying.init;

import com.google.common.collect.Lists;
import com.lying.data.WHCTags;
import com.lying.init.WHCEnchantmentComponentTypes;
import com.lying.reference.Reference;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.AddValue;

public class WHCEnchantments {
    private static final List<ResourceKey<Enchantment>> WHEELCHAIR_ENCHANTS = Lists.newArrayList();
    public static final ResourceKey<Enchantment> HOLLOWED = WHCEnchantments.register("hollowed");
    public static final ResourceKey<Enchantment> SLIM = WHCEnchantments.register("slim");

    private static ResourceKey<Enchantment> register(String name) {
        return ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)Reference.ModInfo.prefix(name));
    }

    public static void markWheelchairCompatible(ResourceKey<Enchantment> acc) {
        WHEELCHAIR_ENCHANTS.add(acc);
    }

    public static boolean isValidEnchantment(String translationKey) {
        return WHEELCHAIR_ENCHANTS.stream().anyMatch(a -> a.location().toString().equalsIgnoreCase(translationKey));
    }

    public static void init() {
        WHCEnchantments.markWheelchairCompatible((ResourceKey<Enchantment>)Enchantments.DEPTH_STRIDER);
        WHCEnchantments.markWheelchairCompatible((ResourceKey<Enchantment>)Enchantments.FROST_WALKER);
        WHCEnchantments.markWheelchairCompatible((ResourceKey<Enchantment>)Enchantments.FIRE_PROTECTION);
        WHCEnchantments.markWheelchairCompatible((ResourceKey<Enchantment>)Enchantments.RESPIRATION);
    }

    public static Optional<Holder.Reference<Enchantment>> getFrostWalker(RegistryAccess world) {
        return world.lookupOrThrow(Registries.ENCHANTMENT).get(Enchantments.FROST_WALKER.registry());
    }

    public static Optional<Holder.Reference<Enchantment>> getFireProtection(RegistryAccess world) {
        return world.lookupOrThrow(Registries.ENCHANTMENT).get(Enchantments.FIRE_PROTECTION.registry());
    }

    public static Optional<Holder.Reference<Enchantment>> getRespiration(RegistryAccess world) {
        return world.lookupOrThrow(Registries.ENCHANTMENT).get(Enchantments.RESPIRATION.registry());
    }

    public static Optional<Holder.Reference<Enchantment>> getDepthStrider(RegistryAccess world) {
        return world.lookupOrThrow(Registries.ENCHANTMENT).get(Enchantments.DEPTH_STRIDER.registry());
    }

    public static Enchantment create(ResourceLocation regName, HolderSet<Item> validItems, int maxLevel, EquipmentSlotGroup slot, Consumer<Enchantment.Builder> effects) {
        Enchantment.Builder builder = Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition(validItems, (int)5, (int)maxLevel, (Enchantment.Cost)Enchantment.dynamicCost((int)5, (int)6), (Enchantment.Cost)Enchantment.dynamicCost((int)20, (int)6), (int)2, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{slot}));
        effects.accept(builder);
        return builder.build(regName);
    }

    public static void bootstrap(BootstrapContext<Enchantment> registerable) {
        HolderGetter itemLookup = registerable.lookup(Registries.ITEM);
        HolderGetter enchLookup = registerable.lookup(Registries.ENCHANTMENT);
        registerable.register(HOLLOWED, (Object)WHCEnchantments.create(HOLLOWED.location(), (HolderSet<Item>)itemLookup.getOrThrow(WHCTags.CANE), 1, EquipmentSlotGroup.HAND, b -> {
            b.withEffect((DataComponentType)WHCEnchantmentComponentTypes.CANE_INVENTORY.get());
            b.exclusiveWith((HolderSet)enchLookup.getOrThrow(WHCTags.CANE_INTERACT_SET));
        }));
        registerable.register(SLIM, (Object)WHCEnchantments.create(SLIM.location(), (HolderSet<Item>)itemLookup.getOrThrow(ItemTags.SWORDS), 1, EquipmentSlotGroup.HAND, b -> {
            b.withEffect(EnchantmentEffectComponents.DAMAGE, (Object)new AddValue((LevelBasedValue)LevelBasedValue.constant((float)-2.0f)));
            b.withEffect((DataComponentType)WHCEnchantmentComponentTypes.CANE_STOREABLE.get());
            b.exclusiveWith((HolderSet)enchLookup.getOrThrow(WHCTags.CANE_INTERACT_SET));
        }));
    }
}

