/*
 * Decompiled with CFR 0.152.
 */
package com.lying.init;

import com.lying.Wheelchairs;
import com.lying.entity.StoolEntity;
import com.lying.entity.WalkerEntity;
import com.lying.entity.WheelchairEntity;
import com.lying.reference.Reference;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;

public class WHCEntityTypes {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((String)"wheelchairs", (ResourceKey)Registries.ENTITY_TYPE);
    private static int tally = 0;
    public static final RegistrySupplier<EntityType<WheelchairEntity>> WHEELCHAIR = WHCEntityTypes.register("wheelchair", () -> EntityType.Builder.of(WheelchairEntity::new, (MobCategory)MobCategory.MISC).sized(0.7f, 0.9f).build(WHCEntityTypes.keyOf("wheelchair")));
    public static final RegistrySupplier<EntityType<WalkerEntity>> WALKER = WHCEntityTypes.register("walker", () -> EntityType.Builder.of(WalkerEntity::new, (MobCategory)MobCategory.MISC).sized(0.7f, 0.9f).build(WHCEntityTypes.keyOf("walker")));
    public static final RegistrySupplier<EntityType<StoolEntity>> STOOL = WHCEntityTypes.register("stool", () -> EntityType.Builder.of(StoolEntity::new, (MobCategory)MobCategory.MISC).sized(0.7f, 0.9f).build(WHCEntityTypes.keyOf("stool")));

    private static ResourceKey<EntityType<?>> keyOf(String nameIn) {
        return ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)Reference.ModInfo.prefix(nameIn));
    }

    private static <T extends Entity> RegistrySupplier<EntityType<T>> register(String name, Supplier<EntityType<T>> entry) {
        ++tally;
        return ENTITY_TYPES.register(Reference.ModInfo.prefix(name), entry);
    }

    public static void init() {
        ENTITY_TYPES.register();
        Wheelchairs.LOGGER.info(" # Registered " + tally + " entity types");
    }
}

