/*
 * Decompiled with CFR 0.152.
 */
package com.lying.init;

import com.lying.data.recipe.RecipeCane;
import com.lying.data.recipe.RecipeCaneSword;
import com.lying.data.recipe.RecipeHandle;
import com.lying.data.recipe.RecipeWalker;
import com.lying.data.recipe.RecipeWheelchair;
import com.lying.reference.Reference;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;

public class WHCSpecialRecipes {
    private static final DeferredRegister<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((String)"wheelchairs", (ResourceKey)Registries.RECIPE_TYPE);
    private static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((String)"wheelchairs", (ResourceKey)Registries.RECIPE_SERIALIZER);
    public static final RegistrySupplier<RecipeType<RecipeHandle>> HANDLE_TYPE = WHCSpecialRecipes.makeType("handle");
    public static final RegistrySupplier<RecipeSerializer<RecipeWheelchair>> WHEELCHAIR_SERIALIZER = WHCSpecialRecipes.makeSerializer(RecipeWheelchair.ID, new RecipeWheelchair.Serializer());
    public static final RegistrySupplier<RecipeSerializer<RecipeCane>> CANE_SERIALIZER = WHCSpecialRecipes.makeSerializer(RecipeCane.ID, new RecipeCane.Serializer());
    public static final RegistrySupplier<RecipeSerializer<RecipeHandle>> HANDLE_SERIALIZER = WHCSpecialRecipes.makeSerializer(RecipeHandle.ID, new RecipeHandle.Serializer());
    public static final RegistrySupplier<RecipeSerializer<RecipeCaneSword>> CANE_SWORD_SERIALIZER = WHCSpecialRecipes.makeSerializer(RecipeCaneSword.ID, new CustomRecipe.Serializer(category -> new RecipeCaneSword()));
    public static final RegistrySupplier<RecipeSerializer<RecipeWalker>> WALKER_SERIALIZER = WHCSpecialRecipes.makeSerializer(RecipeWalker.ID, new RecipeWalker.Serializer());

    private static <T extends Recipe<?>> RegistrySupplier<RecipeSerializer<T>> makeSerializer(ResourceLocation name, RecipeSerializer<T> serializer) {
        return RECIPE_SERIALIZERS.register(name, () -> serializer);
    }

    private static <T extends Recipe<?>> RegistrySupplier<RecipeType<T>> makeType(final String name) {
        return RECIPE_TYPES.register(Reference.ModInfo.prefix(name), () -> new RecipeType<T>(){

            public String toString() {
                return name;
            }
        });
    }

    public static void init() {
        RECIPE_TYPES.register();
        RECIPE_SERIALIZERS.register();
    }
}

