/*
 * Decompiled with CFR 0.152.
 */
package com.lying.item;

import com.lying.component.type.HandleComponent;
import com.lying.component.type.SwordComponent;
import com.lying.init.WHCDataComponentTypes;
import com.lying.init.WHCItems;
import com.lying.init.WHCSoundEvents;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class CaneItem
extends Item {
    public CaneItem(Item.Properties settings) {
        super(settings.component((DataComponentType)WHCDataComponentTypes.HANDLE.get(), (Object)HandleComponent.empty()).component((DataComponentType)WHCDataComponentTypes.SWORD.get(), (Object)SwordComponent.empty()));
    }

    public static ItemStack withHandle(Item cane, Item handle) {
        ItemStack defaultStack = cane.getDefaultInstance();
        CaneItem.setHandle(defaultStack, handle.getDefaultInstance());
        return defaultStack;
    }

    public static void setHandle(ItemStack stack, ItemStack handle) {
        stack.set((DataComponentType)WHCDataComponentTypes.HANDLE.get(), (Object)new HandleComponent(handle.copy()));
    }

    public ItemStack getHandle(ItemStack stack) {
        if (stack.has((DataComponentType)WHCDataComponentTypes.HANDLE.get())) {
            return ((HandleComponent)stack.get((DataComponentType)WHCDataComponentTypes.HANDLE.get())).contents().orElse(((Item)WHCItems.HANDLE_OAK.get()).getDefaultInstance().copy());
        }
        return ((Item)WHCItems.HANDLE_OAK.get()).getDefaultInstance().copy();
    }

    public InteractionResult use(Level world, Player user, InteractionHand hand) {
        ItemStack heldStack = user.getItemInHand(hand);
        ItemStack sword = CaneItem.getSword(heldStack);
        if (user.isShiftKeyDown() && !sword.isEmpty()) {
            InteractionHand opposite;
            ItemStack cane = CaneItem.setSword(heldStack.copy(), ItemStack.EMPTY);
            InteractionHand interactionHand = opposite = hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
            if (user.getItemInHand(opposite).isEmpty()) {
                user.setItemInHand(opposite, cane);
            } else {
                user.getInventory().add(cane);
            }
            world.playSound(null, user.getX(), user.getY(), user.getZ(), WHCSoundEvents.SWORD_DRAW, SoundSource.NEUTRAL, 0.5f, 0.4f / (world.getRandom().nextFloat() * 0.4f + 0.8f));
            return InteractionResult.SUCCESS.heldItemTransformedTo(sword);
        }
        return InteractionResult.PASS;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        ((HandleComponent)stack.get((DataComponentType)WHCDataComponentTypes.HANDLE.get())).addToTooltip(context, tooltip::add, type);
        ((SwordComponent)stack.get((DataComponentType)WHCDataComponentTypes.SWORD.get())).addToTooltip(context, tooltip::add, type);
    }

    public static ItemStack setSword(ItemStack cane, ItemStack sword) {
        cane.set((DataComponentType)WHCDataComponentTypes.SWORD.get(), (Object)new SwordComponent(sword.copy()));
        return cane;
    }

    public static ItemStack getSword(ItemStack cane) {
        return cane.has((DataComponentType)WHCDataComponentTypes.SWORD.get()) ? ((SwordComponent)cane.get((DataComponentType)WHCDataComponentTypes.SWORD.get())).contents().orElse(ItemStack.EMPTY) : ItemStack.EMPTY;
    }
}

