/*
 * Decompiled with CFR 0.152.
 */
package com.lying.item;

import dev.architectury.registry.registries.RegistrySupplier;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ItemSteerable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ControllerItem<T extends Entity>
extends Item {
    private final RegistrySupplier<EntityType<T>> target;
    private final int damagePerUse;

    public ControllerItem(RegistrySupplier<EntityType<T>> target, int damagePerUse, Item.Properties settings) {
        super(settings);
        this.target = target;
        this.damagePerUse = damagePerUse;
    }

    public InteractionResult use(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.getItemInHand(hand);
        if (world.isClientSide) {
            return InteractionResult.PASS;
        }
        Entity entity = user.getControlledVehicle();
        if (user.isPassenger() && entity instanceof ItemSteerable) {
            ItemSteerable itemSteerable = (ItemSteerable)entity;
            if (entity.getType() == this.target.get() && itemSteerable.boost()) {
                EquipmentSlot equipmentSlot = LivingEntity.getSlotForHand((InteractionHand)hand);
                ItemStack itemStack2 = itemStack.hurtAndConvertOnBreak(this.damagePerUse, (ItemLike)Items.FISHING_ROD, (LivingEntity)user, equipmentSlot);
                return InteractionResult.SUCCESS_SERVER.heldItemTransformedTo(itemStack2);
            }
        }
        user.awardStat(Stats.ITEM_USED.get((Object)this));
        return InteractionResult.PASS;
    }
}

