/*
 * Decompiled with CFR 0.152.
 */
package com.lying.item;

import dev.architectury.registry.registries.RegistrySupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class EntityPlacerItem<T extends Entity>
extends Item {
    private final RegistrySupplier<EntityType<T>> entityType;

    protected EntityPlacerItem(RegistrySupplier<EntityType<T>> typeIn, Item.Properties settings) {
        super(settings);
        this.entityType = typeIn;
    }

    public InteractionResult useOn(UseOnContext context) {
        Direction direction = context.getClickedFace();
        if (direction == Direction.DOWN) {
            return InteractionResult.FAIL;
        }
        Level world = context.getLevel();
        BlockPlaceContext itemPlacementContext = new BlockPlaceContext(context);
        BlockPos blockPos = itemPlacementContext.getClickedPos();
        ItemStack itemStack = context.getItemInHand();
        Vec3 vec3d = Vec3.atBottomCenterOf((Vec3i)blockPos);
        AABB box = ((EntityType)this.entityType.get()).getDimensions().makeBoundingBox(vec3d.x(), vec3d.y(), vec3d.z());
        if (!world.noCollision(null, box) || !world.getEntities(null, box).isEmpty()) {
            return InteractionResult.FAIL;
        }
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            T entity = this.makeEntity(serverWorld, itemStack, context.getPlayer(), blockPos);
            if (entity == null) {
                return InteractionResult.FAIL;
            }
            float f = (float)Mth.floor((float)((Mth.wrapDegrees((float)(context.getRotation() - 180.0f)) + 22.5f) / 45.0f)) * 45.0f;
            entity.moveTo(entity.getX(), entity.getY(), entity.getZ(), f, 0.0f);
            serverWorld.addFreshEntityWithPassengers(entity);
            world.playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.ARMOR_STAND_PLACE, SoundSource.BLOCKS, 0.75f, 0.8f);
            entity.gameEvent((Holder)GameEvent.ENTITY_PLACE, (Entity)context.getPlayer());
        }
        itemStack.shrink(1);
        return InteractionResult.SUCCESS_SERVER;
    }

    protected abstract T makeEntity(ServerLevel var1, ItemStack var2, Player var3, BlockPos var4);
}

