/*
 * Decompiled with CFR 0.152.
 */
package com.lying.item;

import com.lying.entity.StoolEntity;
import com.lying.init.WHCEntityTypes;
import com.lying.item.EntityPlacerItem;
import com.lying.item.IBonusBlockItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import org.jetbrains.annotations.Nullable;

public class StoolItem
extends EntityPlacerItem<StoolEntity>
implements IBonusBlockItem {
    public static final int DEFAULT_COLOR = 0x1D1D21;

    public StoolItem(Item.Properties settings) {
        super(WHCEntityTypes.STOOL, settings.component(DataComponents.DYED_COLOR, (Object)new DyedItemColor(0x1D1D21, true)));
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    public int getEnchantability() {
        return 0;
    }

    public int getColor(ItemStack stack) {
        return DyedItemColor.getOrDefault((ItemStack)stack, (int)0x1D1D21);
    }

    @Override
    protected StoolEntity makeEntity(ServerLevel serverWorld, ItemStack stack, @Nullable Player player, BlockPos pos) {
        StoolEntity stool = (StoolEntity)((EntityType)WHCEntityTypes.STOOL.get()).spawn(serverWorld, stack, player, pos, EntitySpawnReason.SPAWN_ITEM_USE, true, true);
        if (stool != null) {
            stool.copyFromItem(stack);
        }
        return stool;
    }
}

