/*
 * Decompiled with CFR 0.152.
 */
package com.lying.item;

import com.lying.Wheelchairs;
import com.lying.mixin.FoxEntityMixin;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class VestItem
extends Item {
    private static final Function<Entity, UUID> tamedOwner = entity -> ((TamableAnimal)entity).getOwnerUUID();
    public static final Map<EntityType<? extends LivingEntity>, Function<Entity, UUID>> APPLICABLE_MOBS = Map.of(EntityType.WOLF, tamedOwner, EntityType.CAT, tamedOwner, EntityType.PARROT, tamedOwner, EntityType.FOX, entity -> ((FoxEntityMixin)entity).getOwnerID().orElse(null));

    public VestItem(Item.Properties settings) {
        super(settings.component(DataComponents.DYED_COLOR, null));
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player user, LivingEntity entity, InteractionHand hand) {
        if (!VestItem.isValidMobForVest((Entity)entity)) {
            return InteractionResult.PASS;
        }
        UUID ownerID = VestItem.getVestedMobOwner((Entity)entity);
        if (ownerID == null || ownerID != user.getUUID()) {
            return InteractionResult.PASS;
        }
        ItemStack vest = VestItem.getVest(entity);
        if (!vest.isEmpty()) {
            VestItem.dropVest(entity);
        }
        VestItem.setVest(entity, stack.split(1));
        user.displayClientMessage((Component)Component.translatable((String)"gui.wheelchairs.service_vest_applied"), true);
        if (!user.isCreative()) {
            stack.shrink(1);
        }
        return InteractionResult.SUCCESS_SERVER;
    }

    public static boolean isMobWithVest(Entity entity) {
        return VestItem.isValidMobForVest(entity) && !VestItem.getVest((LivingEntity)entity).isEmpty();
    }

    public static boolean isValidMobForVest(Entity entity) {
        return APPLICABLE_MOBS.containsKey(entity.getType());
    }

    @Nullable
    public static UUID getVestedMobOwner(Entity entity) {
        return APPLICABLE_MOBS.getOrDefault(entity.getType(), ent -> null).apply(entity);
    }

    public static ItemStack getVest(LivingEntity entity) {
        return Wheelchairs.HANDLER.getVest(entity);
    }

    public static void setVest(LivingEntity entity, ItemStack stack) {
        Wheelchairs.HANDLER.setVest(entity, stack);
    }

    public static void dropVest(LivingEntity entity) {
        ItemStack vest = VestItem.getVest(entity);
        if (!vest.isEmpty() && !entity.level().isClientSide()) {
            entity.spawnAtLocation((ServerLevel)entity.level(), vest);
            VestItem.setVest(entity, ItemStack.EMPTY);
        }
    }
}

