/*
 * Decompiled with CFR 0.152.
 */
package com.lying.item;

import com.lying.component.type.WheelComponent;
import com.lying.entity.WalkerEntity;
import com.lying.init.WHCDataComponentTypes;
import com.lying.init.WHCEntityTypes;
import com.lying.item.IBonusBlockItem;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class WalkerItem
extends Item
implements IBonusBlockItem {
    public WalkerItem(Item.Properties settings) {
        super(settings.component((DataComponentType)WHCDataComponentTypes.LEFT_WHEEL.get(), (Object)WheelComponent.empty(HumanoidArm.LEFT)).component((DataComponentType)WHCDataComponentTypes.RIGHT_WHEEL.get(), (Object)WheelComponent.empty(HumanoidArm.RIGHT)).component((DataComponentType)WHCDataComponentTypes.HAS_CHEST.get(), (Object)false).component(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY));
    }

    public static ItemStack withWheels(Item chair, Item wheels) {
        ItemStack defaultStack = chair.getDefaultInstance();
        WalkerItem.setWheels(defaultStack, wheels.getDefaultInstance(), wheels.getDefaultInstance());
        return defaultStack;
    }

    public boolean isEnchantable(ItemStack stack) {
        return this.getDefaultMaxStackSize() == 1;
    }

    public int getEnchantability() {
        return 5;
    }

    public InteractionResult useOn(UseOnContext context) {
        Direction direction = context.getClickedFace();
        if (direction == Direction.DOWN) {
            return InteractionResult.FAIL;
        }
        Level world = context.getLevel();
        BlockPlaceContext itemPlacementContext = new BlockPlaceContext(context);
        BlockPos blockPos = itemPlacementContext.getClickedPos();
        ItemStack itemStack = context.getItemInHand();
        Vec3 vec3d = Vec3.atBottomCenterOf((Vec3i)blockPos);
        AABB box = ((EntityType)WHCEntityTypes.WALKER.get()).getDimensions().makeBoundingBox(vec3d.x(), vec3d.y(), vec3d.z());
        if (!world.noCollision(null, box) || !world.getEntities(null, box).isEmpty()) {
            return InteractionResult.FAIL;
        }
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            WalkerEntity walker = (WalkerEntity)((EntityType)WHCEntityTypes.WALKER.get()).spawn(serverWorld, itemStack, context.getPlayer(), blockPos, EntitySpawnReason.SPAWN_ITEM_USE, true, true);
            if (walker == null) {
                return InteractionResult.FAIL;
            }
            walker.copyFromItem(itemStack);
            float f = (float)Mth.floor((float)((Mth.wrapDegrees((float)(context.getRotation() - 180.0f)) + 22.5f) / 45.0f)) * 45.0f;
            walker.moveTo(walker.getX(), walker.getY(), walker.getZ(), f, 0.0f);
            serverWorld.addFreshEntityWithPassengers((Entity)walker);
            world.playSound(null, walker.getX(), walker.getY(), walker.getZ(), SoundEvents.ARMOR_STAND_PLACE, SoundSource.BLOCKS, 0.75f, 0.8f);
            walker.gameEvent((Holder)GameEvent.ENTITY_PLACE, (Entity)context.getPlayer());
        }
        itemStack.shrink(1);
        return InteractionResult.SUCCESS_SERVER;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        ((WheelComponent)stack.get((DataComponentType)WHCDataComponentTypes.LEFT_WHEEL.get())).addToTooltip(context, tooltip::add, type);
        ((WheelComponent)stack.get((DataComponentType)WHCDataComponentTypes.RIGHT_WHEEL.get())).addToTooltip(context, tooltip::add, type);
    }

    public static Iterable<ItemStack> getWheels(ItemStack stack) {
        NonNullList wheels = NonNullList.withSize((int)2, (Object)WheelComponent.DEFAULT_WHEEL.get());
        wheels.set(0, (Object)WalkerItem.getWheel(stack, HumanoidArm.LEFT));
        wheels.set(1, (Object)WalkerItem.getWheel(stack, HumanoidArm.RIGHT));
        return wheels;
    }

    public static void setWheels(ItemStack stack, ItemStack left, ItemStack right) {
        stack.set((DataComponentType)WHCDataComponentTypes.LEFT_WHEEL.get(), (Object)((WheelComponent)stack.get((DataComponentType)WHCDataComponentTypes.LEFT_WHEEL.get())).with(left));
        stack.set((DataComponentType)WHCDataComponentTypes.RIGHT_WHEEL.get(), (Object)((WheelComponent)stack.get((DataComponentType)WHCDataComponentTypes.RIGHT_WHEEL.get())).with(right));
    }

    public static ItemStack getWheel(ItemStack stack, HumanoidArm arm) {
        DataComponentType entry = arm == HumanoidArm.LEFT ? (DataComponentType)WHCDataComponentTypes.LEFT_WHEEL.get() : (DataComponentType)WHCDataComponentTypes.RIGHT_WHEEL.get();
        return stack.has(entry) ? ((WheelComponent)stack.get(entry)).item() : WheelComponent.DEFAULT_WHEEL.get();
    }

    public static void setHasChest(ItemStack stack, boolean contents) {
        stack.set((DataComponentType)WHCDataComponentTypes.HAS_CHEST.get(), (Object)contents);
    }

    public static boolean hasChest(ItemStack stack) {
        return stack.has((DataComponentType)WHCDataComponentTypes.HAS_CHEST.get()) ? (Boolean)stack.get((DataComponentType)WHCDataComponentTypes.HAS_CHEST.get()) : false;
    }
}

