/*
 * Decompiled with CFR 0.152.
 */
package com.lying.item;

import com.lying.component.type.UpgradesComponent;
import com.lying.component.type.WheelComponent;
import com.lying.entity.ChairUpgrade;
import com.lying.entity.WheelchairEntity;
import com.lying.init.WHCChairUpgrades;
import com.lying.init.WHCDataComponentTypes;
import com.lying.init.WHCEntityTypes;
import com.lying.item.EntityPlacerItem;
import com.lying.item.IBonusBlockItem;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class WheelchairItem
extends EntityPlacerItem<WheelchairEntity>
implements IBonusBlockItem {
    public WheelchairItem(Item.Properties settings) {
        super(WHCEntityTypes.WHEELCHAIR, settings.component(DataComponents.DYED_COLOR, null).component((DataComponentType)WHCDataComponentTypes.LEFT_WHEEL.get(), (Object)WheelComponent.empty(HumanoidArm.LEFT)).component((DataComponentType)WHCDataComponentTypes.RIGHT_WHEEL.get(), (Object)WheelComponent.empty(HumanoidArm.RIGHT)).component((DataComponentType)WHCDataComponentTypes.UPGRADES.get(), (Object)UpgradesComponent.blank()).component(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY));
    }

    public static ItemStack withWheels(Item chair, Item wheels) {
        ItemStack defaultStack = chair.getDefaultInstance();
        WheelchairItem.setWheels(defaultStack, wheels.getDefaultInstance(), wheels.getDefaultInstance());
        return defaultStack;
    }

    public boolean isEnchantable(ItemStack stack) {
        return this.getDefaultMaxStackSize() == 1;
    }

    public int getEnchantability() {
        return 5;
    }

    @Override
    protected WheelchairEntity makeEntity(ServerLevel serverWorld, ItemStack stack, @Nullable Player player, BlockPos pos) {
        WheelchairEntity wheelchair = (WheelchairEntity)((EntityType)WHCEntityTypes.WHEELCHAIR.get()).spawn(serverWorld, stack, player, pos, EntitySpawnReason.SPAWN_ITEM_USE, true, true);
        if (wheelchair != null) {
            wheelchair.copyFromItem(stack);
        }
        return wheelchair;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        ((WheelComponent)stack.get((DataComponentType)WHCDataComponentTypes.LEFT_WHEEL.get())).addToTooltip(context, tooltip::add, type);
        ((WheelComponent)stack.get((DataComponentType)WHCDataComponentTypes.RIGHT_WHEEL.get())).addToTooltip(context, tooltip::add, type);
        ((UpgradesComponent)stack.get((DataComponentType)WHCDataComponentTypes.UPGRADES.get())).addToTooltip(context, tooltip::add, type);
    }

    public void appendTooltip(ItemStack stack, @Nullable Level world, List<Component> tooltip, Item.TooltipContext context) {
        tooltip.add((Component)Component.translatable((String)"gui.wheelchairs.wheelchair.wheel_left", (Object[])new Object[]{WheelchairItem.getWheel(stack, HumanoidArm.LEFT).getHoverName()}));
        tooltip.add((Component)Component.translatable((String)"gui.wheelchairs.wheelchair.wheel_right", (Object[])new Object[]{WheelchairItem.getWheel(stack, HumanoidArm.RIGHT).getHoverName()}));
        List<ResourceLocation> upgrades = ((UpgradesComponent)stack.get((DataComponentType)WHCDataComponentTypes.UPGRADES.get())).upgrades();
        if (upgrades.size() > 0) {
            tooltip.add((Component)Component.translatable((String)"gui.wheelchairs.upgrades"));
            for (ResourceLocation id : upgrades) {
                ChairUpgrade upgrade = WHCChairUpgrades.get(id);
                if (upgrade == null) continue;
                tooltip.add((Component)Component.literal((String)" * ").append(upgrade.translate()));
            }
        }
    }

    public static Iterable<ItemStack> getWheels(ItemStack stack) {
        NonNullList wheels = NonNullList.withSize((int)2, (Object)WheelComponent.DEFAULT_WHEEL.get());
        wheels.set(0, (Object)WheelchairItem.getWheel(stack, HumanoidArm.LEFT));
        wheels.set(1, (Object)WheelchairItem.getWheel(stack, HumanoidArm.RIGHT));
        return wheels;
    }

    public static void setWheels(ItemStack stack, ItemStack left, ItemStack right) {
        if (!left.isEmpty()) {
            stack.set((DataComponentType)WHCDataComponentTypes.LEFT_WHEEL.get(), (Object)((WheelComponent)stack.get((DataComponentType)WHCDataComponentTypes.LEFT_WHEEL.get())).with(left));
        }
        if (!right.isEmpty()) {
            stack.set((DataComponentType)WHCDataComponentTypes.RIGHT_WHEEL.get(), (Object)((WheelComponent)stack.get((DataComponentType)WHCDataComponentTypes.RIGHT_WHEEL.get())).with(right));
        }
    }

    public static ItemStack getWheel(ItemStack stack, HumanoidArm arm) {
        DataComponentType entry = arm == HumanoidArm.LEFT ? (DataComponentType)WHCDataComponentTypes.LEFT_WHEEL.get() : (DataComponentType)WHCDataComponentTypes.RIGHT_WHEEL.get();
        return stack.has(entry) ? ((WheelComponent)stack.get(entry)).item() : WheelComponent.DEFAULT_WHEEL.get();
    }

    public static boolean hasUpgrade(ItemStack stack, ChairUpgrade upgrade) {
        return ((UpgradesComponent)stack.get((DataComponentType)WHCDataComponentTypes.UPGRADES.get())).upgrades().stream().anyMatch(up -> up.equals((Object)upgrade.registryName()));
    }
}

