/*
 * Decompiled with CFR 0.152.
 */
package com.lying.mixin;

import com.lying.utility.ServerEvents;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    private int calls = 0;
    private Entity originalVehicle;
    private static final Long DETACH_TIME_OUT = 10L;
    protected Optional<Entity> latestVehicle = Optional.empty();
    protected long detachTime = Long.MAX_VALUE;
    @Shadow
    protected static final int FLAG_FALL_FLYING = 7;

    @Shadow
    public boolean isRemoved() {
        return false;
    }

    @Shadow
    public MinecraftServer getServer() {
        return null;
    }

    @Shadow
    public UUID getUUID() {
        return null;
    }

    @Shadow
    public boolean isPassenger() {
        return false;
    }

    @Shadow
    public Entity getVehicle() {
        return null;
    }

    @Shadow
    public Level level() {
        return null;
    }

    @Shadow
    public EntityType<?> getType() {
        return null;
    }

    @Shadow
    public AABB getBoundingBox() {
        return null;
    }

    @Shadow
    protected boolean getSharedFlag(int index) {
        return false;
    }

    @Shadow
    public Pose getPose() {
        return Pose.STANDING;
    }

    @Shadow
    public SynchedEntityData getEntityData() {
        return null;
    }

    private boolean shouldCall() {
        return this.level() != null && !this.level().isClientSide();
    }

    protected long currentTime() {
        return this.level().getGameTime();
    }

    protected Optional<Entity> recallVehicle() {
        if (this.latestVehicle.isEmpty()) {
            return this.latestVehicle;
        }
        long time = this.currentTime();
        return time >= this.detachTime ? (time - this.detachTime < DETACH_TIME_OUT ? this.latestVehicle : Optional.empty()) : Optional.empty();
    }

    @Inject(method={"startRiding(Lnet/minecraft/world/entity/Entity;Z)Z"}, at={@At(value="HEAD")})
    private void whc$startRidingHead(Entity entity, boolean force, CallbackInfoReturnable<Boolean> ci) {
        if (!this.shouldCall()) {
            return;
        }
        if (this.calls == 0) {
            this.originalVehicle = this.getVehicle();
        }
        ++this.calls;
    }

    @Inject(method={"startRiding(Lnet/minecraft/world/entity/Entity;Z)Z"}, at={@At(value="TAIL")})
    private void whc$startRidingTail(Entity entity, boolean force, CallbackInfoReturnable<Boolean> ci) {
        if (this.shouldCall()) {
            Entity ent = (Entity)this;
            if (--this.calls <= 0 && ent instanceof LivingEntity) {
                if (this.getVehicle() != this.originalVehicle) {
                    ((ServerEvents.LivingChangeMount)ServerEvents.AFTER_LIVING_CHANGE_MOUNT_END.invoker()).afterChangeMount((LivingEntity)ent, this.getVehicle(), this.originalVehicle);
                }
                this.originalVehicle = null;
                this.calls = 0;
            }
        }
    }

    @Inject(method={"stopRiding()V"}, at={@At(value="HEAD")})
    private void whc$stopRiding(CallbackInfo ci) {
        if (this.isPassenger()) {
            this.latestVehicle = Optional.of(this.getVehicle());
            this.detachTime = this.currentTime();
        }
        if (!this.shouldCall() || !this.isPassenger()) {
            return;
        }
        if (this.calls == 0) {
            this.originalVehicle = this.getVehicle();
        }
    }

    @Inject(method={"stopRiding()V"}, at={@At(value="TAIL")})
    private void whc$stopRidingTail(CallbackInfo ci) {
        if (!this.shouldCall()) {
            return;
        }
        if (this.calls == 0 && this.originalVehicle != null) {
            Entity ent = (Entity)this;
            if (ent instanceof LivingEntity) {
                ((ServerEvents.LivingChangeMount)ServerEvents.AFTER_LIVING_CHANGE_MOUNT_END.invoker()).afterChangeMount((LivingEntity)ent, null, this.originalVehicle);
            }
            this.originalVehicle = null;
        }
    }
}

