/*
 * Decompiled with CFR 0.152.
 */
package com.lying.mixin;

import com.lying.entity.IHeldItemRenderer;
import com.lying.entity.IParentEntity;
import com.lying.entity.IServiceVestHolder;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={LivingEntityRenderState.class})
public class LivingEntityRenderStateMixin
implements IServiceVestHolder,
IHeldItemRenderer,
IParentEntity {
    @Unique
    private boolean isActiveParent = false;
    @Unique
    private ItemStack serviceVest = ItemStack.EMPTY;
    @Unique
    private ItemStack heldItemRight = ItemStack.EMPTY;
    @Unique
    private ItemStack heldItemLeft = ItemStack.EMPTY;

    @Override
    public ItemStack getVest() {
        return this.serviceVest;
    }

    @Override
    public void setVest(ItemStack stack) {
        this.serviceVest = stack;
    }

    @Override
    public ItemStack getHeldItem(HumanoidArm arm) {
        switch (arm) {
            case RIGHT: {
                return this.heldItemRight;
            }
            case LEFT: {
                return this.heldItemLeft;
            }
        }
        return ItemStack.EMPTY;
    }

    @Override
    public void setHeldItem(ItemStack stack, HumanoidArm arm) {
        switch (arm) {
            case RIGHT: {
                this.heldItemRight = stack;
                break;
            }
            case LEFT: {
                this.heldItemLeft = stack;
            }
        }
    }

    @Override
    public boolean hasParentedEntities() {
        return this.isActiveParent;
    }

    @Override
    public void setHasParentedEntities(boolean val) {
        this.isActiveParent = val;
    }
}

