/*
 * Decompiled with CFR 0.152.
 */
package com.lying.mixin;

import com.lying.init.WHCEntityTypes;
import com.lying.mixin.EntityMixin;
import com.lying.utility.ServerBus;
import com.lying.utility.ServerEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public class PlayerEntityMixin
extends EntityMixin {
    private boolean wasFlying = false;

    @Inject(method={"getDestroySpeed(Lnet/minecraft/world/level/block/state/BlockState;)F"}, at={@At(value="RETURN")}, cancellable=true)
    public void whc$getBlockBreakingSpeed(BlockState block, CallbackInfoReturnable<Float> ci) {
        if (this.isPassenger() && this.getVehicle().getType() == WHCEntityTypes.WHEELCHAIR.get() && this.getVehicle().onGround()) {
            ci.setReturnValue((Object)Float.valueOf(((Float)ci.getReturnValue()).floatValue() * 5.0f));
        }
    }

    @Inject(method={"wantsToStopRiding()Z"}, at={@At(value="TAIL")}, cancellable=true)
    public void whc$shouldDismount(CallbackInfoReturnable<Boolean> ci) {
        ci.setReturnValue((Object)((Boolean)ci.getReturnValue() != false && !ServerBus.getSeatbelt(this.getUUID()) ? 1 : 0));
    }

    @Inject(method={"updatePlayerPose()V"}, at={@At(value="HEAD")})
    public void whc$updatePoseStart(CallbackInfo ci) {
        this.wasFlying = this.getPose() == Pose.FALL_FLYING;
    }

    @Inject(method={"updatePlayerPose()V"}, at={@At(value="TAIL")})
    public void whc$updatePoseEnd(CallbackInfo ci) {
        boolean isFlying;
        if (this.level().isClientSide()) {
            return;
        }
        boolean bl = isFlying = this.getPose() == Pose.FALL_FLYING;
        if (this.wasFlying != isFlying) {
            Player player = (Player)this;
            if (isFlying) {
                ((ServerEvents.StartFlyingEvent)ServerEvents.ON_START_FLYING.invoker()).onStartFlying((LivingEntity)player);
            } else {
                ((ServerEvents.StopFlyingEvent)ServerEvents.ON_STOP_FLYING.invoker()).onStopFlying((LivingEntity)player);
            }
        }
    }
}

