/*
 * Decompiled with CFR 0.152.
 */
package com.lying.mixin;

import com.lying.entity.IHeldItemRenderer;
import com.lying.entity.IParentEntity;
import com.lying.item.CaneItem;
import com.lying.item.CrutchItem;
import com.lying.mixin.BipedEntityModelMixin;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerModel.class})
public class PlayerEntityModelMixin
extends BipedEntityModelMixin {
    private static boolean shouldModify(Pose currentPose, HumanoidModel.ArmPose rightArmPose, HumanoidModel.ArmPose leftArmPose) {
        return (currentPose == Pose.STANDING || currentPose == Pose.CROUCHING) && !rightArmPose.isTwoHanded() && !leftArmPose.isTwoHanded();
    }

    @Inject(method={"setupAnim(Lnet/minecraft/client/renderer/entity/state/PlayerRenderState;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void whc$setAnglesHead(PlayerRenderState state, CallbackInfo ci) {
        if (!PlayerEntityModelMixin.shouldModify(state.pose, state.rightArmPose, state.leftArmPose)) {
            return;
        }
        this.animHandlingWalkers(state);
    }

    @Inject(method={"setupAnim(Lnet/minecraft/client/renderer/entity/state/PlayerRenderState;)V"}, at={@At(value="TAIL")}, cancellable=true)
    public void whc$setAnglesTail(PlayerRenderState state, CallbackInfo ci) {
        if (!PlayerEntityModelMixin.shouldModify(state.pose, state.rightArmPose, state.leftArmPose)) {
            return;
        }
        this.handleAnimTweaks(state, state.ageInTicks, state.hasPose(Pose.CROUCHING), state.mainArm == HumanoidArm.RIGHT, this.getLeg(state.mainArm), this.getLeg(state.mainArm.getOpposite()));
    }

    private <T extends PlayerRenderState> void handleAnimTweaks(PlayerRenderState state, float age, boolean isCrouching, boolean rightHanded, ModelPart mainLeg, ModelPart offLeg) {
        this.animHandlingCrutches(state, isCrouching, rightHanded, mainLeg, offLeg);
        this.animHandlingCanes(state, age, rightHanded, isCrouching);
    }

    private <T extends PlayerRenderState> void animHandlingCrutches(T entity, boolean isCrouching, boolean rightHanded, ModelPart mainLeg, ModelPart offLeg) {
        boolean isPair = PlayerEntityModelMixin.isHoldingPair((IHeldItemRenderer)entity);
        double amount = isCrouching ? 25.0 : (entity.isPassenger ? 15.0 : 10.0);
        float roll = (float)Math.toRadians(amount);
        if (entity.isPassenger) {
            if (PlayerEntityModelMixin.isCrutch(((IHeldItemRenderer)entity).getHeldItem(entity.mainArm))) {
                this.getArm((HumanoidArm)entity.mainArm).zRot = this.getArm((HumanoidArm)entity.mainArm).zRot + roll * (rightHanded ? 1.0f : -1.0f);
            }
            if (PlayerEntityModelMixin.isCrutch(((IHeldItemRenderer)entity).getHeldItem(entity.mainArm.getOpposite()))) {
                this.getArm((HumanoidArm)entity.mainArm.getOpposite()).zRot = this.getArm((HumanoidArm)entity.mainArm.getOpposite()).zRot + roll * (rightHanded ? -1.0f : 1.0f);
            }
            return;
        }
        if (entity.attackTime == 0.0f || entity.mainArm != HumanoidArm.RIGHT) {
            PlayerEntityModelMixin.correctCrutchPose(((IHeldItemRenderer)entity).getHeldItem(HumanoidArm.RIGHT), this.getArm(HumanoidArm.RIGHT), mainLeg, offLeg, rightHanded, isPair);
        }
        if (entity.attackTime == 0.0f || entity.mainArm != HumanoidArm.LEFT) {
            PlayerEntityModelMixin.correctCrutchPose(((IHeldItemRenderer)entity).getHeldItem(HumanoidArm.LEFT), this.getArm(HumanoidArm.LEFT), mainLeg, offLeg, !rightHanded, isPair);
        }
        if (isPair) {
            this.getArm((HumanoidArm)HumanoidArm.RIGHT).zRot = roll;
            this.getArm((HumanoidArm)HumanoidArm.LEFT).zRot = -roll;
            offLeg.xRot = Math.abs(offLeg.xRot) * 0.3f + (float)Math.toRadians(40.0);
        } else if (isCrouching) {
            if (PlayerEntityModelMixin.isCrutch(((IHeldItemRenderer)entity).getHeldItem(entity.mainArm))) {
                this.getArm((HumanoidArm)entity.mainArm).zRot = roll * (rightHanded ? 1.0f : -1.0f);
            }
            if (PlayerEntityModelMixin.isCrutch(((IHeldItemRenderer)entity).getHeldItem(entity.mainArm.getOpposite()))) {
                this.getArm((HumanoidArm)entity.mainArm.getOpposite()).zRot = roll * (rightHanded ? -1.0f : 1.0f);
            }
        }
    }

    private <T extends PlayerRenderState> void animHandlingCanes(T entity, float ageInTicks, boolean isRightHanded, boolean isCrouching) {
        if (entity.isPassenger) {
            return;
        }
        if (PlayerEntityModelMixin.isCane(((IHeldItemRenderer)entity).getHeldItem(entity.mainArm))) {
            ModelPart mainArm = this.getArm(entity.mainArm);
            AnimationUtils.bobModelPart((ModelPart)mainArm, (float)ageInTicks, (float)(isRightHanded ? -1.0f : 1.0f));
            if (isCrouching) {
                mainArm.xRot = (float)((double)mainArm.xRot - Math.toRadians(30.0));
            }
        }
        if (PlayerEntityModelMixin.isCane(((IHeldItemRenderer)entity).getHeldItem(entity.mainArm.getOpposite()))) {
            ModelPart offArm = this.getArm(entity.mainArm.getOpposite());
            AnimationUtils.bobModelPart((ModelPart)offArm, (float)ageInTicks, (float)(isRightHanded ? 1.0f : -1.0f));
            if (isCrouching) {
                offArm.xRot = (float)((double)offArm.xRot - Math.toRadians(30.0));
            }
        }
    }

    private void animHandlingWalkers(PlayerRenderState state) {
        if (((IParentEntity)state).hasParentedEntities()) {
            return;
        }
        if (state.rightArmPose == HumanoidModel.ArmPose.EMPTY) {
            state.rightArmPose = HumanoidModel.ArmPose.ITEM;
        }
        if (state.leftArmPose == HumanoidModel.ArmPose.EMPTY) {
            state.leftArmPose = HumanoidModel.ArmPose.ITEM;
        }
    }

    private ModelPart getLeg(HumanoidArm arm) {
        return arm == HumanoidArm.RIGHT ? this.rightLeg : this.leftLeg;
    }

    private static boolean isCrutch(ItemStack stack) {
        return !stack.isEmpty() && stack.getItem() instanceof CrutchItem;
    }

    private static boolean isCane(ItemStack stack) {
        return !stack.isEmpty() && stack.getItem() instanceof CaneItem;
    }

    private static boolean isHoldingPair(IHeldItemRenderer entity) {
        return PlayerEntityModelMixin.isCrutch(entity.getHeldItem(HumanoidArm.RIGHT)) && PlayerEntityModelMixin.isCrutch(entity.getHeldItem(HumanoidArm.LEFT));
    }

    private static void correctCrutchPose(ItemStack crutch, ModelPart arm, ModelPart legMain, ModelPart legOff, boolean isMain, boolean isPair) {
        if (!PlayerEntityModelMixin.isCrutch(crutch)) {
            return;
        }
        arm.xRot = isPair ? legOff.xRot : (isMain ? legMain.xRot : legOff.xRot);
        arm.xRot *= 0.5f;
        arm.yRot = 0.0f;
        arm.zRot = 0.0f;
    }
}

