/*
 * Decompiled with CFR 0.152.
 */
package com.lying.mixin;

import com.lying.Wheelchairs;
import com.lying.chairspace.Chairspace;
import com.lying.entity.IParentedEntity;
import com.lying.init.WHCChairspaceConditions;
import com.lying.init.WHCEntityTypes;
import com.lying.mixin.EntityMixin;
import java.util.Optional;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.portal.TeleportTransition;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerPlayer.class})
public class ServerPlayerEntityMixin
extends EntityMixin {
    @Shadow
    public void stopRiding() {
    }

    @Inject(method={"teleport(Lnet/minecraft/world/level/portal/TeleportTransition;)Lnet/minecraft/server/level/ServerPlayer;"}, at={@At(value="HEAD")})
    private void whc$teleportTo(TeleportTransition teleportTarget, CallbackInfoReturnable<ServerPlayer> ci) {
        Optional<Entity> vehicleOpt = this.isPassenger() ? Optional.of(this.getVehicle()) : this.recallVehicle();
        Wheelchairs.LOGGER.info(" # teleportTo triggered in ServerPlayerEntity, vehicle: {}", (Object)vehicleOpt.isPresent());
        if (this.isRemoved()) {
            return;
        }
        Chairspace chairs = Chairspace.getChairspace(this.getServer());
        vehicleOpt.ifPresent(vehicle -> {
            if (vehicle.getType() == WHCEntityTypes.WHEELCHAIR.get()) {
                this.stopRiding();
                chairs.storeEntityInChairspace((Entity)vehicle, this.getUUID(), WHCChairspaceConditions.ON_FINISH_TELEPORT.get(), Chairspace.Flag.MOUNT);
            }
        });
        ServerPlayer player = (ServerPlayer)this;
        player.level().getEntitiesOfClass(LivingEntity.class, player.getBoundingBox().inflate(6.0), IParentedEntity.isChildOf((LivingEntity)player)).forEach(ent -> chairs.storeEntityInChairspace((Entity)ent, player.getUUID(), WHCChairspaceConditions.ON_FINISH_TELEPORT.get(), Chairspace.Flag.PARENT));
    }
}

