/*
 * Decompiled with CFR 0.152.
 */
package com.lying.mixin;

import com.google.common.collect.Lists;
import com.lying.entity.IParentedEntity;
import com.lying.utility.ServerEvents;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerLevel.class})
public class ServerWorldMixin {
    @Shadow
    public List<ServerPlayer> players = Lists.newArrayList();

    @Inject(method={"tickNonPassenger(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="TAIL")})
    private void whc$tickEntity(Entity entity, CallbackInfo ci) {
        if (entity instanceof LivingEntity) {
            LivingEntity parent = (LivingEntity)entity;
            parent.level().getEntitiesOfClass(LivingEntity.class, parent.getBoundingBox().inflate(6.0), IParentedEntity.isChildOf(parent)).forEach(child -> this.tickParented(parent, (LivingEntity)((IParentedEntity)child)));
        }
    }

    @Inject(method={"wakeUpAllPlayers()V"}, at={@At(value="HEAD")})
    private void whc$wakeSleepingPlayers(CallbackInfo ci) {
        this.players.stream().filter(LivingEntity::isSleeping).collect(Collectors.toList()).forEach(player -> ((ServerEvents.WakeUpEvent)ServerEvents.ON_WAKE_UP.invoker()).onWakeUp((LivingEntity)player));
    }

    private <T extends LivingEntity> void tickParented(LivingEntity parent, T child) {
        if (parent.hasPassenger(child)) {
            return;
        }
        child.setOldPosAndRot();
        ++child.tickCount;
        IParentedEntity.updateParentingBond(child, parent, Entity::setPos);
    }
}

