/*
 * Decompiled with CFR 0.152.
 */
package com.lying.neoforge;

import com.google.common.collect.Lists;
import com.lying.item.VestItem;
import com.lying.neoforge.VestChangeEvent;
import com.lying.neoforge.WheelchairsNeoForge;
import com.lying.neoforge.capability.VestCapability;
import com.lying.neoforge.network.SyncVestPacket;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

public class ServerBus {
    private static Map<ResourceKey<Level>, List<Entity>> SERVICE_ANIMALS = new HashMap<ResourceKey<Level>, List<Entity>>();

    @SubscribeEvent
    public static void serviceAnimalLoaded(EntityJoinLevelEvent event) {
        if (VestItem.isMobWithVest(event.getEntity())) {
            ServerBus.startTrackingVest(event.getEntity());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void serviceAnimalUnloaded(EntityLeaveLevelEvent event) {
        if (VestItem.isMobWithVest(event.getEntity())) {
            ServerBus.stopTrackingVest(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void serviceAnimalVestChanged(VestChangeEvent event) {
        if (event.isEmpty()) {
            ServerBus.stopTrackingVest(event.getEntity());
        } else {
            ServerBus.startTrackingVest(event.getEntity());
        }
        ServerBus.syncServiceAnimalToPlayers((Entity)((LivingEntity)event.getEntity()));
    }

    private static void stopTrackingVest(Entity ent) {
        if (ent.level().isClientSide()) {
            return;
        }
        ResourceKey world = ent.level().dimension();
        List<Entity> entities = SERVICE_ANIMALS.getOrDefault(world, Lists.newArrayList());
        entities.removeIf(e -> e.getUUID().equals(ent.getUUID()));
        SERVICE_ANIMALS.put((ResourceKey<Level>)world, entities);
    }

    private static void startTrackingVest(Entity ent) {
        if (ent.level().isClientSide()) {
            return;
        }
        ServerBus.stopTrackingVest(ent);
        ResourceKey world = ent.level().dimension();
        List<Entity> entities = SERVICE_ANIMALS.getOrDefault(world, Lists.newArrayList());
        entities.add(ent);
        SERVICE_ANIMALS.put((ResourceKey<Level>)world, entities);
        ServerBus.syncServiceAnimalToPlayers(ent);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void syncVestsToPlayer(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        Level world = player.level();
        if (world.isClientSide()) {
            return;
        }
        ServerBus.syncServiceAnimalsToPlayer(player, (ResourceKey<Level>)player.level().dimension());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void syncVestsFromPortal(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.getEntity().level().isClientSide()) {
            return;
        }
        ServerBus.syncServiceAnimalsToPlayer(event.getEntity(), (ResourceKey<Level>)event.getTo());
    }

    private static void syncServiceAnimalsToPlayer(Player player, ResourceKey<Level> newDim) {
        SERVICE_ANIMALS.getOrDefault(newDim, Lists.newArrayList()).forEach(ent -> {
            VestCapability cap = (VestCapability)ent.getCapability(WheelchairsNeoForge.VEST_DATA);
            if (cap == null) {
                return;
            }
            ServerBus.syncServiceAnimalToPlayer(ent, player);
        });
    }

    public static void syncServiceAnimalToPlayers(Entity ent) {
        VestCapability cap = (VestCapability)ent.getCapability(WheelchairsNeoForge.VEST_DATA);
        if (cap == null) {
            return;
        }
        Level world = ent.level();
        world.players().forEach(player -> ServerBus.syncServiceAnimalToPlayer(ent, player));
    }

    private static void syncServiceAnimalToPlayer(Entity ent, Player player) {
        VestCapability cap = (VestCapability)ent.getCapability(WheelchairsNeoForge.VEST_DATA);
        if (cap == null) {
            return;
        }
        Level world = ent.level();
        if (world.isClientSide() || player.level().dimension() != world.dimension()) {
            return;
        }
        SyncVestPacket.sendTo((ServerPlayer)player, ent.getUUID(), cap.get());
    }
}

