/*
 * Decompiled with CFR 0.152.
 */
package com.lying.neoforge;

import com.lying.Wheelchairs;
import com.lying.entity.StoolEntity;
import com.lying.entity.WalkerEntity;
import com.lying.entity.WheelchairEntity;
import com.lying.init.WHCEntityTypes;
import com.lying.item.VestItem;
import com.lying.neoforge.VestChangeEvent;
import com.lying.neoforge.capability.VestCapability;
import com.lying.utility.XPlatHandler;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.capabilities.EntityCapability;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@Mod(value="wheelchairs")
public final class WheelchairsNeoForge {
    private static final DeferredRegister<EntityDataSerializer<?>> DATA_SERIALIZERS = DeferredRegister.create((Registry)NeoForgeRegistries.ENTITY_DATA_SERIALIZERS, (String)"wheelchairs");
    public static final EntityCapability<VestCapability, Void> VEST_DATA = EntityCapability.createVoid((ResourceLocation)VestCapability.IDENTIFIER, VestCapability.class);
    public static Supplier<Player> getLocalPlayer = () -> null;

    public WheelchairsNeoForge(IEventBus bus) {
        Wheelchairs.LOGGER.info("# Common init");
        Wheelchairs.commonInit();
        DATA_SERIALIZERS.register("chair_upgrades", () -> WheelchairEntity.UPGRADE_LIST);
        DATA_SERIALIZERS.register(bus);
        bus.addListener(this::registerVestCapability);
        bus.addListener(this::registerEntityAttributes);
        NeoForge.EVENT_BUS.addListener(VestCapability::onLivingTick);
        Wheelchairs.HANDLER = new XPlatHandler(this){

            private static Optional<VestCapability> getVestCap(LivingEntity entity) {
                if (!VestItem.isValidMobForVest((Entity)entity)) {
                    return Optional.empty();
                }
                VestCapability cap = (VestCapability)entity.getCapability(VEST_DATA);
                return cap == null ? Optional.empty() : Optional.of(cap);
            }

            @Override
            public boolean hasVest(LivingEntity entity) {
                Optional<VestCapability> opt = 1.getVestCap(entity);
                return opt.isPresent() && opt.get().hasVest();
            }

            @Override
            public ItemStack getVest(LivingEntity entity) {
                Optional<VestCapability> opt = 1.getVestCap(entity);
                return opt.isPresent() ? opt.get().get() : ItemStack.EMPTY;
            }

            @Override
            public void setVest(LivingEntity entity, ItemStack stack) {
                1.getVestCap(entity).ifPresent(cap -> cap.setVest(stack));
                if (!entity.level().isClientSide()) {
                    NeoForge.EVENT_BUS.post((Event)new VestChangeEvent((Entity)entity, stack));
                }
            }
        };
    }

    public void registerVestCapability(RegisterCapabilitiesEvent event) {
        VestItem.APPLICABLE_MOBS.keySet().forEach(type -> event.registerEntity(VEST_DATA, type, (e, c) -> (VestCapability)e.getCapability(VEST_DATA)));
    }

    public void registerEntityAttributes(EntityAttributeCreationEvent event) {
        Wheelchairs.LOGGER.info(" # Registered entity attributes");
        event.put((EntityType)WHCEntityTypes.WHEELCHAIR.get(), WheelchairEntity.createWheelchairAttributes().build());
        event.put((EntityType)WHCEntityTypes.WALKER.get(), WalkerEntity.createWalkerAttributes().build());
        event.put((EntityType)WHCEntityTypes.STOOL.get(), StoolEntity.createStoolAttributes().build());
    }
}

