/*
 * Decompiled with CFR 0.152.
 */
package com.lying.neoforge.capability;

import com.lying.component.VestData;
import com.lying.init.WHCItems;
import com.lying.item.VestItem;
import com.lying.neoforge.ServerBus;
import com.lying.neoforge.WheelchairsNeoForge;
import com.lying.reference.Reference;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.items.IItemHandler;

public class VestCapability
extends VestData
implements IItemHandler {
    public static final ResourceLocation IDENTIFIER = Reference.ModInfo.prefix("vest_data");
    public boolean isDirty = false;

    public VestCapability(LivingEntity ownerIn) {
        super(ownerIn);
    }

    public CompoundTag serializeNBT(HolderLookup.Provider lookup) {
        CompoundTag data = new CompoundTag();
        super.writeToNbt(data, lookup);
        return data;
    }

    public void deserializeNBT(CompoundTag nbt, HolderLookup.Provider lookup) {
        super.readFromNbt(nbt, lookup);
    }

    public int getSlots() {
        return 1;
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return stack.is((Item)WHCItems.VEST.get());
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        super.setVest(stack.split(1));
        this.isDirty = true;
        return stack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount <= 0) {
            return ItemStack.EMPTY;
        }
        ItemStack stackInSlot = this.get().copy();
        this.setVest(ItemStack.EMPTY);
        this.isDirty = true;
        return stackInSlot;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.get();
    }

    @Override
    public void setVest(ItemStack stack) {
        super.setVest(stack);
        this.isDirty = true;
    }

    public static void onLivingTick(EntityTickEvent.Post event) {
        if (!(event.getEntity() instanceof LivingEntity) || !VestItem.isValidMobForVest(event.getEntity())) {
            return;
        }
        LivingEntity e = (LivingEntity)event.getEntity();
        VestCapability cap = (VestCapability)e.getCapability(WheelchairsNeoForge.VEST_DATA);
        if (cap == null) {
            return;
        }
        cap.tick();
        if (cap.isDirty && !e.level().isClientSide()) {
            ServerBus.syncServiceAnimalToPlayers((Entity)e);
            cap.isDirty = false;
        }
    }
}

