/*
 * Decompiled with CFR 0.152.
 */
package com.lying.neoforge.client;

import com.lying.Wheelchairs;
import com.lying.client.WheelchairsClient;
import com.lying.client.init.WHCModelParts;
import com.lying.client.renderer.entity.StoolEntityRenderer;
import com.lying.client.renderer.entity.WalkerEntityRenderer;
import com.lying.client.renderer.entity.WheelchairEntityRenderer;
import com.lying.client.screen.ChairInventoryScreen;
import com.lying.client.screen.WalkerInventoryScreen;
import com.lying.init.WHCEntityTypes;
import com.lying.init.WHCScreenHandlerTypes;
import com.lying.neoforge.WheelchairsNeoForge;
import com.lying.neoforge.network.SyncVestPacket;
import dev.architectury.networking.NetworkManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.CatRenderer;
import net.minecraft.client.renderer.entity.FoxRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.ParrotRenderer;
import net.minecraft.client.renderer.entity.WolfRenderer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;

@EventBusSubscriber(modid="wheelchairs", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class WheelchairsNeoForgeClient {
    @SubscribeEvent
    public static void setupClient(FMLClientSetupEvent event) {
        Wheelchairs.LOGGER.info(" # [CLIENT] Init");
        WheelchairsClient.clientInit();
        WheelchairsNeoForge.getLocalPlayer = () -> Minecraft.getInstance().player;
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), SyncVestPacket.PACKET_TYPE, SyncVestPacket.PACKET_CODEC, (value, context) -> {
            Player localPlayer = WheelchairsNeoForge.getLocalPlayer.get();
            if (localPlayer == null) {
                Wheelchairs.LOGGER.error("# Tried to synchronise a service animal vest before player entity created #");
                return;
            }
            Level world = localPlayer.level();
            if (world == null) {
                Wheelchairs.LOGGER.error("# Tried to synchronise a service animal vest before world set #");
                return;
            }
            world.getEntitiesOfClass(LivingEntity.class, localPlayer.getBoundingBox().inflate(5000.0), e -> e.getUUID().equals(value.entityID())).forEach(e -> Wheelchairs.HANDLER.setVest((LivingEntity)e, value.vestStack()));
        });
    }

    @SubscribeEvent
    public static void registerScreens(RegisterMenuScreensEvent event) {
        event.register((MenuType)WHCScreenHandlerTypes.WHEELCHAIR_INVENTORY_HANDLER.get(), ChairInventoryScreen::new);
        event.register((MenuType)WHCScreenHandlerTypes.WALKER_INVENTORY_HANDLER.get(), WalkerInventoryScreen::new);
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        Wheelchairs.LOGGER.info(" # [CLIENT] Registering entity renderers");
        event.registerEntityRenderer((EntityType)WHCEntityTypes.WHEELCHAIR.get(), WheelchairEntityRenderer::new);
        event.registerEntityRenderer((EntityType)WHCEntityTypes.WALKER.get(), WalkerEntityRenderer::new);
        event.registerEntityRenderer((EntityType)WHCEntityTypes.STOOL.get(), StoolEntityRenderer::new);
    }

    @SubscribeEvent
    public static void registerModelParts(EntityRenderersEvent.RegisterLayerDefinitions event) {
        Wheelchairs.LOGGER.info(" # [CLIENT] Registering entity model parts");
        WHCModelParts.init((layer, func) -> event.registerLayerDefinition(layer, func));
    }

    @SubscribeEvent
    public static void appendVestsEvent(EntityRenderersEvent.AddLayers event) {
        Wheelchairs.LOGGER.info(" # [CLIENT] Appending entity service vest layers");
        ((WolfRenderer)event.getRenderer(EntityType.WOLF)).addLayer(WheelchairsClient.getVestFeatureForType(EntityType.WOLF, (LivingEntityRenderer)event.getRenderer(EntityType.WOLF)));
        ((CatRenderer)event.getRenderer(EntityType.CAT)).addLayer(WheelchairsClient.getVestFeatureForType(EntityType.CAT, (LivingEntityRenderer)event.getRenderer(EntityType.CAT)));
        ((ParrotRenderer)event.getRenderer(EntityType.PARROT)).addLayer(WheelchairsClient.getVestFeatureForType(EntityType.PARROT, (LivingEntityRenderer)event.getRenderer(EntityType.PARROT)));
        ((FoxRenderer)event.getRenderer(EntityType.FOX)).addLayer(WheelchairsClient.getVestFeatureForType(EntityType.FOX, (LivingEntityRenderer)event.getRenderer(EntityType.FOX)));
    }
}

