/*
 * Decompiled with CFR 0.152.
 */
package com.lying.neoforge.network;

import com.lying.reference.Reference;
import dev.architectury.networking.NetworkManager;
import java.util.UUID;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class SyncVestPacket {
    private static final ResourceLocation PACKET_ID = Reference.ModInfo.prefix("sync_vest");
    public static final CustomPacketPayload.Type<Payload> PACKET_TYPE = new CustomPacketPayload.Type(PACKET_ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, Payload> PACKET_CODEC = CustomPacketPayload.codec(Payload::write, Payload::new);

    public static void sendTo(ServerPlayer player, UUID entityID, ItemStack stack) {
        NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new Payload(entityID, stack));
    }

    public record Payload(UUID entityID, ItemStack vestStack) implements CustomPacketPayload
    {
        public Payload(RegistryFriendlyByteBuf buffer) {
            this(buffer.readUUID(), (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer));
        }

        public void write(RegistryFriendlyByteBuf buffer) {
            buffer.writeUUID(this.entityID);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)this.vestStack);
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return PACKET_TYPE;
        }
    }
}

