/*
 * Decompiled with CFR 0.152.
 */
package com.lying.network;

import com.lying.reference.Reference;
import dev.architectury.networking.NetworkManager;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class AACMessagePacket {
    public static void sendToServer(Component message, Player player) {
        NetworkManager.sendToServer((CustomPacketPayload)new Payload.Send(message, player.getUUID(), player.getDisplayName()));
    }

    public static void sendToPlayer(ServerPlayer player, Payload.Send payload) {
        NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)payload.echo());
    }

    public static abstract class Payload
    implements CustomPacketPayload {
        protected final Component message;
        protected final Component playerName;
        protected final UUID playerID;

        protected Payload(Component message, UUID playerID, Component playerName) {
            this.message = message;
            this.playerID = playerID;
            this.playerName = playerName;
        }

        public Component message() {
            return this.message;
        }

        public Component playerName() {
            return this.playerName;
        }

        public UUID playerID() {
            return this.playerID;
        }

        protected static ResourceLocation of(NetworkManager.Side side) {
            return Reference.ModInfo.prefix("aac_message_" + side.name().toLowerCase());
        }

        public static class Receive
        extends Payload {
            public static final ResourceLocation PACKET_ID = Receive.of(NetworkManager.Side.S2C);
            public static final CustomPacketPayload.Type<Receive> PACKET_TYPE = new CustomPacketPayload.Type(PACKET_ID);
            public static final StreamCodec<RegistryFriendlyByteBuf, Receive> PACKET_CODEC = StreamCodec.composite((StreamCodec)ComponentSerialization.TRUSTED_STREAM_CODEC, Payload::message, (StreamCodec)UUIDUtil.STREAM_CODEC, Payload::playerID, (StreamCodec)ComponentSerialization.TRUSTED_STREAM_CODEC, Payload::playerName, Receive::new);

            protected Receive(Component message, UUID playerID, Component playerName) {
                super(message, playerID, playerName);
            }

            public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
                return PACKET_TYPE;
            }
        }

        public static class Send
        extends Payload {
            public static final ResourceLocation PACKET_ID = Send.of(NetworkManager.Side.C2S);
            public static final CustomPacketPayload.Type<Send> PACKET_TYPE = new CustomPacketPayload.Type(PACKET_ID);
            public static final StreamCodec<RegistryFriendlyByteBuf, Send> PACKET_CODEC = StreamCodec.composite((StreamCodec)ComponentSerialization.TRUSTED_STREAM_CODEC, Payload::message, (StreamCodec)UUIDUtil.STREAM_CODEC, Payload::playerID, (StreamCodec)ComponentSerialization.TRUSTED_STREAM_CODEC, Payload::playerName, Send::new);

            protected Send(Component message, UUID playerID, Component playerName) {
                super(message, playerID, playerName);
            }

            public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
                return PACKET_TYPE;
            }

            public Receive echo() {
                return new Receive(this.message, this.playerID, this.playerName);
            }
        }
    }
}

