/*
 * Decompiled with CFR 0.152.
 */
package com.lying.network;

import com.lying.network.WHCPacketHandler;
import dev.architectury.networking.NetworkManager;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class OpenInventoryScreenPacket {
    private static final ResourceLocation PACKET_ID = WHCPacketHandler.OPEN_INVENTORY_ID;
    public static final CustomPacketPayload.Type<Payload> PACKET_TYPE = new CustomPacketPayload.Type(PACKET_ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, Payload> PACKET_CODEC = CustomPacketPayload.codec(Payload::write, Payload::read);

    public static void send() {
        OpenInventoryScreenPacket.send(null);
    }

    public static void send(UUID targetID) {
        NetworkManager.sendToServer((CustomPacketPayload)new Payload(targetID == null ? Optional.empty() : Optional.of(targetID)));
    }

    public static class Payload
    implements CustomPacketPayload {
        private Optional<UUID> targetId = Optional.empty();

        protected Payload(@NotNull Optional<UUID> idIn) {
            this.targetId = idIn;
        }

        public static Payload read(RegistryFriendlyByteBuf buffer) {
            if (buffer.readBoolean()) {
                return new Payload(Optional.of(buffer.readUUID()));
            }
            return new Payload(Optional.empty());
        }

        public void write(RegistryFriendlyByteBuf buffer) {
            this.targetId.ifPresentOrElse(id -> {
                buffer.writeBoolean(true);
                buffer.writeUUID(id);
            }, () -> buffer.writeBoolean(false));
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return PACKET_TYPE;
        }

        public boolean openTarget() {
            return this.targetId.isPresent();
        }

        public UUID entityID() {
            return this.targetId.get();
        }
    }
}

