/*
 * Decompiled with CFR 0.152.
 */
package com.lying.network;

import com.lying.Wheelchairs;
import com.lying.entity.ChairUpgrade;
import com.lying.entity.IFlyingMount;
import com.lying.entity.WalkerEntity;
import com.lying.entity.WheelchairEntity;
import com.lying.init.WHCEntityTypes;
import com.lying.network.AACMessagePacket;
import com.lying.network.FlyingMountRocketPacket;
import com.lying.network.ForceUnparentPacket;
import com.lying.network.OpenInventoryScreenPacket;
import com.lying.network.SetSeatbeltPacket;
import com.lying.network.StartFlyingPacket;
import com.lying.reference.Reference;
import com.lying.screen.ChairInventoryScreenHandler;
import com.lying.screen.WalkerInventoryScreenHandler;
import com.lying.utility.ServerBus;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.menu.MenuRegistry;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;

public class WHCPacketHandler {
    public static final ResourceLocation OPEN_INVENTORY_ID = WHCPacketHandler.make("open_inventory_screen");
    public static final ResourceLocation FLYING_START_ID = WHCPacketHandler.make("flying_start");
    public static final ResourceLocation FLYING_ROCKET_ID = WHCPacketHandler.make("flying_rocket");
    public static final ResourceLocation FORCE_UNPARENT_ID = WHCPacketHandler.make("force_unparent");
    public static final ResourceLocation AAC_MESSAGE_ID = WHCPacketHandler.make("aac_message");
    public static final ResourceLocation SET_SEATBELT_ID = WHCPacketHandler.make("set_seatbelt");

    private static ResourceLocation make(String nameIn) {
        return Reference.ModInfo.prefix(nameIn);
    }

    public static void initServer() {
        Wheelchairs.LOGGER.info(" # Registered server-side packet receivers");
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), AACMessagePacket.Payload.Send.PACKET_TYPE, AACMessagePacket.Payload.Send.PACKET_CODEC, (value, context) -> context.getPlayer().getServer().getPlayerList().getPlayers().forEach(p -> AACMessagePacket.sendToPlayer(p, value)));
        WHCPacketHandler.initKeyHandling();
        WHCPacketHandler.initUpgradeHandling();
    }

    private static void initKeyHandling() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), FlyingMountRocketPacket.PACKET_TYPE, FlyingMountRocketPacket.PACKET_CODEC, (value, context) -> {
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            ItemStack stack = player.getItemInHand(value.hand());
            if (stack.getItem() != Items.FIREWORK_ROCKET) {
                return;
            }
            Entity vehicle = player.getVehicle();
            if (vehicle == null) {
                return;
            }
            if (!(vehicle instanceof LivingEntity) || !(vehicle instanceof IFlyingMount)) {
                return;
            }
            player.getServer().execute(() -> {
                Item item = stack.getItem();
                if (((IFlyingMount)vehicle).canUseRocketNow()) {
                    Level world = player.level();
                    FireworkRocketEntity rocket = new FireworkRocketEntity(world, stack, (LivingEntity)vehicle);
                    world.addFreshEntity((Entity)rocket);
                    if (!player.getAbilities().instabuild) {
                        stack.shrink(1);
                    }
                    player.awardStat(Stats.ITEM_USED.get((Object)item));
                }
            });
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), StartFlyingPacket.PACKET_TYPE, StartFlyingPacket.PACKET_CODEC, (value, context) -> {
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            if (player.isPassenger() && player.getVehicle() instanceof IFlyingMount) {
                player.getServer().execute(() -> ((IFlyingMount)player.getVehicle()).startFlying());
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), SetSeatbeltPacket.PACKET_TYPE, SetSeatbeltPacket.PACKET_CODEC, (value, context) -> {
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            UUID id = player.getUUID();
            boolean currentSetting = ServerBus.getSeatbelt(id);
            ServerBus.setSeatbelt(id, value.setting() && player.isPassenger());
            if (ServerBus.getSeatbelt(id) != currentSetting) {
                player.sendSystemMessage((Component)Component.translatable((String)("gui.wheelchairs.seatbelt_" + (!currentSetting ? "on" : "off"))));
            }
        });
    }

    private static void initUpgradeHandling() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), ForceUnparentPacket.PACKET_TYPE, ForceUnparentPacket.PACKET_CODEC, (value, context) -> {
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            player.getServer().execute(() -> {
                if (player.isPassenger() && player.getVehicle().getType() == WHCEntityTypes.WHEELCHAIR.get() && ((WheelchairEntity)player.getVehicle()).hasParent()) {
                    ((WheelchairEntity)player.getVehicle()).forceUnbind();
                }
            });
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), OpenInventoryScreenPacket.PACKET_TYPE, OpenInventoryScreenPacket.PACKET_CODEC, (value, context) -> {
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            if (player.isPassenger() && player.getVehicle().getType() == WHCEntityTypes.WHEELCHAIR.get() && ((WheelchairEntity)player.getVehicle()).getUpgrades().stream().anyMatch(ChairUpgrade::enablesScreen)) {
                WheelchairEntity vehicle = (WheelchairEntity)player.getVehicle();
                MenuRegistry.openMenu((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider((id, playerInventory, custom) -> new ChairInventoryScreenHandler(id, playerInventory, vehicle), vehicle.getDisplayName()));
                return;
            }
            if (value.openTarget()) {
                UUID uuid = value.entityID();
                player.level().getEntities((EntityTypeTest)WHCEntityTypes.WALKER.get(), player.getBoundingBox().inflate(4.0), WalkerEntity::hasInventory).stream().filter(e -> e.getUUID().equals(uuid)).findFirst().ifPresent(walker -> MenuRegistry.openMenu((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider((id, playerInventory, custom) -> new WalkerInventoryScreenHandler(id, playerInventory, walker.getInventory(), (WalkerEntity)walker), walker.getDisplayName())));
            }
        });
    }
}

