/*
 * Decompiled with CFR 0.152.
 */
package com.lying.screen;

import com.lying.entity.ChairUpgrade;
import com.lying.entity.WheelchairEntity;
import com.lying.init.WHCChairUpgrades;
import com.lying.init.WHCEntityTypes;
import com.lying.init.WHCScreenHandlerTypes;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;

public class ChairInventoryScreenHandler
extends AbstractContainerMenu {
    private final Container inv;
    public final boolean hasStorage;
    public final boolean hasPlacer;

    public ChairInventoryScreenHandler(int syncId, Inventory playerInventory, final WheelchairEntity chair) {
        super((MenuType)WHCScreenHandlerTypes.WHEELCHAIR_INVENTORY_HANDLER.get(), syncId);
        int l;
        int k;
        boolean noChair = chair == null;
        this.inv = noChair ? new SimpleContainer(16) : chair.getInventory();
        this.hasStorage = !noChair && chair.hasUpgrade(WHCChairUpgrades.STORAGE.get());
        this.hasPlacer = !noChair && chair.hasUpgrade(WHCChairUpgrades.PLACER.get());
        this.addSlot(new Slot(this, this.inv, 0, 143, 36){

            public boolean isActive() {
                return chair.hasUpgrade(WHCChairUpgrades.PLACER.get());
            }

            public boolean mayPlace(ItemStack stack) {
                return stack.getItem() instanceof BlockItem;
            }
        });
        for (k = 0; k < 3; ++k) {
            for (l = 0; l < 5; ++l) {
                this.addSlot(new Slot(this, this.inv, 1 + l + k * 5, 44 + l * 18, 18 + k * 18){

                    public boolean isActive() {
                        return chair.hasUpgrade(WHCChairUpgrades.STORAGE.get());
                    }
                });
            }
        }
        for (k = 0; k < 3; ++k) {
            for (l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + k * 9 + 9, 8 + l * 18, 102 + (k - 1) * 18));
            }
        }
        for (k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)playerInventory, k, 8 + k * 18, 142));
        }
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        ItemStack stack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (slot != null && slot.hasItem()) {
            ItemStack stackInSlot = slot.getItem();
            stack = stackInSlot.copy();
            int chairInvSize = this.inv.getContainerSize();
            if (slotIndex < chairInvSize) {
                if (!this.moveItemStackTo(stackInSlot, chairInvSize, this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
            } else if (!this.moveItemStackTo(stackInSlot, 1, chairInvSize, false)) {
                int invStart = chairInvSize;
                int hotbarStart = invStart + 27;
                int hotbarEnd = hotbarStart + 9;
                if (slotIndex >= hotbarStart && slotIndex < hotbarEnd ? !this.moveItemStackTo(stackInSlot, invStart, hotbarStart, false) : (slotIndex >= invStart && slotIndex < hotbarStart ? !this.moveItemStackTo(stackInSlot, hotbarStart, hotbarEnd, false) : !this.moveItemStackTo(stackInSlot, hotbarStart, hotbarStart, false))) {
                    return ItemStack.EMPTY;
                }
                return ItemStack.EMPTY;
            }
            if (stackInSlot.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return stack;
    }

    public boolean stillValid(Player player) {
        return ChairInventoryScreenHandler.isValidForUse(player);
    }

    public static boolean isValidForUse(Player player) {
        return player.isAlive() && player.isPassenger() && player.getVehicle().getType() == WHCEntityTypes.WHEELCHAIR.get() && ((WheelchairEntity)player.getVehicle()).getUpgrades().stream().anyMatch(ChairUpgrade::enablesScreen);
    }
}

