/*
 * Decompiled with CFR 0.152.
 */
package com.lying.screen;

import com.lying.entity.WalkerEntity;
import com.lying.init.WHCScreenHandlerTypes;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class WalkerInventoryScreenHandler
extends AbstractContainerMenu {
    private final Container inv;
    private final WalkerEntity walker;

    public WalkerInventoryScreenHandler(int syncId, Inventory playerInventory, Container inv) {
        this(syncId, playerInventory, inv, null);
    }

    public WalkerInventoryScreenHandler(int syncId, Inventory playerInventory, Container inv, WalkerEntity walkerIn) {
        super((MenuType)WHCScreenHandlerTypes.WALKER_INVENTORY_HANDLER.get(), syncId);
        int l;
        int k;
        this.inv = inv;
        this.walker = walkerIn;
        for (k = 0; k < 3; ++k) {
            for (l = 0; l < 5; ++l) {
                this.addSlot(new Slot(inv, l + k * 5, 44 + l * 18, 18 + k * 18));
            }
        }
        for (k = 0; k < 3; ++k) {
            for (l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + k * 9 + 9, 8 + l * 18, 102 + (k - 1) * 18));
            }
        }
        for (k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)playerInventory, k, 8 + k * 18, 142));
        }
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        ItemStack stack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (slot != null && slot.hasItem()) {
            ItemStack stackInSlot = slot.getItem();
            stack = stackInSlot.copy();
            int chairInvSize = this.inv.getContainerSize();
            if (slotIndex < chairInvSize) {
                if (!this.moveItemStackTo(stackInSlot, chairInvSize, this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
            } else if (!this.moveItemStackTo(stackInSlot, 0, chairInvSize, false)) {
                int invStart = chairInvSize;
                int hotbarStart = invStart + 27;
                int hotbarEnd = hotbarStart + 9;
                if (slotIndex >= hotbarStart && slotIndex < hotbarEnd ? !this.moveItemStackTo(stackInSlot, invStart, hotbarStart, false) : (slotIndex >= invStart && slotIndex < hotbarStart ? !this.moveItemStackTo(stackInSlot, hotbarStart, hotbarEnd, false) : !this.moveItemStackTo(stackInSlot, hotbarStart, hotbarStart, false))) {
                    return ItemStack.EMPTY;
                }
                return ItemStack.EMPTY;
            }
            if (stackInSlot.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return stack;
    }

    public boolean stillValid(Player player) {
        return player.isAlive() && (this.walker == null || this.walker.isAlive() && this.walker.hasInventory() && (double)player.distanceTo((Entity)this.walker) <= 4.0);
    }
}

