/*
 * Decompiled with CFR 0.152.
 */
package com.lying.utility;

import com.lying.Wheelchairs;
import com.lying.chairspace.Chairspace;
import com.lying.data.WHCTags;
import com.lying.entity.IParentedEntity;
import com.lying.entity.WalkerEntity;
import com.lying.entity.WheelchairEntity;
import com.lying.init.WHCChairspaceConditions;
import com.lying.init.WHCEntityTypes;
import com.lying.item.VestItem;
import com.lying.utility.ServerEvents;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.event.events.common.PlayerEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import org.jetbrains.annotations.Nullable;

public class ServerBus {
    private static final Map<UUID, Boolean> SEATBELT_LOG = new HashMap<UUID, Boolean>();

    public static void toggleSeatbelt(UUID id) {
        ServerBus.setSeatbelt(id, !ServerBus.getSeatbelt(id));
    }

    public static boolean getSeatbelt(UUID id) {
        return SEATBELT_LOG.getOrDefault(id, false);
    }

    public static void setSeatbelt(UUID id, boolean bool) {
        SEATBELT_LOG.put(id, bool);
    }

    public static void registerEventCallbacks() {
        ServerEvents.AFTER_LIVING_CHANGE_MOUNT_START.register((living, next, last) -> Wheelchairs.LOGGER.info("Mount changed: {}, {} -> {}", new Object[]{living.getName().getString(), last == null ? "NULL" : last.getName().getString(), next == null ? "NULL" : next.getName().getString()}));
        ServerBus.registerChairspaceEvents();
        ServerBus.registerMountEvents();
        PlayerEvent.PLAYER_CLONE.register((oldPlayer, newPlayer, oldIsAlive) -> {
            Level world = newPlayer.level();
            if (!world.isClientSide() && !((ServerLevel)world).getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY)) {
                Inventory oldInv = oldPlayer.getInventory();
                Inventory newInv = newPlayer.getInventory();
                for (int i = 0; i < oldInv.getContainerSize(); ++i) {
                    ItemStack stack = oldInv.getItem(i);
                    if (stack.isEmpty() || !stack.is(WHCTags.PRESERVED)) continue;
                    newInv.setItem(i, stack.copy());
                }
            }
        });
    }

    public static void invokeMountChange(LivingEntity living, @Nullable Entity nextMount, @Nullable Entity lastMount) {
        ((ServerEvents.LivingChangeMount)ServerEvents.AFTER_LIVING_CHANGE_MOUNT_START.invoker()).afterChangeMount(living, nextMount, lastMount);
        ((ServerEvents.LivingChangeMount)ServerEvents.AFTER_LIVING_CHANGE_MOUNT_END.invoker()).afterChangeMount(living, nextMount, lastMount);
    }

    private static void registerChairspaceEvents() {
        Wheelchairs.LOGGER.info(" # Registered Chairspace event handlers");
        EntityEvent.LIVING_DEATH.register((entity, damage) -> {
            boolean shouldDropContents;
            if (entity.getType() != EntityType.PLAYER || entity.level().isClientSide()) {
                return EventResult.pass();
            }
            Chairspace chairs = Chairspace.getChairspace(entity.getServer());
            boolean bl = shouldDropContents = !((ServerLevel)entity.level()).getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY);
            if (entity.isPassenger() && entity.getVehicle().getType() == WHCEntityTypes.WHEELCHAIR.get()) {
                Entity vehicle = entity.getVehicle();
                if (shouldDropContents) {
                    ((WheelchairEntity)vehicle).dropEquipment((ServerLevel)vehicle.level());
                }
                chairs.storeEntityInChairspace(vehicle, entity.getUUID(), WHCChairspaceConditions.ON_RESPAWN.get(), Chairspace.Flag.MOUNT);
            }
            entity.level().getEntitiesOfClass(LivingEntity.class, entity.getBoundingBox().inflate(6.0), IParentedEntity.isChildOf(entity)).forEach(ent -> {
                if (ent.getType() == WHCEntityTypes.WALKER && ((WalkerEntity)ent).hasInventory()) {
                    ((WalkerEntity)ent).dropEquipment((ServerLevel)entity.level());
                }
                chairs.storeEntityInChairspace((Entity)ent, entity.getUUID(), WHCChairspaceConditions.ON_RESPAWN.get(), Chairspace.Flag.PARENT);
            });
            return EventResult.pass();
        });
        PlayerEvent.PLAYER_RESPAWN.register((newPlayer, conqueredEnd, removalReason) -> {
            if (!newPlayer.level().isClientSide()) {
                Chairspace.getChairspace(newPlayer.getServer()).reactToEvent(PlayerEvent.PLAYER_RESPAWN, (Entity)newPlayer);
            }
        });
        PlayerEvent.PLAYER_QUIT.register(player -> {
            if (player == null || player.level() == null) {
                return;
            }
            boolean isClient = player.level().isClientSide();
            Chairspace chairs = Chairspace.getChairspace(player.getServer());
            IParentedEntity.getParentedEntitiesOf((LivingEntity)player).forEach(ent -> {
                ((IParentedEntity)ent).clearParent();
                if (ent.isVehicle()) {
                    return;
                }
                if (isClient) {
                    ent.discard();
                } else {
                    chairs.storeEntityInChairspace((Entity)ent, player.getUUID(), WHCChairspaceConditions.ON_LOGIN.get(), Chairspace.Flag.PARENT);
                }
            });
        });
        PlayerEvent.PLAYER_JOIN.register(player -> {
            if (player == null || player.level() == null || player.level().isClientSide()) {
                return;
            }
            Chairspace.getChairspace(player.getServer()).reactToEvent(PlayerEvent.PLAYER_JOIN, (Entity)player);
        });
        ServerEvents.AFTER_PLAYER_CHANGE_GAME_MODE.register((player, mode) -> {
            if (player.level().isClientSide()) {
                return;
            }
            Chairspace chairs = Chairspace.getChairspace(player.getServer());
            if (mode == GameType.SPECTATOR) {
                if (player.isPassenger() && player.getVehicle().getType() == WHCEntityTypes.WHEELCHAIR.get()) {
                    Entity vehicle = player.getVehicle();
                    player.stopRiding();
                    chairs.storeEntityInChairspace(vehicle, player.getUUID(), WHCChairspaceConditions.ON_LEAVE_SPECTATOR.get(), Chairspace.Flag.MOUNT);
                }
                player.level().getEntitiesOfClass(LivingEntity.class, player.getBoundingBox().inflate(6.0), IParentedEntity.isChildOf((LivingEntity)player)).forEach(ent -> {
                    if (ent.getType() == WHCEntityTypes.WALKER.get() && ((WalkerEntity)ent).hasInventory()) {
                        ((WalkerEntity)ent).dropEquipment((ServerLevel)ent.level());
                    }
                    chairs.storeEntityInChairspace((Entity)ent, player.getUUID(), WHCChairspaceConditions.ON_LEAVE_SPECTATOR.get(), Chairspace.Flag.PARENT);
                });
            }
            chairs.reactToEvent(ServerEvents.AFTER_PLAYER_CHANGE_GAME_MODE, (Entity)player);
        });
        ServerEvents.AFTER_PLAYER_TELEPORT.register(player -> {
            if (!player.level().isClientSide()) {
                Chairspace.getChairspace(player.getServer()).reactToEvent(ServerEvents.AFTER_PLAYER_TELEPORT, (Entity)player);
            }
        });
        ServerEvents.ON_START_FLYING.register(living -> {
            if (living.level().isClientSide()) {
                return;
            }
            Chairspace chairs = Chairspace.getChairspace(living.getServer());
            living.level().getEntities((EntityTypeTest)WHCEntityTypes.WALKER.get(), living.getBoundingBox().inflate(6.0), IParentedEntity.isChildOf(living)).forEach(ent -> chairs.storeEntityInChairspace((Entity)ent, living.getUUID(), WHCChairspaceConditions.ON_STOP_FLYING.get(), Chairspace.Flag.PARENT));
        });
        ServerEvents.ON_STOP_FLYING.register(living -> {
            if (!living.level().isClientSide()) {
                Chairspace.getChairspace(living.getServer()).reactToEvent(ServerEvents.ON_STOP_FLYING, (Entity)living);
            }
        });
        EntityEvent.LIVING_DEATH.register((entity, damageSource) -> {
            if (VestItem.isValidMobForVest((Entity)entity) && !VestItem.getVest(entity).isEmpty()) {
                UUID ownerID = VestItem.getVestedMobOwner((Entity)entity);
                if (ownerID == null) {
                    return EventResult.pass();
                }
                entity.setHealth(1.0f);
                Chairspace chairs = Chairspace.getChairspace(entity.getServer());
                chairs.storeEntityInChairspace((Entity)entity, ownerID, WHCChairspaceConditions.ON_WAKE_UP.get(), new Chairspace.Flag[0]);
                return EventResult.interruptFalse();
            }
            return EventResult.pass();
        });
        ServerEvents.ON_WAKE_UP.register(player -> {
            if (!player.level().isClientSide()) {
                Chairspace.getChairspace(player.getServer()).reactToEvent(ServerEvents.ON_WAKE_UP, (Entity)player);
            }
        });
    }

    private static void registerMountEvents() {
        ServerEvents.AFTER_LIVING_CHANGE_MOUNT_START.register((living, next, last) -> {
            if (last != null && last.getType() == WHCEntityTypes.WHEELCHAIR.get()) {
                ((WheelchairEntity)last).getUpgrades().forEach(upg -> upg.onStopRiding(living));
            }
            if (next != null && next.getType() == WHCEntityTypes.WHEELCHAIR.get()) {
                ((WheelchairEntity)next).getUpgrades().forEach(upg -> upg.onStartRiding(living));
            }
            IParentedEntity.clearParentedEntities(living, null);
        });
        ServerEvents.AFTER_LIVING_CHANGE_MOUNT_END.register((living, next, last) -> {
            if (last != null && last.getType() == WHCEntityTypes.WHEELCHAIR.get() && last.isAlive() && living.getType() == EntityType.PLAYER) {
                WheelchairEntity chair = (WheelchairEntity)last;
                if (next != null && next.getType() != WHCEntityTypes.WHEELCHAIR.get() && (!chair.hasInventory() || chair.getInventory().isEmpty())) {
                    chair.convertToItem((Player)living);
                }
            }
        });
        ServerEvents.ON_ENTITY_PARENT.register((living, walker) -> IParentedEntity.clearParentedEntities(living, walker));
    }
}

