/*
 * Decompiled with CFR 0.152.
 */
package com.lying.utility;

import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class WHCUtils {
    public static Vec3 globalToLocal(Vec3 movement, float yaw) {
        return WHCUtils.localToGlobal(movement, 1.0f - yaw);
    }

    public static Vec3 localToGlobal(Vec3 movement, float yaw) {
        float sin = Mth.sin((float)(yaw * ((float)Math.PI / 180)));
        float cos = Mth.cos((float)(yaw * ((float)Math.PI / 180)));
        return new Vec3(movement.x * (double)cos - movement.z * (double)sin, movement.y, movement.z * (double)cos + movement.x * (double)sin);
    }

    public static float wrapDegrees(float value) {
        switch ((int)Math.signum(value)) {
            case -1: {
                return value + (float)Mth.ceil((float)(Math.abs(value) / 360.0f)) * 360.0f;
            }
            default: {
                return value;
            }
            case 1: 
        }
        return value % 360.0f;
    }

    public static float calculateSpin(float movement, float diameter) {
        if (movement == 0.0f) {
            return 0.0f;
        }
        float radius = diameter * 0.5f;
        float circumference = (float)Math.PI * 2 * radius;
        float spin = Math.abs(movement) / circumference * 360.0f * Math.signum(movement);
        return WHCUtils.wrapDegrees(spin);
    }
}

