/*
 * Decompiled with CFR 0.152.
 */
package useless.btabreeding.mixin;

import com.mojang.nbt.tags.CompoundTag;
import java.util.List;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.MobPathfinder;
import net.minecraft.core.entity.animal.Creature;
import net.minecraft.core.entity.animal.MobAnimal;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import useless.btabreeding.BtaBreeding;
import useless.btabreeding.IBreeding;

@Mixin(value={MobAnimal.class}, remap=false)
public abstract class MobAnimalMixin
extends MobPathfinder
implements Creature,
IBreeding {
    @Unique
    public int breedingTimer = 0;
    @Unique
    public int fedTimer = 0;
    @Unique
    public int childhoodTimer = 0;
    @Unique
    public boolean isPersistent = false;
    @Unique
    public Entity passiveTarget = null;

    @Shadow
    public abstract boolean isFavouriteItem(ItemStack var1);

    public MobAnimalMixin(World world) {
        super(world);
    }

    @Override
    public int btabreeding$getBreedingTimer() {
        return this.breedingTimer;
    }

    @Override
    public int btabreeding$getFedTimer() {
        return this.fedTimer;
    }

    @Override
    public int btabreeding$getChildTimer() {
        return this.childhoodTimer;
    }

    @Override
    public void btabreeding$setBreedingTimer(int value) {
        this.breedingTimer = value;
    }

    @Override
    public void btabreeding$setFedTimer(int value) {
        this.fedTimer = value;
    }

    @Override
    public void btabreeding$setChildTimer(int value) {
        this.childhoodTimer = value;
    }

    @Override
    public boolean btabreeding$isBreedable() {
        return this.breedingTimer <= 0 && !this.btabreeding$isBaby();
    }

    @Override
    public boolean btabreeding$isFed() {
        return this.fedTimer > 0;
    }

    @Override
    public boolean btabreeding$isFoodItem(ItemStack stack) {
        return this.isFavouriteItem(stack);
    }

    @Override
    public void btabreeding$spawnBaby(IBreeding partner) {
        if (!this.world.isClientSide) {
            MobAnimal entity = (MobAnimal)BtaBreeding.createEntity(this.getClass(), this.world);
            entity.moveTo(this.x, this.y, this.z, 0.0f, 0.0f);
            entity.spawnInit();
            ((IBreeding)entity).btabreeding$setChildTimer(6000);
            this.world.entityJoinedWorld((Entity)entity);
            this.btabreeding$setFedTimer(0);
            partner.btabreeding$setFedTimer(0);
            this.btabreeding$setBreedingTimer(2000);
            partner.btabreeding$setBreedingTimer(2000);
            this.btabreeding$setPassiveTarget(null);
            partner.btabreeding$setPassiveTarget(null);
        }
    }

    @Override
    public boolean btabreeding$isBaby() {
        return this.btabreeding$getChildTimer() > 0;
    }

    @Override
    public void btabreeding$setPassiveTarget(Entity entity) {
        this.passiveTarget = entity;
        if (entity == null) {
            this.pathToEntity = null;
        }
    }

    @Override
    public Entity btabreeding$getPassiveTarget() {
        return this.passiveTarget;
    }

    public boolean interact(Player entityplayer) {
        ItemStack item = entityplayer.inventory.getCurrentItem();
        boolean flag = super.interact(entityplayer);
        if (item != null && this.btabreeding$isFoodItem(item) && (this.btabreeding$isBreedable() || this.btabreeding$isBaby()) && item.consumeItem(entityplayer)) {
            if (this.btabreeding$isBaby()) {
                this.btabreeding$setChildTimer((int)((float)this.btabreeding$getChildTimer() * 0.75f));
                double d = this.random.nextGaussian() * 0.02;
                double d1 = this.random.nextGaussian() * 0.02;
                double d2 = this.random.nextGaussian() * 0.02;
                this.world.spawnParticle("soulflame", this.x + (double)(this.random.nextFloat() * this.bbWidth * 2.0f) - (double)this.bbWidth, this.y + 0.5 + (double)(this.random.nextFloat() * this.bbHeight), this.z + (double)(this.random.nextFloat() * this.bbWidth * 2.0f) - (double)this.bbWidth, d, d1, d2, 0);
            } else {
                this.btabreeding$setFedTimer(300);
                this.isPersistent = true;
            }
            return true;
        }
        return flag;
    }

    public void onLivingUpdate() {
        List list;
        if (this.breedingTimer > 0) {
            --this.breedingTimer;
        }
        if (this.btabreeding$getChildTimer() > 0) {
            this.isPersistent = true;
            this.btabreeding$setChildTimer(this.btabreeding$getChildTimer() - 1);
        }
        if (this.btabreeding$isFed()) {
            --this.fedTimer;
        }
        if ((list = this.world.getEntitiesWithinAABBExcludingEntity((Entity)this, this.bb.expand((double)0.2f, 0.0, (double)0.2f).move((double)-0.1f, (double)-0.1f, (double)-0.1f))) != null && !list.isEmpty() && !this.isMovementCeased()) {
            for (Entity entity : list) {
                if (!(entity instanceof IBreeding) || !entity.getClass().isInstance(this) || !this.btabreeding$isFed() || !((IBreeding)entity).btabreeding$isFed() || !this.btabreeding$isBreedable() || !((IBreeding)entity).btabreeding$isBreedable()) continue;
                this.btabreeding$spawnBaby((IBreeding)entity);
                break;
            }
        }
        if (this.tickCount % 40 == 0 && !this.isMovementCeased()) {
            list = this.world.getEntitiesWithinAABBExcludingEntity((Entity)this, this.bb.expand(10.0, 10.0, 10.0).move(-5.0, -5.0, -5.0));
            if (this.btabreeding$isBaby() && this.btabreeding$getPassiveTarget() == null) {
                for (Entity entity : list) {
                    if (!(entity instanceof IBreeding) || !entity.getClass().isInstance(this) || ((IBreeding)entity).btabreeding$isBaby()) continue;
                    this.btabreeding$setPassiveTarget(entity);
                    break;
                }
            } else if (this.btabreeding$isFed()) {
                this.btabreeding$setPassiveTarget(null);
                for (Entity entity : list) {
                    if (!(entity instanceof IBreeding) || !entity.getClass().isInstance(this) || !this.btabreeding$isFed() || !((IBreeding)entity).btabreeding$isFed() || !this.btabreeding$isBreedable() || !((IBreeding)entity).btabreeding$isBreedable()) continue;
                    this.btabreeding$setPassiveTarget(entity);
                    break;
                }
            } else if (this.btabreeding$isBreedable()) {
                this.btabreeding$setPassiveTarget(null);
                for (Entity entity : list) {
                    if (!(entity instanceof Player) || !this.btabreeding$isFoodItem(((Player)entity).getHeldItem())) continue;
                    this.btabreeding$setPassiveTarget(entity);
                    break;
                }
            }
        }
        super.onLivingUpdate();
        if (this.btabreeding$isFed() && this.tickCount % 4 == 0) {
            double d = this.random.nextGaussian() * 0.02;
            double d1 = this.random.nextGaussian() * 0.02;
            double d2 = this.random.nextGaussian() * 0.02;
            this.world.spawnParticle("heart", this.x + (double)(this.random.nextFloat() * this.bbWidth * 2.0f) - (double)this.bbWidth, this.y + 0.5 + (double)(this.random.nextFloat() * this.bbHeight), this.z + (double)(this.random.nextFloat() * this.bbWidth * 2.0f) - (double)this.bbWidth, d, d1, d2, 0);
        }
    }

    @Overwrite
    public void updateAI() {
        if (this.passiveTarget == null && this.getCurrentTarget() == null) {
            this.pathToEntity = null;
        }
        if (this.passiveTarget != null) {
            this.pathToEntity = this.passiveTarget instanceof Player && this.distanceToSqr(this.passiveTarget) < 9.0 ? null : this.world.getPathToEntity((Entity)this, this.passiveTarget, 20.0f);
        }
        super.updateAI();
    }

    @Inject(method={"addAdditionalSaveData(Lcom/mojang/nbt/tags/CompoundTag;)V"}, at={@At(value="TAIL")})
    public void saveData(CompoundTag tag, CallbackInfo ci) {
        tag.putInt("breeding$breedtime", this.breedingTimer);
        tag.putInt("breeding$fedtime", this.fedTimer);
        tag.putInt("breeding$childtime", this.childhoodTimer);
        tag.putBoolean("breeding$persistent", this.isPersistent);
    }

    @Inject(method={"readAdditionalSaveData(Lcom/mojang/nbt/tags/CompoundTag;)V"}, at={@At(value="TAIL")})
    public void loadData(CompoundTag tag, CallbackInfo ci) {
        this.breedingTimer = tag.getInteger("breeding$breedtime");
        this.fedTimer = tag.getInteger("breeding$fedtime");
        this.childhoodTimer = tag.getInteger("breeding$childtime");
        this.isPersistent = tag.getBoolean("breeding$persistent");
    }

    public boolean canDespawn() {
        return super.canDespawn() && !this.isPersistent;
    }
}

