/*
 * Decompiled with CFR 0.152.
 */
package com.chadate.spellelemental.client.hud;

import com.chadate.spellelemental.client.network.custom.ClientPayloadHandler;
import com.chadate.spellelemental.network.ElementData;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="spellelemental", value={Dist.CLIENT})
public class ElementDebugOverlay {
    @SubscribeEvent
    public static void onRenderGui(RenderGuiEvent.Post event) {
        if (!ClientPayloadHandler.DebugState.enabled) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.level == null) {
            return;
        }
        Entity target = mc.crosshairPickEntity;
        if (target == null) {
            return;
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new ElementData.ElementInspectRequest(target.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        if (ClientPayloadHandler.InspectCache.entityId != target.getId()) {
            return;
        }
        Map<String, Integer> snap = ClientPayloadHandler.InspectCache.data;
        if (snap.isEmpty()) {
            return;
        }
        GuiGraphics gg = event.getGuiGraphics();
        int x = 6;
        int y = 6;
        gg.drawString(mc.font, "[Server Element Debug] EntityId: " + target.getId(), x, y, 0xFFFFFF, false);
        y += 10;
        for (Map.Entry<String, Integer> e : snap.entrySet()) {
            String line = e.getKey() + ": " + String.valueOf(e.getValue());
            gg.drawString(mc.font, line, x, y, 8190976, false);
            y += 10;
        }
    }
}

