/*
 * Decompiled with CFR 0.152.
 */
package com.chadate.spellelemental.element.attachment.data;

import com.chadate.spellelemental.SpellElemental;
import com.chadate.spellelemental.element.attachment.config.UnifiedElementAttachmentConfig;
import com.chadate.spellelemental.element.attachment.data.UnifiedElementAttachmentAssets;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;

public class UnifiedElementAttachmentDataLoader
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new Gson();

    public UnifiedElementAttachmentDataLoader() {
        super(GSON, "element_attachments");
    }

    protected void apply(Map<ResourceLocation, JsonElement> resources, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        UnifiedElementAttachmentAssets.clear();
        SpellElemental.LOGGER.info("\u5f00\u59cb\u52a0\u8f7d\u5143\u7d20\u9644\u7740\u8d44\u4ea7\u914d\u7f6e(\u6700\u5c0f\u5316)...");
        int loadedCount = 0;
        int errorCount = 0;
        for (Map.Entry<ResourceLocation, JsonElement> entry : resources.entrySet()) {
            ResourceLocation id = entry.getKey();
            JsonElement json = entry.getValue();
            try {
                UnifiedElementAttachmentConfig config = (UnifiedElementAttachmentConfig)GSON.fromJson(json, UnifiedElementAttachmentConfig.class);
                if (config == null || config.getElementId() == null || config.getElementId().isBlank()) {
                    SpellElemental.LOGGER.error("\u5143\u7d20\u9644\u7740\u914d\u7f6e\u7f3a\u5c11 element_id: {}", (Object)id);
                    ++errorCount;
                    continue;
                }
                String elementId = config.getElementId();
                if (config.getVisual() != null) {
                    if (config.getVisual().getIcon() != null && !config.getVisual().getIcon().isBlank()) {
                        UnifiedElementAttachmentAssets.setIcon(elementId, config.getVisual().getIcon());
                    }
                    if (config.getVisual().getParticleEffect() != null && !config.getVisual().getParticleEffect().isBlank()) {
                        UnifiedElementAttachmentAssets.setParticleEffect(elementId, config.getVisual().getParticleEffect());
                    }
                }
                if (config.getSchool() != null && !config.getSchool().isBlank()) {
                    UnifiedElementAttachmentAssets.setSchool(elementId, config.getSchool());
                }
                ++loadedCount;
            }
            catch (JsonParseException e) {
                SpellElemental.LOGGER.error("\u89e3\u6790\u5143\u7d20\u9644\u7740\u914d\u7f6e\u5931\u8d25: {} - {}", (Object)id, (Object)e.getMessage());
                ++errorCount;
            }
            catch (Exception e) {
                SpellElemental.LOGGER.error("\u52a0\u8f7d\u5143\u7d20\u9644\u7740\u914d\u7f6e\u65f6\u53d1\u751f\u9519\u8bef: {} - {}", new Object[]{id, e.getMessage(), e});
                ++errorCount;
            }
        }
        SpellElemental.LOGGER.info("\u5143\u7d20\u9644\u7740\u8d44\u4ea7\u52a0\u8f7d\u5b8c\u6210: {} \u6761\u6210\u529f, {} \u6761\u9519\u8bef", (Object)loadedCount, (Object)errorCount);
    }
}

