/*
 * Decompiled with CFR 0.152.
 */
package com.chadate.spellelemental.element.reaction.runtime;

import com.chadate.spellelemental.SpellElemental;
import com.chadate.spellelemental.data.ElementContainerAttachment;
import com.chadate.spellelemental.data.SpellAttachments;
import com.chadate.spellelemental.element.reaction.data.ElementReactionRegistry;
import com.chadate.spellelemental.element.reaction.runtime.AttributeEffectManager;
import com.chadate.spellelemental.event.element.ElementDecaySystem;
import com.chadate.spellelemental.network.ElementData;
import com.chadate.spellelemental.register.ModAttributes;
import com.chadate.spellelemental.util.ReactionInjuryFormula;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class ElementReactionHandler {
    public static void damageTypeReaction(LivingDamageEvent.Pre event) {
        String reactionId;
        String matchedTarget;
        String matchedSource;
        Entity attacker;
        LivingEntity victim;
        block21: {
            boolean intraTargetMode;
            if (ElementReactionRegistry.getDamageReactions().isEmpty()) {
                return;
            }
            if (!ElementReactionRegistry.hasAnyDamageCombos()) {
                return;
            }
            victim = event.getEntity();
            DamageSource dmgSource = event.getSource();
            Entity direct = dmgSource.getDirectEntity();
            attacker = dmgSource.getEntity();
            List<String> targetCandidates = ElementReactionHandler.collectPresentElements(victim);
            List<Object> sourceCandidates = new ArrayList();
            if (attacker instanceof LivingEntity) {
                LivingEntity livingAttacker = (LivingEntity)attacker;
                sourceCandidates = ElementReactionHandler.collectPresentElements(livingAttacker);
            } else if (direct instanceof LivingEntity) {
                LivingEntity livingDirect = (LivingEntity)direct;
                sourceCandidates = ElementReactionHandler.collectPresentElements(livingDirect);
            }
            boolean bl = intraTargetMode = sourceCandidates.isEmpty() && !targetCandidates.isEmpty();
            if (targetCandidates.isEmpty() && sourceCandidates.isEmpty()) {
                return;
            }
            matchedSource = null;
            matchedTarget = null;
            reactionId = null;
            if (!intraTargetMode) {
                for (String string : sourceCandidates) {
                    for (String t : targetCandidates) {
                        String rid = ElementReactionRegistry.findDamageReactionId(string, t);
                        if (rid == null) continue;
                        matchedSource = string;
                        matchedTarget = t;
                        reactionId = rid;
                        break block21;
                    }
                }
            } else {
                String inferredSource = null;
                ElementContainerAttachment elementContainerAttachment = (ElementContainerAttachment)victim.getData(SpellAttachments.ELEMENTS_CONTAINER);
                long bestTime = Long.MIN_VALUE;
                for (String c : targetCandidates) {
                    long t = elementContainerAttachment.getLastApplied(c);
                    if (t <= bestTime) continue;
                    bestTime = t;
                    inferredSource = c;
                }
                if (inferredSource == null) {
                    inferredSource = ElementReactionHandler.inferSourceFromDamage(dmgSource, targetCandidates);
                }
                if (inferredSource != null) {
                    for (String t : targetCandidates) {
                        String rid;
                        if (t.equalsIgnoreCase(inferredSource) || (rid = ElementReactionRegistry.findDamageReactionId(inferredSource, t)) == null) continue;
                        matchedSource = inferredSource;
                        matchedTarget = t;
                        reactionId = rid;
                        break;
                    }
                }
                if (reactionId == null) {
                    for (int i = 0; i < targetCandidates.size(); ++i) {
                        for (int j = 0; j < targetCandidates.size(); ++j) {
                            String t;
                            String s;
                            String rid;
                            if (i == j || (rid = ElementReactionRegistry.findDamageReactionId(s = targetCandidates.get(i), t = targetCandidates.get(j))) == null) continue;
                            matchedSource = s;
                            matchedTarget = t;
                            reactionId = rid;
                            break block21;
                        }
                    }
                }
            }
        }
        if (reactionId == null) {
            return;
        }
        boolean shouldConsume = ElementReactionRegistry.shouldConsumeElements(reactionId);
        int n = ElementReactionHandler.getElementValue(victim, matchedTarget);
        int sourceElementAmount = ElementReactionHandler.getElementValue(victim, matchedSource);
        if (shouldConsume) {
            if (sourceElementAmount > 0) {
                ElementReactionHandler.consumeElementOnEntity(victim, matchedSource, sourceElementAmount);
            }
            if (sourceElementAmount > 0) {
                double ratio = ElementReactionRegistry.getConsumeRatio(matchedSource, matchedTarget);
                int targetConsumeAmount = (int)Math.ceil((double)sourceElementAmount * ratio);
                ElementReactionHandler.consumeElementOnEntity(victim, matchedTarget, targetConsumeAmount);
            }
        }
        int afterVictimTarget = shouldConsume ? ElementReactionHandler.getElementValue(victim, matchedTarget) : n;
        int actualConsumedTarget = shouldConsume ? Math.max(0, n - afterVictimTarget) : 0;
        ElementReactionHandler.applyEffectsForReaction(event, reactionId, matchedSource, matchedTarget, attacker, victim, actualConsumedTarget);
    }

    private static int getElementValue(LivingEntity entity, String elementId) {
        if (entity == null || elementId == null) {
            return -1;
        }
        ElementContainerAttachment container = (ElementContainerAttachment)entity.getData(SpellAttachments.ELEMENTS_CONTAINER);
        return container.getValue(elementId);
    }

    public static void tickTypeReaction(ServerTickEvent.Post event) {
        if (ElementReactionRegistry.getTickReactions().isEmpty()) {
            return;
        }
        if (event == null) {
            return;
        }
        MinecraftServer server = event.getServer();
        try {
            HashSet<Integer> visited = new HashSet<Integer>();
            for (ServerPlayer player : server.getPlayerList().getPlayers()) {
                if (player == null || player.level().isClientSide()) continue;
                Level level = player.level();
                AABB aabb = player.getBoundingBox().inflate(32.0);
                List candidates = level.getEntitiesOfClass(LivingEntity.class, aabb, LivingEntity::isAlive);
                for (LivingEntity entity : candidates) {
                    int id;
                    if (entity == null || !visited.add(id = entity.getId())) continue;
                    ElementReactionHandler.processTickReactionsOnEntity(entity);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void consumeElementOnEntity(LivingEntity entity, String elementId, int amount) {
        if (entity == null || elementId == null || amount <= 0) {
            return;
        }
        ElementContainerAttachment container = (ElementContainerAttachment)entity.getData(SpellAttachments.ELEMENTS_CONTAINER);
        int cur = container.getValue(elementId);
        if (cur <= 0) {
            return;
        }
        int next = cur - amount;
        if (next <= 0) {
            container.remove(elementId);
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new ElementData(entity.getId(), elementId, 0), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            container.setValue(elementId, next);
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new ElementData(entity.getId(), elementId, next), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private static List<String> collectPresentElements(LivingEntity entity) {
        ArrayList<String> out = new ArrayList<String>();
        if (entity == null) {
            return out;
        }
        ElementContainerAttachment container = (ElementContainerAttachment)entity.getData(SpellAttachments.ELEMENTS_CONTAINER);
        Map<String, Integer> snapshot = container.snapshot();
        for (Map.Entry<String, Integer> en : snapshot.entrySet()) {
            if (en.getValue() == null || en.getValue() <= 0) continue;
            out.add(en.getKey().toLowerCase());
        }
        return out;
    }

    private static String inferSourceFromDamage(DamageSource source, List<String> candidatesLowercase) {
        if (source == null) {
            return null;
        }
        try {
            String id = source.getMsgId();
            if (id.isBlank()) {
                return null;
            }
            String low = id.toLowerCase();
            for (String c : candidatesLowercase) {
                if (!low.contains(c.toLowerCase())) continue;
                return c;
            }
            return null;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static void applyEffectsForReaction(LivingDamageEvent.Pre event, String reactionId, String matchedSource, String matchedTarget, Entity attacker, LivingEntity victim, int elementsAmount) {
        if (reactionId == null) {
            return;
        }
        List<ElementReactionRegistry.ReactionEffect> effects = ElementReactionRegistry.getDirectionalEffects(matchedSource, matchedTarget);
        if (effects.isEmpty()) {
            effects = ElementReactionRegistry.getEffects(reactionId);
        }
        if (effects.isEmpty()) {
            return;
        }
        float damage = event.getOriginalDamage();
        for (ElementReactionRegistry.ReactionEffect eff : effects) {
            if (eff == null || eff.type.isEmpty()) continue;
            switch (eff.type) {
                case "damage_amplify": {
                    damage = ElementReactionHandler.applyDamageAmplify(damage, eff, attacker);
                    break;
                }
                case "aoe": {
                    ElementReactionHandler.applyAoeEffect(event, damage, eff, attacker, victim, elementsAmount);
                    break;
                }
                case "attachment": {
                    ElementReactionHandler.applyElementAttachmentEffect(attacker, victim, eff);
                    break;
                }
            }
        }
        if (damage != event.getOriginalDamage()) {
            event.setNewDamage(damage);
        }
        ElementReactionHandler.applyAttributeEffects(reactionId, matchedSource, matchedTarget, victim);
    }

    private static void applyElementAttachmentEffect(Entity attacker, LivingEntity victim, ElementReactionRegistry.ReactionEffect eff) {
        float chance;
        if (victim == null || victim.level().isClientSide()) {
            return;
        }
        if (eff == null || eff.elementId == null || eff.elementId.isBlank()) {
            return;
        }
        float f = chance = eff.elementChance <= 0.0f ? 1.0f : eff.elementChance;
        if (victim.getRandom().nextFloat() > chance) {
            return;
        }
        String elementKeyLower = eff.elementId.toLowerCase();
        int amount = Math.max(0, eff.elementAmount);
        if (amount == 0) {
            return;
        }
        ElementContainerAttachment container = (ElementContainerAttachment)victim.getData(SpellAttachments.ELEMENTS_CONTAINER);
        container.setValue(elementKeyLower, amount);
        long gameTime = victim.level().getGameTime();
        int attackerId = attacker != null ? attacker.getId() : -1;
        container.markAppliedWithAttacker(elementKeyLower, gameTime, attackerId);
        ElementDecaySystem.track(victim);
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new ElementData(victim.getId(), elementKeyLower, amount), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static void applyAttributeEffects(String reactionId, String matchedSource, String matchedTarget, LivingEntity target) {
        boolean usingDirectional;
        if (reactionId == null || target == null || target.level().isClientSide()) {
            return;
        }
        List<ElementReactionRegistry.AttributeEffect> attributeEffects = ElementReactionRegistry.getDirectionalAttributeEffects(matchedSource, matchedTarget);
        boolean bl = usingDirectional = !attributeEffects.isEmpty();
        if (attributeEffects.isEmpty()) {
            attributeEffects = ElementReactionRegistry.getAttributeEffects(reactionId);
        }
        if (attributeEffects.isEmpty()) {
            return;
        }
        for (ElementReactionRegistry.AttributeEffect effect : attributeEffects) {
            ResourceLocation attrLocation;
            if (effect == null || effect.attributeId().isEmpty()) continue;
            try {
                attrLocation = ResourceLocation.parse((String)effect.attributeId());
            }
            catch (Exception e) {
                continue;
            }
            Registry attributeRegistry = target.level().registryAccess().registryOrThrow(Registries.ATTRIBUTE);
            Holder attributeHolder = attributeRegistry.getHolder(attrLocation).orElse(null);
            if (attributeHolder == null) continue;
            AttributeModifier.Operation operation = switch (effect.operation().toLowerCase()) {
                case "multiply_base" -> AttributeModifier.Operation.ADD_MULTIPLIED_BASE;
                case "multiply_total" -> AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL;
                default -> AttributeModifier.Operation.ADD_VALUE;
            };
            ResourceLocation modifierId = ResourceLocation.fromNamespaceAndPath((String)"spellelemental", (String)("reaction_" + reactionId + "_" + effect.attributeId().replace(":", "_")));
            AttributeModifier modifier = new AttributeModifier(modifierId, effect.value(), operation);
            AttributeInstance instance = target.getAttribute(attributeHolder);
            if (instance == null) continue;
            double beforeValue = instance.getValue();
            instance.removeModifier(modifierId);
            instance.addTransientModifier(modifier);
            if (effect.duration() <= 0) continue;
            AttributeEffectManager.registerTimedEffect(target, (Holder<Attribute>)attributeHolder, modifierId, effect.duration());
        }
    }

    private static float applyDamageAmplify(float baseDamage, ElementReactionRegistry.ReactionEffect eff, Entity attackerEntity) {
        float out = baseDamage;
        if ("QuickenReactionDamage".equals(eff.formula)) {
            float astral = 0.0f;
            if (attackerEntity instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)attackerEntity;
                astral = (float)attacker.getAttributeValue(ModAttributes.ASTRAL_BLESSING);
            }
            return ReactionInjuryFormula.QuickenReactionDamage(baseDamage, eff.multiplier, astral);
        }
        if (eff.multiplier != 0.0f) {
            out *= eff.multiplier;
        }
        float factor = 1.0f;
        if (eff.formula != null && !eff.formula.isEmpty()) {
            float astral = 0.0f;
            if (attackerEntity instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)attackerEntity;
                astral = (float)attacker.getAttributeValue(ModAttributes.ASTRAL_BLESSING);
            }
            factor *= ElementReactionHandler.evaluateFormula(eff.formula, astral);
        }
        return out * factor;
    }

    private static void applyAoeEffect(LivingDamageEvent.Pre event, float baseDamage, ElementReactionRegistry.ReactionEffect eff, Entity attackerEntity, LivingEntity victim, int elementsAmount) {
        LivingEntity le;
        float finalDamage;
        if (victim == null || victim.level().isClientSide()) {
            return;
        }
        float radius = eff.radius;
        if (radius <= 0.0f) {
            return;
        }
        if ("CalculateOverloadDamage".equals(eff.formula)) {
            float astral = 0.0f;
            if (attackerEntity instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)attackerEntity;
                astral = (float)attacker.getAttributeValue(ModAttributes.ASTRAL_BLESSING);
            }
            int effectiveAmount = elementsAmount == 0 ? 10 : elementsAmount;
            finalDamage = Math.max(0.0f, ReactionInjuryFormula.CalculateOverloadDamage(effectiveAmount, eff.multiplier, astral));
        } else {
            float out = baseDamage;
            if (eff.multiplier != 0.0f) {
                out *= eff.multiplier;
            }
            float factor = 1.0f;
            if (eff.formula != null && !eff.formula.isEmpty()) {
                float astral = 0.0f;
                if (attackerEntity instanceof LivingEntity) {
                    LivingEntity attacker = (LivingEntity)attackerEntity;
                    astral = (float)attacker.getAttributeValue(ModAttributes.ASTRAL_BLESSING);
                }
                factor *= ElementReactionHandler.evaluateFormula(eff.formula, astral);
            }
            finalDamage = Math.max(0.0f, out * factor);
        }
        if (finalDamage <= 0.0f) {
            return;
        }
        DamageSource src = event.getSource();
        if (eff.damageType != null && !eff.damageType.isEmpty()) {
            try {
                ResourceKey key;
                ResourceLocation rl = ResourceLocation.tryParse((String)eff.damageType);
                if (rl == null) {
                    throw new IllegalArgumentException("Invalid damage_type RL: " + eff.damageType);
                }
                Registry reg = victim.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE);
                Holder holder = reg.getHolder(key = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)rl)).orElse(null);
                if (holder != null) {
                    Entity direct = event.getSource().getDirectEntity();
                    Entity causing = attackerEntity != null ? attackerEntity : event.getSource().getEntity();
                    src = new DamageSource(holder, direct, causing);
                }
            }
            catch (Throwable rl) {
                // empty catch block
            }
        }
        AABB aabb = victim.getBoundingBox().inflate((double)radius);
        DamageSource srcFinal = src;
        LivingEntity attackerLiving = attackerEntity instanceof LivingEntity ? (le = (LivingEntity)attackerEntity) : null;
        for (LivingEntity ent : victim.level().getEntitiesOfClass(LivingEntity.class, aabb, LivingEntity::isAlive)) {
            if (!eff.damageVictim && ent == victim || !eff.damageAttacker && attackerLiving != null && ent == attackerLiving || ent.invulnerableTime > 0) continue;
            ent.hurt(srcFinal, finalDamage);
        }
    }

    private static void processTickReactionsOnEntity(LivingEntity entity) {
        if (entity == null || entity.level().isClientSide()) {
            return;
        }
        Set<String> allTick = ElementReactionRegistry.getTickReactions();
        if (allTick.isEmpty()) {
            return;
        }
        ElementContainerAttachment container = (ElementContainerAttachment)entity.getData(SpellAttachments.ELEMENTS_CONTAINER);
        long time = entity.level().getGameTime();
        for (String rid : allTick) {
            List<ElementReactionRegistry.TickRule> rules = ElementReactionRegistry.getTickRules(rid);
            if (rules.isEmpty()) continue;
            for (ElementReactionRegistry.TickRule rule : rules) {
                if (rule.interval() > 1 && time % (long)rule.interval() != 0L) continue;
                boolean meetsRequirements = true;
                for (Map.Entry<String, Integer> req : rule.requirements().entrySet()) {
                    int cur;
                    String elem = req.getKey();
                    int need = Math.max(0, req.getValue());
                    if (need == 0 || (cur = container.getValue(elem)) >= need) continue;
                    meetsRequirements = false;
                    break;
                }
                if (!meetsRequirements) continue;
                int totalConsumed = 0;
                for (Map.Entry<String, Integer> con : rule.consume().entrySet()) {
                    String elem = con.getKey();
                    int want = Math.max(0, con.getValue());
                    int before = container.getValue(elem);
                    if (before <= 0 || want == 0) continue;
                    int real = Math.min(before, want);
                    ElementReactionHandler.consumeElementOnEntity(entity, elem, real);
                    totalConsumed += real;
                }
                if (rule.effects().isEmpty()) continue;
                for (ElementReactionRegistry.ReactionEffect eff : rule.effects()) {
                    if (eff == null || eff.type.isEmpty()) continue;
                    switch (eff.type) {
                        case "aoe": {
                            ElementReactionHandler.applyAoeEffectFromTick(entity, eff, totalConsumed);
                            break;
                        }
                        case "extra": {
                            ElementReactionHandler.applyExtraDamageFromTick(entity, eff, totalConsumed);
                            break;
                        }
                        case "attachment": {
                            ElementReactionHandler.applyAttachmentFromTick(entity, eff);
                            break;
                        }
                        case "potion": {
                            ElementReactionHandler.applyPotionEffectFromTick(entity, eff);
                        }
                    }
                }
            }
        }
    }

    private static void applyAoeEffectFromTick(LivingEntity center, ElementReactionRegistry.ReactionEffect eff, int elementsAmount) {
        float finalDamage;
        if (center == null || center.level().isClientSide()) {
            return;
        }
        float radius = eff.radius;
        if (radius <= 0.0f) {
            return;
        }
        float astral = 0.0f;
        if (center instanceof LivingEntity) {
            LivingEntity attacker = center;
            astral = (float)attacker.getAttributeValue(ModAttributes.ASTRAL_BLESSING);
        }
        if (eff.formula != null && !eff.formula.isEmpty()) {
            if ("CalculateOverloadDamage".equals(eff.formula)) {
                int effectiveAmount = elementsAmount == 0 ? 10 : elementsAmount;
                finalDamage = Math.max(0.0f, ReactionInjuryFormula.CalculateOverloadDamage(effectiveAmount, eff.multiplier, astral));
            } else {
                float out = elementsAmount;
                if (eff.multiplier != 0.0f) {
                    out *= eff.multiplier;
                }
                float factor = ElementReactionHandler.evaluateFormula(eff.formula, astral);
                finalDamage = Math.max(0.0f, out * factor);
            }
        } else {
            float out = elementsAmount;
            if (eff.multiplier != 0.0f) {
                out *= eff.multiplier;
            }
            finalDamage = Math.max(0.0f, out);
        }
        if (finalDamage <= 0.0f) {
            return;
        }
        DamageSource src = null;
        try {
            ResourceKey key;
            Registry reg;
            Holder holder;
            ResourceLocation rl;
            if (eff.damageType != null && !eff.damageType.isEmpty() && (rl = ResourceLocation.tryParse((String)eff.damageType)) != null && (holder = (Holder)(reg = center.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE)).getHolder(key = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)rl)).orElse(null)) != null) {
                src = new DamageSource(holder, (Entity)center, (Entity)center);
            }
        }
        catch (Throwable rl) {
            // empty catch block
        }
        if (src == null) {
            return;
        }
        AABB aabb = center.getBoundingBox().inflate((double)radius);
        DamageSource srcFinal = src;
        for (LivingEntity ent : center.level().getEntitiesOfClass(LivingEntity.class, aabb, LivingEntity::isAlive)) {
            if (!eff.damageAttacker && ent == center || ent.invulnerableTime > 0) continue;
            ent.hurt(srcFinal, finalDamage);
        }
    }

    private static void applyExtraDamageFromTick(LivingEntity center, ElementReactionRegistry.ReactionEffect eff, int elementsAmount) {
        float finalDamage;
        if (center == null || center.level().isClientSide()) {
            return;
        }
        float astral = 0.0f;
        ElementContainerAttachment container = (ElementContainerAttachment)center.getData(SpellAttachments.ELEMENTS_CONTAINER);
        LivingEntity attacker = null;
        for (String elementId : container.snapshot().keySet()) {
            LivingEntity livingAttacker;
            Entity entity;
            int attackerId = container.getLastAttackerId(elementId);
            if (attackerId == -1 || !((entity = center.level().getEntity(attackerId)) instanceof LivingEntity)) continue;
            attacker = livingAttacker = (LivingEntity)entity;
            break;
        }
        astral = attacker != null ? (float)attacker.getAttributeValue(ModAttributes.ASTRAL_BLESSING) : (float)center.getAttributeValue(ModAttributes.ASTRAL_BLESSING);
        if (eff.formula != null && !eff.formula.isEmpty()) {
            if ("CalculateOverloadDamage".equals(eff.formula)) {
                int effectiveAmount = elementsAmount == 0 ? 10 : elementsAmount;
                finalDamage = Math.max(0.0f, ReactionInjuryFormula.CalculateOverloadDamage(effectiveAmount, eff.multiplier, astral));
            } else {
                float out = elementsAmount;
                if (eff.multiplier != 0.0f) {
                    out *= eff.multiplier;
                }
                float factor = ElementReactionHandler.evaluateFormula(eff.formula, astral);
                finalDamage = Math.max(0.0f, out * factor);
            }
        } else {
            float out = elementsAmount;
            if (eff.multiplier != 0.0f) {
                out *= eff.multiplier;
            }
            finalDamage = Math.max(0.0f, out);
        }
        if (finalDamage <= 0.0f) {
            return;
        }
        DamageSource src = null;
        try {
            ResourceKey key;
            Registry reg;
            Holder holder;
            ResourceLocation rl;
            if (eff.damageType != null && !eff.damageType.isEmpty() && (rl = ResourceLocation.tryParse((String)eff.damageType)) != null && (holder = (Holder)(reg = center.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE)).getHolder(key = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)rl)).orElse(null)) != null) {
                src = new DamageSource(holder, (Entity)center, (Entity)center);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (src == null) {
            return;
        }
        center.hurt(src, finalDamage);
    }

    private static void applyAttachmentFromTick(LivingEntity entity, ElementReactionRegistry.ReactionEffect eff) {
        float chance;
        if (entity == null || entity.level().isClientSide()) {
            return;
        }
        if (eff == null) {
            return;
        }
        String element = eff.elementId;
        int amount = Math.max(0, eff.elementAmount);
        float f = chance = eff.elementChance <= 0.0f ? 1.0f : eff.elementChance;
        if (element == null || element.isEmpty() || amount == 0) {
            return;
        }
        try {
            if (entity.getRandom().nextFloat() > chance) {
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ElementContainerAttachment container = (ElementContainerAttachment)entity.getData(SpellAttachments.ELEMENTS_CONTAINER);
        String key = element.toLowerCase();
        container.setValue(key, amount);
        long gameTime = entity.level().getGameTime();
        container.markAppliedWithAttacker(key, gameTime, -1);
        ElementDecaySystem.track(entity);
        try {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new ElementData(entity.getId(), key, amount), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void applyPotionEffectFromTick(LivingEntity entity, ElementReactionRegistry.ReactionEffect eff) {
        if (entity == null || entity.level().isClientSide()) {
            return;
        }
        if (eff.potionId == null || eff.potionId.isEmpty()) {
            return;
        }
        float chance = Math.max(0.0f, Math.min(1.0f, eff.potionChance));
        try {
            if (entity.getRandom().nextFloat() > chance) {
                return;
            }
        }
        catch (Throwable ignored) {
            return;
        }
        try {
            ResourceLocation potionEffectId = ResourceLocation.parse((String)eff.potionId);
            MobEffect potionEffect = (MobEffect)BuiltInRegistries.MOB_EFFECT.get(potionEffectId);
            if (potionEffect == null) {
                SpellElemental.LOGGER.warn("\u672a\u627e\u5230\u836f\u6c34\u6548\u679c: {}", (Object)eff.potionId);
                return;
            }
            int duration = Math.max(1, eff.potionDuration);
            int amplifier = Math.max(0, eff.potionLevel);
            MobEffectInstance effectInstance = new MobEffectInstance(Holder.direct((Object)potionEffect), duration, amplifier, false, true, true);
            entity.addEffect(effectInstance);
        }
        catch (Exception e) {
            SpellElemental.LOGGER.error("\u5e94\u7528\u836f\u6c34\u6548\u679c\u65f6\u51fa\u9519: {}", (Object)eff.potionId, (Object)e);
        }
    }

    private static float evaluateFormula(String formula, float astral) {
        if ("AmplifiedReactionBonus".equals(formula)) {
            return ReactionInjuryFormula.AmplifiedReactionBonus(astral);
        }
        return 1.0f;
    }
}

