/*
 * Decompiled with CFR 0.152.
 */
package com.chadate.spellelemental.event;

import com.chadate.spellelemental.config.ServerConfig;
import com.chadate.spellelemental.data.ElementContainerAttachment;
import com.chadate.spellelemental.data.SpellAttachments;
import com.chadate.spellelemental.element.attachment.attack.SpellIcdTracker;
import com.chadate.spellelemental.event.element.ElementDecaySystem;
import com.chadate.spellelemental.network.ElementData;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber
public class SwordOilAttackHandler {
    private static final int MIN_ELEMENT_CONSUMPTION = 20;
    private static final int MAX_ELEMENT_CONSUMPTION = 200;
    private static final Map<Integer, Float> mainAttackDamageMap = new ConcurrentHashMap<Integer, Float>();
    private static final Map<Integer, Integer> sweepElementConsumptionMap = new ConcurrentHashMap<Integer, Integer>();
    private static final Map<Integer, Integer> mainTargetMap = new ConcurrentHashMap<Integer, Integer>();

    @SubscribeEvent
    public static void onPlayerAttack(AttackEntityEvent event) {
        Player player = event.getEntity();
        ItemStack weapon = player.getMainHandItem();
        if (player.level().isClientSide()) {
            return;
        }
        if (!(weapon.getItem() instanceof SwordItem)) {
            return;
        }
        Entity entity = event.getTarget();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = (LivingEntity)entity;
        CompoundTag customData = ((CustomData)weapon.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        CompoundTag elementData = customData.getCompound("ElementAttachment");
        if (!elementData.contains("element") || !elementData.contains("amount")) {
            return;
        }
        String elementType = elementData.getString("element");
        int currentAmount = elementData.getInt("amount");
        float baseDamage = (float)player.getAttributeValue(Attributes.ATTACK_DAMAGE);
        mainAttackDamageMap.put(player.getId(), Float.valueOf(baseDamage));
        sweepElementConsumptionMap.put(player.getId(), 0);
        mainTargetMap.put(player.getId(), target.getId());
        float chargeRatio = player.getAttackStrengthScale(0.5f);
        SwordOilAttackHandler.applyElementToTarget(target, elementType, player.getId(), chargeRatio);
        int mainElementConsumption = Math.round(20.0f + 180.0f * chargeRatio);
        mainElementConsumption = Math.max(20, Math.min(200, mainElementConsumption));
        SwordOilAttackHandler.scheduleElementConsumption(player, weapon, currentAmount, mainElementConsumption);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onLivingDamage(LivingDamageEvent.Pre event) {
        if (event.getEntity().level().isClientSide()) {
            return;
        }
        Entity entity = event.getSource().getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player attacker = (Player)entity;
        ItemStack weapon = attacker.getMainHandItem();
        if (!(weapon.getItem() instanceof SwordItem)) {
            return;
        }
        CompoundTag customData = ((CustomData)weapon.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        CompoundTag elementData = customData.getCompound("ElementAttachment");
        if (!elementData.contains("element") || !elementData.contains("amount")) {
            return;
        }
        String elementType = elementData.getString("element");
        Integer mainTargetId = mainTargetMap.get(attacker.getId());
        if (mainTargetId != null && mainTargetId.equals(event.getEntity().getId())) {
            return;
        }
        float chargeRatio = attacker.getAttackStrengthScale(0.5f);
        float currentDamage = event.getNewDamage();
        Float mainDamage = mainAttackDamageMap.get(attacker.getId());
        float damageRatio = 1.0f;
        if (mainDamage != null && mainDamage.floatValue() > 0.0f) {
            damageRatio = Math.min(1.0f, currentDamage / mainDamage.floatValue());
            damageRatio = Math.max(0.1f, damageRatio);
        }
        int consumedAmount = SwordOilAttackHandler.applyElementToTargetWithRatio(event.getEntity(), elementType, attacker.getId(), chargeRatio, damageRatio);
        sweepElementConsumptionMap.merge(attacker.getId(), consumedAmount, Integer::sum);
    }

    private static int applyElementToTargetWithRatio(LivingEntity target, String elementType, int attackerId, float chargeRatio, float damageRatio) {
        ServerLevel serverLevel;
        Entity entity;
        LivingEntity attacker = null;
        Level level = target.level();
        if (level instanceof ServerLevel && (entity = (serverLevel = (ServerLevel)level).getEntity(attackerId)) instanceof LivingEntity) {
            LivingEntity livingAttacker;
            attacker = livingAttacker = (LivingEntity)entity;
        }
        ResourceLocation swordOilSweepSpellId = ResourceLocation.fromNamespaceAndPath((String)"spellelemental", (String)("sword_oil_sweep_" + elementType.toLowerCase()));
        int step = ServerConfig.getIcdHitStep();
        int timeTicks = ServerConfig.getIcdTimeTicks();
        long currentTick = target.level().getGameTime();
        boolean allowAttachment = SpellIcdTracker.allowAndRecord((Entity)attacker, (Entity)target, swordOilSweepSpellId, currentTick, step, timeTicks);
        if (!allowAttachment) {
            return 0;
        }
        int baseElementAmount = Math.round(20.0f + 180.0f * chargeRatio);
        baseElementAmount = Math.max(20, Math.min(200, baseElementAmount));
        int elementAmount = Math.round((float)baseElementAmount * damageRatio);
        int minAmount = Math.max(2, baseElementAmount / 10);
        elementAmount = Math.max(minAmount, elementAmount);
        ElementContainerAttachment container = (ElementContainerAttachment)target.getData(SpellAttachments.ELEMENTS_CONTAINER);
        container.setValue(elementType.toLowerCase(), elementAmount);
        long gameTime = target.level().getGameTime();
        container.markAppliedWithAttacker(elementType.toLowerCase(), gameTime, attackerId);
        ElementDecaySystem.track(target);
        Level level2 = target.level();
        if (level2 instanceof ServerLevel) {
            ServerLevel serverLevel2 = (ServerLevel)level2;
            for (ServerPlayer player : serverLevel2.players()) {
                double distance = player.distanceTo((Entity)target);
                if (!(distance <= 64.0)) continue;
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ElementData(target.getId(), elementType.toLowerCase(), elementAmount), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        return elementAmount;
    }

    private static void applyElementToTarget(LivingEntity target, String elementType, int attackerId, float chargeRatio) {
        ServerLevel serverLevel;
        Entity entity;
        LivingEntity attacker = null;
        Level level = target.level();
        if (level instanceof ServerLevel && (entity = (serverLevel = (ServerLevel)level).getEntity(attackerId)) instanceof LivingEntity) {
            LivingEntity livingAttacker;
            attacker = livingAttacker = (LivingEntity)entity;
        }
        ResourceLocation swordOilSpellId = ResourceLocation.fromNamespaceAndPath((String)"spellelemental", (String)("sword_oil_" + elementType.toLowerCase()));
        int step = ServerConfig.getIcdHitStep();
        int timeTicks = ServerConfig.getIcdTimeTicks();
        long currentTick = target.level().getGameTime();
        boolean allowAttachment = SpellIcdTracker.allowAndRecord((Entity)attacker, (Entity)target, swordOilSpellId, currentTick, step, timeTicks);
        if (!allowAttachment) {
            return;
        }
        int elementAmount = Math.round(20.0f + 180.0f * chargeRatio);
        elementAmount = Math.max(20, Math.min(200, elementAmount));
        ElementContainerAttachment container = (ElementContainerAttachment)target.getData(SpellAttachments.ELEMENTS_CONTAINER);
        container.setValue(elementType.toLowerCase(), elementAmount);
        long gameTime = target.level().getGameTime();
        container.markAppliedWithAttacker(elementType.toLowerCase(), gameTime, attackerId);
        ElementDecaySystem.track(target);
        Level level2 = target.level();
        if (level2 instanceof ServerLevel) {
            ServerLevel serverLevel2 = (ServerLevel)level2;
            for (ServerPlayer player : serverLevel2.players()) {
                double distance = player.distanceTo((Entity)target);
                if (!(distance <= 64.0)) continue;
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ElementData(target.getId(), elementType.toLowerCase(), elementAmount), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    private static void scheduleElementConsumption(Player player, ItemStack weapon, int currentAmount, int mainElementConsumption) {
        Level level = player.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.getServer().execute(() -> {
                Integer sweepConsumption = sweepElementConsumptionMap.remove(player.getId());
                if (sweepConsumption == null) {
                    sweepConsumption = 0;
                }
                int totalConsumption = mainElementConsumption + sweepConsumption;
                SwordOilAttackHandler.updateWeaponElementAmount(weapon, currentAmount, totalConsumption);
                mainAttackDamageMap.remove(player.getId());
                mainTargetMap.remove(player.getId());
            });
        }
    }

    private static void updateWeaponElementAmount(ItemStack weapon, int currentAmount, int totalConsumption) {
        CompoundTag customData = ((CustomData)weapon.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        CompoundTag elementData = customData.getCompound("ElementAttachment");
        int newAmount = Math.max(0, currentAmount - totalConsumption);
        if (newAmount == 0) {
            customData.remove("ElementAttachment");
        } else {
            elementData.putInt("amount", newAmount);
            customData.put("ElementAttachment", (Tag)elementData);
        }
        weapon.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)customData));
    }
}

