/*
 * Decompiled with CFR 0.152.
 */
package com.chadate.spellelemental.util;

import com.chadate.spellelemental.register.ModAttributes;
import net.minecraft.core.Holder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.neoforged.neoforge.common.Tags;

public class PhysicalDamageCalculator {
    public static PhysicalDamageResult calculateDamage(float originalDamage, LivingEntity attacker, LivingEntity target, DamageSource source) {
        if (!PhysicalDamageCalculator.isPhysicalDamage(source)) {
            return new PhysicalDamageResult(originalDamage, 1.0f, 1.0f, false);
        }
        float damageBoost = PhysicalDamageCalculator.getAttributeValue(attacker, ModAttributes.PHYSICAL_DAMAGE_BOOST);
        float resistance = PhysicalDamageCalculator.getAttributeValue(target, ModAttributes.PHYSICAL_DAMAGE_RESIST);
        float resistanceMultiplier = PhysicalDamageCalculator.calculateResistanceMultiplier(resistance);
        float finalDamage = originalDamage * damageBoost * resistanceMultiplier;
        return new PhysicalDamageResult(finalDamage, damageBoost, resistanceMultiplier, true);
    }

    public static float calculateResistanceMultiplier(float resistance) {
        float delta = resistance - 1.0f;
        if (delta < 0.0f) {
            return Math.min(2.0f, 1.0f - delta * 0.5f);
        }
        if (delta < 0.75f) {
            return Math.max(0.1f, 1.0f - delta);
        }
        return Math.max(0.05f, 1.0f / (1.0f + 4.0f * delta));
    }

    private static float getAttributeValue(LivingEntity entity, Holder<Attribute> attribute) {
        if (entity == null) {
            return 1.0f;
        }
        AttributeInstance instance = entity.getAttribute(attribute);
        return instance != null ? (float)instance.getValue() : 1.0f;
    }

    private static boolean isPhysicalDamage(DamageSource source) {
        return source.is(Tags.DamageTypes.IS_PHYSICAL);
    }

    public record PhysicalDamageResult(float finalDamage, float damageMultiplier, float resistanceMultiplier, boolean wasModified) {
    }
}

