/*
 * Decompiled with CFR 0.152.
 */
package com.chadate.spellelemental.client.render;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderGuiEvent;

@EventBusSubscriber(value={Dist.CLIENT}, modid="spellelemental")
public class ActionBarMessageRenderer {
    private static Component currentMessage = null;
    private static long messageStartTime = 0L;
    private static final long MESSAGE_DURATION = 3000L;

    public static void setMessage(Component message) {
        currentMessage = message;
        messageStartTime = System.currentTimeMillis();
    }

    public static void clearMessage() {
        currentMessage = null;
        messageStartTime = 0L;
    }

    @SubscribeEvent
    public static void onRenderGui(RenderGuiEvent.Post event) {
        if (currentMessage == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - messageStartTime > 3000L) {
            ActionBarMessageRenderer.clearMessage();
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.player == null || minecraft.screen != null) {
            return;
        }
        GuiGraphics guiGraphics = event.getGuiGraphics();
        int screenWidth = minecraft.getWindow().getGuiScaledWidth();
        int screenHeight = minecraft.getWindow().getGuiScaledHeight();
        int textWidth = minecraft.font.width((FormattedText)currentMessage);
        int x = (screenWidth - textWidth) / 2;
        int y = screenHeight - 69;
        float alpha = ActionBarMessageRenderer.calculateAlpha(currentTime - messageStartTime);
        int color = (int)(255.0f * alpha) << 24 | 0xFFFFFF;
        guiGraphics.drawString(minecraft.font, currentMessage, x, y, color);
    }

    private static float calculateAlpha(long elapsedTime) {
        float fadeInTime = 300.0f;
        float fadeOutTime = 500.0f;
        float totalTime = 3000.0f;
        if ((float)elapsedTime < fadeInTime) {
            return (float)elapsedTime / fadeInTime;
        }
        if ((float)elapsedTime > totalTime - fadeOutTime) {
            return (totalTime - (float)elapsedTime) / fadeOutTime;
        }
        return 1.0f;
    }
}

