/*
 * Decompiled with CFR 0.152.
 */
package com.chadate.spellelemental.config;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ServerConfig {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final ModConfigSpec.IntValue ELEMENT_ATTACHMENT_DEFAULT;
    public static final ModConfigSpec.IntValue ELEMENT_ICD_HIT_STEP;
    public static final ModConfigSpec.IntValue ELEMENT_ICD_TIME_TICKS;
    public static final ModConfigSpec.ConfigValue<String> ELEMENT_ATTACHMENT_OVERRIDES_TEXT;
    public static final ModConfigSpec.ConfigValue<String> SPELL_ELEMENT_OVERRIDES_TEXT;
    public static final ModConfigSpec.IntValue WEAPON_MAX_ELEMENT_AMOUNT;
    public static final ModConfigSpec SPEC;
    private static volatile Map<ResourceLocation, Integer> overridesCache;
    private static volatile Map<ResourceLocation, String> spellElementOverridesCache;

    public static int getSpellAttachmentAmount(ResourceLocation spellId) {
        Map<ResourceLocation, Integer> map = ServerConfig.getOverridesCache();
        Integer v = map.get(spellId);
        return v != null ? v : (Integer)ELEMENT_ATTACHMENT_DEFAULT.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<ResourceLocation, Integer> getOverridesCache() {
        Map<ResourceLocation, Integer> local = overridesCache;
        if (local != null) {
            return local;
        }
        Class<ServerConfig> clazz = ServerConfig.class;
        synchronized (ServerConfig.class) {
            if (overridesCache == null) {
                overridesCache = ServerConfig.parseOverrides((String)ELEMENT_ATTACHMENT_OVERRIDES_TEXT.get());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return overridesCache;
        }
    }

    public static void invalidateCache() {
        overridesCache = null;
        spellElementOverridesCache = null;
    }

    public static int getIcdHitStep() {
        return (Integer)ELEMENT_ICD_HIT_STEP.get();
    }

    public static int getIcdTimeTicks() {
        return (Integer)ELEMENT_ICD_TIME_TICKS.get();
    }

    public static int getWeaponMaxElementAmount() {
        return (Integer)WEAPON_MAX_ELEMENT_AMOUNT.get();
    }

    private static Map<ResourceLocation, Integer> parseOverrides(String text) {
        String[] parts;
        HashMap<ResourceLocation, Integer> map = new HashMap<ResourceLocation, Integer>();
        if (text == null || text.isBlank()) {
            return map;
        }
        String normalized = text.replace('\n', ';').replace(',', ';');
        for (String raw : parts = normalized.split(";")) {
            int idx;
            String s;
            if (raw == null || (s = raw.trim()).isEmpty() || (idx = s.indexOf(61)) <= 0 || idx >= s.length() - 1) continue;
            String key = s.substring(0, idx).trim();
            String val = s.substring(idx + 1).trim();
            try {
                ResourceLocation id;
                int amount = Integer.parseInt(val);
                if (amount < 0 || (id = ResourceLocation.tryParse((String)key)) == null) continue;
                map.put(id, amount);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return map;
    }

    public static String getSpellElementOverride(ResourceLocation spellId) {
        Map<ResourceLocation, String> map = ServerConfig.getSpellElementOverridesCache();
        return map.get(spellId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<ResourceLocation, String> getSpellElementOverridesCache() {
        Map<ResourceLocation, String> local = spellElementOverridesCache;
        if (local != null) {
            return local;
        }
        Class<ServerConfig> clazz = ServerConfig.class;
        synchronized (ServerConfig.class) {
            if (spellElementOverridesCache == null) {
                spellElementOverridesCache = ServerConfig.parseSpellElementOverrides((String)SPELL_ELEMENT_OVERRIDES_TEXT.get());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return spellElementOverridesCache;
        }
    }

    private static Map<ResourceLocation, String> parseSpellElementOverrides(String text) {
        String[] parts;
        HashMap<ResourceLocation, String> map = new HashMap<ResourceLocation, String>();
        if (text == null || text.isBlank()) {
            return map;
        }
        String normalized = text.replace('\n', ';').replace(',', ';');
        for (String raw : parts = normalized.split(";")) {
            ResourceLocation id;
            int idx;
            String s;
            if (raw == null || (s = raw.trim()).isEmpty() || (idx = s.indexOf(61)) <= 0 || idx >= s.length() - 1) continue;
            String key = s.substring(0, idx).trim();
            String val = s.substring(idx + 1).trim();
            if (val.isEmpty() || (id = ResourceLocation.tryParse((String)key)) == null) continue;
            map.put(id, val.toLowerCase());
        }
        return map;
    }

    static {
        BUILDER.push("element_attachment");
        ELEMENT_ATTACHMENT_DEFAULT = BUILDER.comment("\u6ca1\u6709\u663e\u5f0f\u8986\u76d6\u7684\u6cd5\u672f\u7684\u9ed8\u8ba4\u5143\u7d20\u9644\u7740\u91cf").defineInRange("default", 200, 0, Integer.MAX_VALUE);
        ELEMENT_ICD_HIT_STEP = BUILDER.comment(new String[]{"ICD \u653b\u51fb\u6b65\u957f\uff1a\u5141\u8bb8\u5728\u7b2c 1\u30011+\u6b65\u957f\u30011+2*\u6b65\u957f... \u6b21\u653b\u51fb\u65f6\u5e94\u7528\u5143\u7d20", "\u8bbe\u7f6e\u4e3a 3 \u8868\u793a\u5141\u8bb8\u7b2c 1\u30014\u30017 \u6b21\u653b\u51fb\u7b49"}).defineInRange("icd_hit_step", 3, 1, Integer.MAX_VALUE);
        ELEMENT_ICD_TIME_TICKS = BUILDER.comment(new String[]{"ICD \u65f6\u95f4\u7a97\u53e3\uff08\u6e38\u620f\u523b\uff09\uff1a\u5982\u679c\u4e0a\u6b21\u5e94\u7528\u65f6\u95f4\u8d85\u8fc7\u6b64\u7a97\u53e3\u5219\u5141\u8bb8\u5e94\u7528", "50 \u523b = 2.5 \u79d2\uff0820 TPS\uff09"}).defineInRange("icd_time_ticks", 50, 0, Integer.MAX_VALUE);
        ELEMENT_ATTACHMENT_OVERRIDES_TEXT = BUILDER.comment(new String[]{"\u5355\u4e2a\u6cd5\u672f\u8986\u76d6\uff0c\u683c\u5f0f\uff1amodid:spell_id=\u6570\u91cf", "\u591a\u4e2a\u6761\u76ee\u7528\u9017\u53f7\u5206\u9694", "\u793a\u4f8b\uff1airons_spellbooks:firebolt=250, irons_spellbooks:ice_shard=150", "\u672a\u77e5\u6216\u683c\u5f0f\u9519\u8bef\u7684\u6761\u76ee\u5c06\u88ab\u5ffd\u7565"}).define("overrides", (Object)"");
        SPELL_ELEMENT_OVERRIDES_TEXT = BUILDER.comment(new String[]{"\u5355\u4e2a\u6cd5\u672f\u5143\u7d20\u9644\u7740\u8986\u76d6\uff0c\u683c\u5f0f\uff1amodid:spell_id=\u5143\u7d20ID", "\u5141\u8bb8\u7279\u5b9a\u6cd5\u672f\u9644\u7740\u81ea\u5b9a\u4e49\u5143\u7d20\u800c\u4e0d\u662f\u4f7f\u7528\u57fa\u4e8e\u5b66\u6d3e\u7684\u6620\u5c04", "\u591a\u4e2a\u6761\u76ee\u7528\u9017\u53f7\u5206\u9694", "\u793a\u4f8b\uff1airons_spellbooks:firebolt=lightning, irons_spellbooks:ice_shard=fire", "\u5143\u7d20ID\u5e94\u4e0e element_attachments \u6570\u636e\u6587\u4ef6\u4e2d\u5b9a\u4e49\u7684\u5339\u914d", "\u672a\u77e5\u6216\u683c\u5f0f\u9519\u8bef\u7684\u6761\u76ee\u5c06\u88ab\u5ffd\u7565"}).define("spell_element_overrides", (Object)"");
        BUILDER.pop();
        BUILDER.push("weapon");
        WEAPON_MAX_ELEMENT_AMOUNT = BUILDER.comment("\u6b66\u5668\u53ef\u9644\u7740\u7684\u6700\u5927\u5143\u7d20\u91cf").defineInRange("max_element_amount", 20000, 1, Integer.MAX_VALUE);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

