/*
 * Decompiled with CFR 0.152.
 */
package com.chadate.spellelemental.integration.jei;

import com.chadate.spellelemental.SpellElemental;
import com.chadate.spellelemental.integration.jei.category.SwordOilApplicationCategory;
import com.chadate.spellelemental.integration.jei.data.SwordOilConfigLoader;
import com.chadate.spellelemental.integration.jei.recipe.SwordOilApplicationRecipe;
import com.chadate.spellelemental.item.SwordOilItem;
import com.chadate.spellelemental.register.ModBlocks;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class SpellElementalJEIPlugin
implements IModPlugin {
    public static final ResourceLocation PLUGIN_ID = ResourceLocation.fromNamespaceAndPath((String)"spellelemental", (String)"jei_plugin");
    public static final RecipeType<SwordOilApplicationRecipe> SWORD_OIL_APPLICATION = RecipeType.create((String)"spellelemental", (String)"sword_oil_application", SwordOilApplicationRecipe.class);

    @NotNull
    public ResourceLocation getPluginUid() {
        return PLUGIN_ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new SwordOilApplicationCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.SWORD_STAND.get()), new RecipeType[]{SWORD_OIL_APPLICATION});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        List<SwordOilApplicationRecipe> recipes = this.createSwordOilApplicationRecipes();
        registration.addRecipes(SWORD_OIL_APPLICATION, recipes);
    }

    private List<SwordOilApplicationRecipe> createSwordOilApplicationRecipes() {
        ArrayList<SwordOilApplicationRecipe> recipes = new ArrayList<SwordOilApplicationRecipe>();
        List<ItemStack> swords = this.getSwordItems();
        List<SwordOilConfigLoader.SwordOilConfig> swordOilConfigs = SwordOilConfigLoader.getSwordOilConfigs();
        if (swordOilConfigs.isEmpty()) {
            SpellElemental.LOGGER.info("\u7cbe\u6cb9\u914d\u7f6e\u4e3a\u7a7a\uff0c\u521b\u5efa\u57fa\u7840\u5c55\u793a\u914d\u65b9");
            recipes.addAll(this.createFallbackRecipes(swords));
        } else {
            for (ItemStack sword : swords) {
                for (SwordOilConfigLoader.SwordOilConfig oilConfig : swordOilConfigs) {
                    ItemStack swordOilItem = oilConfig.getItemStack();
                    if (swordOilItem.isEmpty()) continue;
                    recipes.add(new SwordOilApplicationRecipe(sword.copy(), swordOilItem, new ItemStack((ItemLike)ModBlocks.SWORD_STAND.get()), this.createEnchantedSword(sword.getItem(), oilConfig.getElement(), oilConfig.getAmount()), oilConfig.getElement(), oilConfig.getAmount()));
                }
            }
        }
        return recipes;
    }

    private List<SwordOilApplicationRecipe> createFallbackRecipes(List<ItemStack> swords) {
        ArrayList<SwordOilApplicationRecipe> fallbackRecipes = new ArrayList<SwordOilApplicationRecipe>();
        List<ItemStack> oilItems = this.getAllSwordOilItems();
        for (ItemStack sword : swords) {
            for (ItemStack oilItem : oilItems) {
                Item item = oilItem.getItem();
                if (!(item instanceof SwordOilItem)) continue;
                SwordOilItem swordOilItem = (SwordOilItem)item;
                String element = swordOilItem.getElementType();
                int amount = swordOilItem.getElementAmount();
                if (element.isEmpty()) {
                    element = "unknown";
                }
                if (amount <= 0) {
                    amount = 1000;
                }
                fallbackRecipes.add(new SwordOilApplicationRecipe(sword.copy(), oilItem.copy(), new ItemStack((ItemLike)ModBlocks.SWORD_STAND.get()), this.createEnchantedSword(sword.getItem(), element, amount), element, amount));
            }
        }
        return fallbackRecipes;
    }

    private List<ItemStack> getAllSwordOilItems() {
        ArrayList<ItemStack> oilItems = new ArrayList<ItemStack>();
        for (Map.Entry entry : BuiltInRegistries.ITEM.entrySet()) {
            Item item = (Item)entry.getValue();
            if (!(item instanceof SwordOilItem)) continue;
            oilItems.add(new ItemStack((ItemLike)item));
        }
        return oilItems;
    }

    private List<ItemStack> getSwordItems() {
        ArrayList<ItemStack> swords = new ArrayList<ItemStack>();
        Iterable swordTag = BuiltInRegistries.ITEM.getTagOrEmpty(ItemTags.SWORDS);
        for (Holder holder : swordTag) {
            swords.add(new ItemStack((ItemLike)holder.value()));
        }
        return swords;
    }

    private ItemStack createEnchantedSword(Item swordItem, String elementType, int elementAmount) {
        ItemStack sword = new ItemStack((ItemLike)swordItem);
        CompoundTag tag = new CompoundTag();
        CompoundTag elementData = new CompoundTag();
        elementData.putString("element", elementType);
        elementData.putInt("amount", elementAmount);
        elementData.putLong("appliedTime", System.currentTimeMillis());
        tag.put("ElementAttachment", (Tag)elementData);
        sword.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
        return sword;
    }
}

