/*
 * Decompiled with CFR 0.152.
 */
package com.chadate.spellelemental.network;

import com.chadate.spellelemental.SpellElemental;
import com.chadate.spellelemental.element.attachment.data.UnifiedElementAttachmentAssets;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ElementAttachmentSyncPacket(Map<String, String> iconMap, Map<String, String> particleMap, Map<String, String> schoolMap) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ElementAttachmentSyncPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"spellelemental", (String)"element_attachment_sync"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ElementAttachmentSyncPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)StreamCodec.of((buf, map) -> {
        buf.writeInt(map.size());
        map.forEach((key, value) -> {
            buf.writeUtf(key);
            buf.writeUtf(value);
        });
    }, buf -> {
        int size = buf.readInt();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < size; ++i) {
            map.put(buf.readUtf(), buf.readUtf());
        }
        return map;
    }), ElementAttachmentSyncPacket::iconMap, (StreamCodec)StreamCodec.of((buf, map) -> {
        buf.writeInt(map.size());
        map.forEach((key, value) -> {
            buf.writeUtf(key);
            buf.writeUtf(value);
        });
    }, buf -> {
        int size = buf.readInt();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < size; ++i) {
            map.put(buf.readUtf(), buf.readUtf());
        }
        return map;
    }), ElementAttachmentSyncPacket::particleMap, (StreamCodec)StreamCodec.of((buf, map) -> {
        buf.writeInt(map.size());
        map.forEach((key, value) -> {
            buf.writeUtf(key);
            buf.writeUtf(value);
        });
    }, buf -> {
        int size = buf.readInt();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < size; ++i) {
            map.put(buf.readUtf(), buf.readUtf());
        }
        return map;
    }), ElementAttachmentSyncPacket::schoolMap, ElementAttachmentSyncPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static ElementAttachmentSyncPacket create() {
        return new ElementAttachmentSyncPacket(UnifiedElementAttachmentAssets.getAllIcons(), UnifiedElementAttachmentAssets.getAllParticleEffects(), UnifiedElementAttachmentAssets.getAllSchools());
    }

    public static void handleClient(ElementAttachmentSyncPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            UnifiedElementAttachmentAssets.clear();
            packet.iconMap.forEach(UnifiedElementAttachmentAssets::setIcon);
            packet.particleMap.forEach(UnifiedElementAttachmentAssets::setParticleEffect);
            packet.schoolMap.forEach(UnifiedElementAttachmentAssets::setSchool);
            SpellElemental.LOGGER.info("\u5df2\u540c\u6b65 {} \u4e2a\u5143\u7d20\u56fe\u6807, {} \u4e2a\u7c92\u5b50\u6548\u679c, {} \u4e2a\u5b66\u6d3e\u914d\u7f6e", new Object[]{packet.iconMap.size(), packet.particleMap.size(), packet.schoolMap.size()});
        });
    }
}

