/*
 * Decompiled with CFR 0.152.
 */
package com.chadate.spellelemental.network;

import com.chadate.spellelemental.SpellElemental;
import com.chadate.spellelemental.integration.jei.data.SwordOilConfigLoader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SwordOilConfigSyncPacket(List<SwordOilConfigData> configs) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SwordOilConfigSyncPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"spellelemental", (String)"sword_oil_config_sync"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SwordOilConfigSyncPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)StreamCodec.of((buf, configs) -> {
        buf.writeInt(configs.size());
        for (SwordOilConfigData config : configs) {
            buf.writeUtf(config.itemId());
            buf.writeUtf(config.element());
            buf.writeInt(config.amount());
            buf.writeUtf(config.displayName());
        }
    }, buf -> {
        int size = buf.readInt();
        ArrayList<SwordOilConfigData> configs = new ArrayList<SwordOilConfigData>();
        for (int i = 0; i < size; ++i) {
            configs.add(new SwordOilConfigData(buf.readUtf(), buf.readUtf(), buf.readInt(), buf.readUtf()));
        }
        return configs;
    }), SwordOilConfigSyncPacket::configs, SwordOilConfigSyncPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static SwordOilConfigSyncPacket create() {
        ArrayList<SwordOilConfigData> configData = new ArrayList<SwordOilConfigData>();
        for (SwordOilConfigLoader.SwordOilConfig config : SwordOilConfigLoader.getSwordOilConfigs()) {
            configData.add(new SwordOilConfigData(config.getItemId(), config.getElement(), config.getAmount(), config.getDisplayName()));
        }
        return new SwordOilConfigSyncPacket(configData);
    }

    public static void handleClient(SwordOilConfigSyncPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            SwordOilConfigLoader.clearConfigs();
            for (SwordOilConfigData configData : packet.configs) {
                SwordOilConfigLoader.addConfig(new SwordOilConfigLoader.SwordOilConfig(configData.itemId(), configData.element(), configData.amount(), configData.displayName()));
            }
            SpellElemental.LOGGER.info("\u5df2\u540c\u6b65 {} \u4e2a\u7cbe\u6cb9\u914d\u7f6e\u5230\u5ba2\u6237\u7aef", (Object)packet.configs.size());
        });
    }

    public record SwordOilConfigData(String itemId, String element, int amount, String displayName) {
    }
}

