/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.core.terminalstorage;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientCollapsedCollectionMutable;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientCollection;
import org.cyclops.cyclopscore.ingredient.collection.IngredientArrayList;
import org.cyclops.cyclopscore.ingredient.collection.IngredientCollectionHelpers;
import org.cyclops.cyclopscore.ingredient.collection.diff.IngredientCollectionDiff;
import org.cyclops.cyclopscore.ingredient.collection.diff.IngredientCollectionDiffHelpers;
import org.cyclops.cyclopscore.ingredient.collection.diff.IngredientCollectionDiffManager;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integrateddynamics.Capabilities;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.ingredient.IIngredientComponentStorageObservable;
import org.cyclops.integrateddynamics.api.ingredient.IIngredientPositionsIndex;
import org.cyclops.integrateddynamics.api.ingredient.capability.IIngredientComponentValueHandler;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkIngredientsChannel;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetworkIngredients;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeOperator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integratedterminals.Capabilities;
import org.cyclops.integratedterminals.GeneralConfig;
import org.cyclops.integratedterminals.IntegratedTerminals;
import org.cyclops.integratedterminals.api.ingredient.IIngredientComponentTerminalStorageHandler;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabServer;
import org.cyclops.integratedterminals.api.terminalstorage.TerminalClickType;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingOption;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalStorageTabIngredientCraftingHandler;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentCommon;
import org.cyclops.integratedterminals.core.terminalstorage.crafting.HandlerWrappedTerminalCraftingOption;
import org.cyclops.integratedterminals.core.terminalstorage.crafting.TerminalStorageTabIngredientCraftingHandlers;
import org.cyclops.integratedterminals.network.packet.TerminalStorageIngredientChangeEventPacket;
import org.cyclops.integratedterminals.network.packet.TerminalStorageIngredientCraftingOptionsPacket;
import org.cyclops.integratedterminals.network.packet.TerminalStorageIngredientMaxQuantityPacket;
import org.cyclops.integratedterminals.network.packet.TerminalStorageIngredientUpdateActiveStorageIngredientPacket;

public class TerminalStorageTabIngredientComponentServer<T, M>
implements ITerminalStorageTabServer,
IIngredientComponentStorageObservable.IIndexChangeObserver<T, M> {
    private static final ExecutorService PACKET_SERIALIZER = Executors.newFixedThreadPool(1);
    private final ResourceLocation name;
    private final INetwork network;
    private final IngredientComponent<T, M> ingredientComponent;
    private final IPositionedAddonsNetworkIngredients<T, M> ingredientNetwork;
    private final ServerPlayer player;
    private final IIngredientComponentValueHandler<?, ?, T, M> valueHandler;
    private final Int2ObjectMap<Collection<HandlerWrappedTerminalCraftingOption<T>>> craftingOptions;
    @Nullable
    private Predicate<T> ingredientsFilter;
    private final Int2ObjectMap<IIngredientCollapsedCollectionMutable<T, M>> unfilteredIngredientsViews;
    private final Int2ObjectMap<IngredientCollectionDiffManager<T, M>> filteredDiffManagers;
    private boolean initialized;
    private boolean sentCraftingOptionsFiltered;

    public TerminalStorageTabIngredientComponentServer(ResourceLocation name, INetwork network, IngredientComponent<T, M> ingredientComponent, IPositionedAddonsNetworkIngredients<T, M> ingredientNetwork, ServerPlayer player) {
        this.name = name;
        this.network = network;
        this.ingredientComponent = ingredientComponent;
        this.ingredientNetwork = ingredientNetwork;
        this.player = player;
        this.valueHandler = (IIngredientComponentValueHandler)ingredientComponent.getCapability(Capabilities.IngredientComponentValueHandler.INGREDIENT).orElseThrow(() -> new IllegalStateException("No value handler was found for " + String.valueOf(ingredientComponent.getName())));
        this.craftingOptions = new Int2ObjectOpenHashMap();
        this.ingredientsFilter = null;
        this.unfilteredIngredientsViews = new Int2ObjectOpenHashMap();
        this.filteredDiffManagers = new Int2ObjectOpenHashMap();
        ingredientNetwork.scheduleObservation();
    }

    @Override
    public ResourceLocation getName() {
        return this.name;
    }

    @Override
    public void init() {
        HashSet channels = Sets.newHashSet();
        for (int channel : this.ingredientNetwork.getChannels()) {
            channels.add(channel);
        }
        Object object = TerminalStorageTabIngredientCraftingHandlers.REGISTRY.getHandlers().iterator();
        while (object.hasNext()) {
            ITerminalStorageTabIngredientCraftingHandler handler = (ITerminalStorageTabIngredientCraftingHandler)object.next();
            for (int channel : handler.getChannels(this)) {
                channels.add(channel);
            }
        }
        object = channels.iterator();
        while (object.hasNext()) {
            int channel = (Integer)object.next();
            this.initChannel(channel);
        }
        this.ingredientNetwork.addObserver((IIngredientComponentStorageObservable.IIndexChangeObserver)this);
    }

    protected void initChannel(int channel) {
        IIngredientPositionsIndex channelInstance = this.ingredientNetwork.getChannelIndex(channel);
        this.onChange(new IIngredientComponentStorageObservable.StorageChangeEvent(channel, null, IIngredientComponentStorageObservable.Change.ADDITION, false, (IIngredientCollection)channelInstance, false));
        ArrayList channeledCraftingOptions = Lists.newArrayList();
        for (ITerminalStorageTabIngredientCraftingHandler handler : TerminalStorageTabIngredientCraftingHandlers.REGISTRY.getHandlers()) {
            Collection options = handler.getCraftingOptions(this, channel);
            for (ITerminalCraftingOption option : options) {
                if (!option.getOutputComponents().contains(this.ingredientComponent)) continue;
                channeledCraftingOptions.add(new HandlerWrappedTerminalCraftingOption(handler, option));
            }
        }
        this.craftingOptions.put(channel, (Object)channeledCraftingOptions);
        boolean firstChannel = true;
        if (channeledCraftingOptions.size() > 0) {
            this.sendCraftingOptionsToClient(channel, channeledCraftingOptions, false, firstChannel);
            firstChannel = false;
        }
    }

    @Override
    public void deInit() {
        this.ingredientNetwork.removeObserver((IIngredientComponentStorageObservable.IIndexChangeObserver)this);
    }

    @Override
    public void updateActive() {
        this.ingredientNetwork.scheduleObservation();
    }

    protected IIngredientCollapsedCollectionMutable<T, M> getUnfilteredIngredientsView(int channel) {
        IIngredientCollapsedCollectionMutable ingredientsView = (IIngredientCollapsedCollectionMutable)this.unfilteredIngredientsViews.get(channel);
        if (ingredientsView == null) {
            ingredientsView = IngredientCollectionHelpers.createCollapsedCollection(this.ingredientComponent);
            this.unfilteredIngredientsViews.put(channel, (Object)ingredientsView);
        }
        return ingredientsView;
    }

    protected IngredientCollectionDiffManager<T, M> getFilteredDiffManager(int channel) {
        IngredientCollectionDiffManager diffManager = (IngredientCollectionDiffManager)this.filteredDiffManagers.get(channel);
        if (diffManager == null) {
            diffManager = new IngredientCollectionDiffManager(this.ingredientComponent);
            this.filteredDiffManagers.put(channel, (Object)diffManager);
        }
        return diffManager;
    }

    public void updateFilter(List<IVariable<ValueTypeOperator.ValueOperator>> variables, TerminalStorageTabIngredientComponentCommon<?, ?> errorListener) {
        if (variables.isEmpty()) {
            this.ingredientsFilter = null;
            return;
        }
        this.ingredientsFilter = instance -> false;
        Predicate<Object> newFilter = instance -> true;
        try {
            for (IVariable<ValueTypeOperator.ValueOperator> variable : variables) {
                if (variable.getType() == ValueTypes.OPERATOR) {
                    ValueTypeOperator.ValueOperator operator = (ValueTypeOperator.ValueOperator)variable.getValue();
                    IValueType inputValueType = this.valueHandler.getValueType();
                    newFilter = newFilter.and(instance -> {
                        if (NetworkHelpers.shouldWork()) {
                            try {
                                IValue inputValue = this.valueHandler.toValue(instance);
                                IOperator predicate = operator.getRawValue();
                                if (predicate.getInputTypes().length == 1 && ValueHelpers.correspondsTo((IValueType)predicate.getInputTypes()[0], (IValueType)inputValueType) && ValueHelpers.correspondsTo((IValueType)predicate.getOutputType(), (IValueType)ValueTypes.BOOLEAN)) {
                                    IValue result = ValueHelpers.evaluateOperator((IOperator)predicate, (IValue[])new IValue[]{inputValue});
                                    ValueHelpers.validatePredicateOutput((IOperator)predicate, (IValue)result);
                                    return ((ValueTypeBoolean.ValueBoolean)result).getRawValue();
                                }
                                MutableComponent current = ValueTypeOperator.getSignature((IOperator)predicate);
                                Component expected = ValueTypeOperator.getSignature((IValueType[])new IValueType[]{inputValueType}, (IValueType)ValueTypes.BOOLEAN);
                                throw new EvaluationException(Component.translatable((String)"aspect.integrateddynamics.error.invalid_type", (Object[])new Object[]{expected, current}));
                            }
                            catch (EvaluationException e) {
                                if (!errorListener.hasErrors()) {
                                    errorListener.addError(e.getErrorMessage());
                                    this.ingredientsFilter = t -> false;
                                }
                                return false;
                            }
                        }
                        return false;
                    });
                    continue;
                }
                throw new EvaluationException(Component.translatable((String)"aspect.integrateddynamics.error.invalid_type", (Object[])new Object[]{ValueTypes.OPERATOR, variable.getType()}));
            }
        }
        catch (EvaluationException e) {
            errorListener.addError(e.getErrorMessage());
            return;
        }
        this.ingredientsFilter = newFilter;
    }

    @Nullable
    protected Predicate<T> getIngredientsFilter() {
        return this.ingredientsFilter;
    }

    public void onChange(IIngredientComponentStorageObservable.StorageChangeEvent<T, M> event) {
        int channel = event.getChannel();
        IngredientCollectionDiff diffIn = event.getDiff();
        IngredientCollectionDiffHelpers.applyDiff(this.ingredientComponent, (IngredientCollectionDiff)diffIn, this.getUnfilteredIngredientsView(channel));
        this.reApplyFilter(event);
    }

    protected void reApplyFilter(@Nullable IIngredientComponentStorageObservable.StorageChangeEvent<T, M> event) {
        boolean firstChannel = true;
        Iterator iterator = (event == null ? this.unfilteredIngredientsViews.keySet() : Collections.singleton(event.getChannel())).iterator();
        while (iterator.hasNext()) {
            int channel = (Integer)iterator.next();
            Predicate ingredientsFilter = this.getIngredientsFilter();
            if (ingredientsFilter != null || event == null) {
                Iterator newFilteredIngredients = this.getUnfilteredIngredientsView(channel).stream().filter(ingredientsFilter == null ? instance -> true : ingredientsFilter).iterator();
                IngredientCollectionDiffManager<T, M> filteredDiffManager = this.getFilteredDiffManager(channel);
                IngredientCollectionDiff diffOut = filteredDiffManager.onChange(newFilteredIngredients);
                if (!this.initialized || diffOut.hasAdditions()) {
                    this.sendToClient(new IIngredientComponentStorageObservable.StorageChangeEvent(channel, null, IIngredientComponentStorageObservable.Change.ADDITION, false, diffOut.getAdditions(), false));
                }
                if (diffOut.hasDeletions()) {
                    this.sendToClient(new IIngredientComponentStorageObservable.StorageChangeEvent(channel, null, IIngredientComponentStorageObservable.Change.DELETION, diffOut.isCompletelyEmpty(), diffOut.getDeletions(), false));
                }
            } else {
                if (!this.initialized || event.getDiff().hasAdditions()) {
                    this.sendToClient(new IIngredientComponentStorageObservable.StorageChangeEvent(channel, null, IIngredientComponentStorageObservable.Change.ADDITION, false, event.getDiff().getAdditions(), false));
                }
                if (event.getDiff().hasDeletions()) {
                    this.sendToClient(new IIngredientComponentStorageObservable.StorageChangeEvent(channel, null, IIngredientComponentStorageObservable.Change.DELETION, event.getDiff().isCompletelyEmpty(), event.getDiff().getDeletions(), false));
                }
                IngredientCollectionDiffManager<T, M> filteredDiffManager = this.getFilteredDiffManager(channel);
                if (event.getDiff().hasAdditions()) {
                    filteredDiffManager.getInstancesCache().addAll((Iterable)event.getDiff().getAdditions());
                }
                if (event.getDiff().hasDeletions()) {
                    filteredDiffManager.getInstancesCache().removeAll((Iterable)event.getDiff().getDeletions());
                }
            }
            Collection channeledCraftingOptions = (Collection)this.craftingOptions.get(channel);
            if (channeledCraftingOptions != null) {
                Collection channeledCraftingOptionsFiltered = ingredientsFilter != null ? (Collection)channeledCraftingOptions.stream().filter(o -> {
                    Iterator it = o.getCraftingOption().getOutputs();
                    while (it.hasNext()) {
                        if (!ingredientsFilter.test(it.next())) continue;
                        return true;
                    }
                    return false;
                }).collect(Collectors.toList()) : channeledCraftingOptions;
                if (ingredientsFilter != null || this.sentCraftingOptionsFiltered) {
                    this.sendCraftingOptionsToClient(channel, channeledCraftingOptionsFiltered, true, firstChannel);
                }
                this.sentCraftingOptionsFiltered = ingredientsFilter != null;
            }
            firstChannel = false;
        }
        this.initialized = true;
    }

    protected void sendToClient(IIngredientComponentStorageObservable.StorageChangeEvent<T, M> event) {
        long maxQuantity = this.ingredientNetwork.getChannel(event.getChannel()).getMaxQuantity();
        if (event.getInstances().size() <= GeneralConfig.terminalStoragePacketMaxInstances) {
            IntegratedTerminals._instance.getPacketHandler().sendToPlayer((PacketBase)new TerminalStorageIngredientChangeEventPacket((HolderLookup.Provider)ServerLifecycleHooks.getCurrentServer().registryAccess(), this.getName().toString(), event, this.ingredientNetwork.hasPositions()), this.player);
            IntegratedTerminals._instance.getPacketHandler().sendToPlayer((PacketBase)new TerminalStorageIngredientMaxQuantityPacket(this.getName().toString(), event.getInstances().getComponent(), maxQuantity, event.getChannel()), this.player);
        } else {
            ArrayList chunks = Lists.newArrayList();
            IngredientArrayList buffer = new IngredientArrayList(event.getInstances().getComponent(), GeneralConfig.terminalStoragePacketMaxInstances);
            for (Object instance : event.getInstances()) {
                buffer.add(instance);
                if (buffer.size() != GeneralConfig.terminalStoragePacketMaxInstances) continue;
                chunks.add(buffer);
                buffer = new IngredientArrayList(event.getInstances().getComponent(), GeneralConfig.terminalStoragePacketMaxInstances);
            }
            if (!buffer.isEmpty()) {
                chunks.add(buffer);
            }
            for (IngredientArrayList chunk : chunks) {
                if (GeneralConfig.packetSerializationEnableMultithreading) {
                    PACKET_SERIALIZER.execute(() -> this.sendToClient(new IIngredientComponentStorageObservable.StorageChangeEvent(event.getChannel(), event.getPos(), event.getChangeType(), event.isCompleteChange(), (IIngredientCollection)chunk, false)));
                    continue;
                }
                this.sendToClient(new IIngredientComponentStorageObservable.StorageChangeEvent(event.getChannel(), event.getPos(), event.getChangeType(), event.isCompleteChange(), (IIngredientCollection)chunk, false));
            }
        }
    }

    private void sendCraftingOptionsToClient(int channel, Collection<HandlerWrappedTerminalCraftingOption<T>> channeledCraftingOptions, boolean reset, boolean firstChannel) {
        if (channeledCraftingOptions.size() <= GeneralConfig.terminalStoragePacketMaxRecipes) {
            IntegratedTerminals._instance.getPacketHandler().sendToPlayer((PacketBase)new TerminalStorageIngredientCraftingOptionsPacket((HolderLookup.Provider)this.player.level().registryAccess(), this.getName().toString(), channel, channeledCraftingOptions, reset, firstChannel, this.ingredientComponent), this.player);
        } else {
            ArrayList chunks = Lists.newArrayList();
            ArrayList buffer = Lists.newArrayListWithExpectedSize((int)GeneralConfig.terminalStoragePacketMaxRecipes);
            for (HandlerWrappedTerminalCraftingOption<T> instance : channeledCraftingOptions) {
                buffer.add(instance);
                if (buffer.size() != GeneralConfig.terminalStoragePacketMaxRecipes) continue;
                chunks.add(Pair.of((Object)reset, (Object)buffer));
                reset = false;
                buffer = Lists.newArrayListWithExpectedSize((int)GeneralConfig.terminalStoragePacketMaxRecipes);
            }
            if (!buffer.isEmpty()) {
                chunks.add(Pair.of((Object)reset, (Object)buffer));
            }
            for (Pair chunk : chunks) {
                if (GeneralConfig.packetSerializationEnableMultithreading) {
                    PACKET_SERIALIZER.execute(() -> this.sendCraftingOptionsToClient(channel, (Collection)chunk.getRight(), (Boolean)chunk.getLeft(), firstChannel));
                    continue;
                }
                this.sendCraftingOptionsToClient(channel, (Collection)chunk.getRight(), (Boolean)chunk.getLeft(), firstChannel);
            }
        }
    }

    public INetwork getNetwork() {
        return this.network;
    }

    public IPositionedAddonsNetworkIngredients<T, M> getIngredientNetwork() {
        return this.ingredientNetwork;
    }

    @Nullable
    public void handleStorageSlotClick(AbstractContainerMenu container, ServerPlayer player, TerminalClickType clickType, int channel, T hoveringStorageInstance, int hoveredContainerSlot, long moveQuantityPlayerSlot, T activeStorageInstance, boolean transferFullSelection) {
        IIngredientComponentTerminalStorageHandler viewHandler = (IIngredientComponentTerminalStorageHandler)this.ingredientComponent.getCapability(Capabilities.IngredientComponentTerminalStorageHandler.INGREDIENT).orElseThrow(() -> new IllegalStateException("Could not find an ingredient terminal storage handler"));
        INetworkIngredientsChannel storage = this.ingredientNetwork.getChannel(channel);
        boolean updateActivePlayerStack = false;
        switch (clickType) {
            case STORAGE_QUICK_MOVE: {
                viewHandler.insertMaxIntoContainer(storage, container, 0, 36, hoveringStorageInstance);
                break;
            }
            case STORAGE_QUICK_MOVE_INCREMENTAL: {
                viewHandler.insertMaxIntoContainer(storage, container, 0, 36, this.ingredientComponent.getMatcher().withQuantity(hoveringStorageInstance, (long)viewHandler.getIncrementalInstanceMovementQuantity()));
                break;
            }
            case STORAGE_PLACE_WORLD: {
                viewHandler.throwIntoWorld(storage, activeStorageInstance, (Player)player);
                break;
            }
            case STORAGE_PLACE_PLAYER: {
                T movedInstance = viewHandler.insertIntoContainer(storage, container, hoveredContainerSlot, activeStorageInstance, (Player)player, transferFullSelection);
                updateActivePlayerStack = true;
                IIngredientMatcher matcher = this.ingredientComponent.getMatcher();
                Object remainingInstance = matcher.withQuantity(movedInstance, matcher.getQuantity(activeStorageInstance) - matcher.getQuantity(movedInstance));
                IntegratedTerminals._instance.getPacketHandler().sendToPlayer(new TerminalStorageIngredientUpdateActiveStorageIngredientPacket<Object>((HolderLookup.Provider)player.level().registryAccess(), this.getName().toString(), this.ingredientComponent, channel, remainingInstance), player);
                break;
            }
            case PLAYER_PLACE_STORAGE: {
                viewHandler.extractActiveStackFromPlayerInventory(storage, container, player.getInventory(), moveQuantityPlayerSlot);
                updateActivePlayerStack = true;
                break;
            }
            case PLAYER_QUICK_MOVE: {
                viewHandler.extractMaxFromContainerSlot(storage, container, hoveredContainerSlot, player.getInventory(), -1);
                break;
            }
            case PLAYER_QUICK_MOVE_INCREMENTAL: {
                viewHandler.extractMaxFromContainerSlot(storage, container, hoveredContainerSlot, player.getInventory(), viewHandler.getIncrementalInstanceMovementQuantity());
            }
        }
        if (updateActivePlayerStack) {
            player.connection.send((Packet)new ClientboundContainerSetSlotPacket(-1, 0, 0, container.getCarried()));
        }
    }
}

