/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.capability.ingredient;

import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.BaseCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.ingredient.storage.InconsistentIngredientInsertionException;
import org.cyclops.cyclopscore.ingredient.storage.IngredientStorageHelpers;
import org.cyclops.integratedterminals.GeneralConfig;
import org.cyclops.integratedterminals.RegistryEntries;
import org.cyclops.integratedterminals.api.ingredient.IIngredientComponentTerminalStorageHandler;
import org.cyclops.integratedterminals.api.ingredient.IIngredientComponentTerminalStorageHandlerClient;
import org.cyclops.integratedterminals.api.ingredient.IIngredientInstanceSorter;
import org.cyclops.integratedterminals.capability.ingredient.IngredientComponentTerminalStorageHandlerEnergyClient;

public class IngredientComponentTerminalStorageHandlerEnergy
implements IIngredientComponentTerminalStorageHandler<Long, Boolean> {
    private final IngredientComponent<Long, Boolean> ingredientComponent;

    public IngredientComponentTerminalStorageHandlerEnergy(IngredientComponent<Long, Boolean> ingredientComponent) {
        this.ingredientComponent = ingredientComponent;
    }

    @Override
    public IIngredientComponentTerminalStorageHandlerClient<Long, Boolean> getClient() {
        return new IngredientComponentTerminalStorageHandlerEnergyClient(this);
    }

    @Override
    public IngredientComponent<Long, Boolean> getComponent() {
        return this.ingredientComponent;
    }

    @Override
    public ItemStack getIcon() {
        return new ItemStack(RegistryEntries.ITEM_ENERGY_BATTERY);
    }

    @Override
    public String formatQuantity(Long instance) {
        return IModHelpers.get().getL10NHelpers().localize("gui.integratedterminals.terminal_storage.tooltip.energy.amount", new Object[]{String.format(Locale.ROOT, "%,d", instance)});
    }

    @Override
    public boolean isInstance(ItemStack itemStack) {
        return itemStack.getCapability(Capabilities.EnergyStorage.ITEM) != null;
    }

    @Override
    public Long getInstance(ItemStack itemStack) {
        return Optional.ofNullable((IEnergyStorage)itemStack.getCapability(Capabilities.EnergyStorage.ITEM)).map(IEnergyStorage::getEnergyStored).orElse(0).longValue();
    }

    @Override
    public long getMaxQuantity(ItemStack itemStack) {
        return Optional.ofNullable((IEnergyStorage)itemStack.getCapability(Capabilities.EnergyStorage.ITEM)).map(IEnergyStorage::getMaxEnergyStored).orElse(0).intValue();
    }

    @Override
    public int getInitialInstanceMovementQuantity() {
        return GeneralConfig.guiStorageEnergyInitialQuantity;
    }

    @Override
    public int getIncrementalInstanceMovementQuantity() {
        return GeneralConfig.guiStorageEnergyIncrementalQuantity;
    }

    @Override
    public int throwIntoWorld(IIngredientComponentStorage<Long, Boolean> storage, Long maxInstance, Player player) {
        return 0;
    }

    protected IIngredientComponentStorage<Long, Boolean> getEnergyStorage(IngredientComponent<Long, Boolean> component, IEnergyStorage energyStorage) {
        return component.getStorageWrapperHandler((BaseCapability)Capabilities.EnergyStorage.ITEM).wrapComponentStorage((Object)energyStorage);
    }

    @Override
    public Long insertIntoContainer(IIngredientComponentStorage<Long, Boolean> storage, AbstractContainerMenu container, int containerSlot, Long maxInstance, @Nullable Player player, boolean transferFullSelection) {
        ItemStack stack = container.getSlot(containerSlot).getItem();
        return Optional.ofNullable((IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM)).map(energyStorage -> {
            IIngredientComponentStorage<Long, Boolean> itemStorage = this.getEnergyStorage((IngredientComponent<Long, Boolean>)storage.getComponent(), (IEnergyStorage)energyStorage);
            Long ret = 0L;
            try {
                ret = (Long)IngredientStorageHelpers.moveIngredientsIterative((IIngredientComponentStorage)storage, itemStorage, (long)maxInstance, (boolean)false);
            }
            catch (InconsistentIngredientInsertionException inconsistentIngredientInsertionException) {
                // empty catch block
            }
            container.broadcastChanges();
            return ret;
        }).orElse(0L);
    }

    @Override
    public void extractActiveStackFromPlayerInventory(IIngredientComponentStorage<Long, Boolean> storage, AbstractContainerMenu container, Inventory playerInventory, long moveQuantityPlayerSlot) {
        ItemStack playerStack = container.getCarried();
        Optional.ofNullable((IEnergyStorage)playerStack.getCapability(Capabilities.EnergyStorage.ITEM)).ifPresent(energyStorage -> {
            IIngredientComponentStorage<Long, Boolean> itemStorage = this.getEnergyStorage((IngredientComponent<Long, Boolean>)storage.getComponent(), (IEnergyStorage)energyStorage);
            try {
                IngredientStorageHelpers.moveIngredientsIterative(itemStorage, (IIngredientComponentStorage)storage, (long)moveQuantityPlayerSlot, (boolean)false);
            }
            catch (InconsistentIngredientInsertionException inconsistentIngredientInsertionException) {
                // empty catch block
            }
        });
    }

    @Override
    public void extractMaxFromContainerSlot(IIngredientComponentStorage<Long, Boolean> storage, AbstractContainerMenu container, int containerSlot, Inventory playerInventory, int limit) {
        Slot slot = container.getSlot(containerSlot);
        if (slot.mayPickup(playerInventory.player)) {
            ItemStack toMoveStack = slot.getItem();
            Optional.ofNullable((IEnergyStorage)toMoveStack.getCapability(Capabilities.EnergyStorage.ITEM)).ifPresent(energyStorage -> {
                IIngredientComponentStorage<Long, Boolean> itemStorage = this.getEnergyStorage((IngredientComponent<Long, Boolean>)storage.getComponent(), (IEnergyStorage)energyStorage);
                try {
                    IngredientStorageHelpers.moveIngredientsIterative(itemStorage, (IIngredientComponentStorage)storage, (long)(limit == -1 ? Long.MAX_VALUE : (long)limit), (boolean)false);
                }
                catch (InconsistentIngredientInsertionException inconsistentIngredientInsertionException) {
                    // empty catch block
                }
            });
        }
    }

    @Override
    public long getActivePlayerStackQuantity(Inventory playerInventory, AbstractContainerMenu container) {
        ItemStack toMoveStack = container.getCarried();
        return Optional.ofNullable((IEnergyStorage)toMoveStack.getCapability(Capabilities.EnergyStorage.ITEM)).map(IEnergyStorage::getEnergyStored).orElse(0).intValue();
    }

    @Override
    public void drainActivePlayerStackQuantity(Inventory playerInventory, AbstractContainerMenu container, long quantityIn) {
        ItemStack toMoveStack = container.getCarried();
        Optional.ofNullable((IEnergyStorage)toMoveStack.getCapability(Capabilities.EnergyStorage.ITEM)).ifPresent(energyStorage -> {
            int drained;
            for (long quantity = quantityIn; quantity > 0L && (drained = energyStorage.extractEnergy((int)quantity, false)) > 0; quantity -= (long)drained) {
            }
        });
    }

    @Override
    public Collection<IIngredientInstanceSorter<Long>> getInstanceSorters() {
        return Collections.emptyList();
    }
}

