/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.capability.ingredient;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.neoforged.neoforge.fluids.FluidStack;
import org.cyclops.cyclopscore.client.gui.GuiGraphicsExtended;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.integratedterminals.api.ingredient.IIngredientComponentTerminalStorageHandlerClient;
import org.cyclops.integratedterminals.capability.ingredient.IngredientComponentTerminalStorageHandlerFluidStack;
import org.cyclops.integratedterminals.client.gui.container.ContainerScreenTerminalStorage;
import org.cyclops.integratedterminals.core.terminalstorage.query.SearchMode;

public class IngredientComponentTerminalStorageHandlerFluidStackClient
implements IIngredientComponentTerminalStorageHandlerClient<FluidStack, Integer> {
    private final IngredientComponentTerminalStorageHandlerFluidStack handler;

    public IngredientComponentTerminalStorageHandlerFluidStackClient(IngredientComponentTerminalStorageHandlerFluidStack handler) {
        this.handler = handler;
    }

    @Override
    public void drawInstance(GuiGraphics guiGraphics, FluidStack instance, long maxQuantity, @Nullable String label, AbstractContainerScreen gui, ContainerScreenTerminalStorage.DrawLayer layer, float partialTick, int x, int y, int mouseX, int mouseY, @Nullable List<Component> additionalTooltipLines) {
        if (instance != null) {
            if (layer == ContainerScreenTerminalStorage.DrawLayer.BACKGROUND) {
                IModHelpersNeoForge.get().getGuiHelpers().renderFluidSlot(guiGraphics, instance, x, y);
                GuiGraphicsExtended renderItem = new GuiGraphicsExtended(guiGraphics);
                renderItem.drawSlotText(Minecraft.getInstance().font, label != null ? label : IModHelpers.get().getGuiHelpers().quantityToScaledString((long)instance.getAmount()), x, y);
            } else {
                IModHelpers.get().getGuiHelpers().renderTooltip(gui, guiGraphics, x, y, IModHelpers.get().getGuiHelpers().getSlotSizeInner(), IModHelpers.get().getGuiHelpers().getSlotSizeInner(), mouseX, mouseY, () -> {
                    ArrayList lines = Lists.newArrayList();
                    lines.add(((MutableComponent)instance.getHoverName()).withStyle((Style)instance.getFluid().getFluidType().getRarity().getStyleModifier().apply(Style.EMPTY)));
                    this.handler.addQuantityTooltip(lines, instance);
                    if (additionalTooltipLines != null) {
                        lines.addAll(additionalTooltipLines);
                    }
                    return lines;
                });
            }
        }
    }

    @Override
    public Predicate<FluidStack> getInstanceFilterPredicate(SearchMode searchMode, String query) {
        return switch (searchMode) {
            default -> throw new MatchException(null, null);
            case SearchMode.MOD -> i -> BuiltInRegistries.FLUID.getKey((Object)i.getFluid()).getNamespace().toLowerCase(Locale.ENGLISH).matches(".*" + query + ".*");
            case SearchMode.TOOLTIP -> i -> false;
            case SearchMode.TAG -> i -> i.getFluid().builtInRegistryHolder().tags().filter(tag -> tag.location().toString().toLowerCase(Locale.ENGLISH).matches(".*" + query + ".*")).anyMatch(tag -> BuiltInRegistries.FLUID.get(tag).isPresent());
            case SearchMode.DEFAULT -> i -> i != null && i.getHoverName().getString().toLowerCase(Locale.ENGLISH).matches(".*" + query + ".*");
        };
    }
}

