/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.client.gui.container;

import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.client.gui.component.WidgetScrollBar;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonText;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenExtended;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.inventory.container.ContainerExtended;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integratedterminals.Capabilities;
import org.cyclops.integratedterminals.IntegratedTerminals;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingPlanFlat;
import org.cyclops.integratedterminals.client.gui.container.ContainerScreenTerminalStorage;
import org.cyclops.integratedterminals.client.gui.container.component.GuiCraftingPlan;
import org.cyclops.integratedterminals.core.client.gui.CraftingJobGuiData;
import org.cyclops.integratedterminals.core.terminalstorage.crafting.HandlerWrappedTerminalCraftingPlan;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalCraftingJobs;
import org.cyclops.integratedterminals.network.packet.CancelCraftingJobPacket;
import org.cyclops.integratedterminals.network.packet.OpenCraftingJobsPlanGuiPacket;

public class ContainerScreenTerminalCraftingJobs
extends ContainerScreenExtended<ContainerTerminalCraftingJobs> {
    public static int OUTPUT_SLOT_X = 8;
    public static int OUTPUT_SLOT_Y = 17;
    public static int LINE_WIDTH = 221;
    private final Player player;
    private WidgetScrollBar scrollBar;
    private int firstRow;

    public ContainerScreenTerminalCraftingJobs(ContainerTerminalCraftingJobs container, Inventory inventory, Component title) {
        super((ContainerExtended)container, inventory, title);
        this.player = inventory.player;
    }

    public void init() {
        super.init();
        this.scrollBar = new WidgetScrollBar(this.leftPos + 236, this.topPos + 18, 178, (Component)Component.translatable((String)"gui.cyclopscore.scrollbar"), this::setFirstRow, 10);
        this.scrollBar.setTotalRows(((ContainerTerminalCraftingJobs)this.getMenu()).getCraftingJobs().size() - 1);
        this.addRenderableWidget((GuiEventListener)new ButtonText(this.leftPos + 70, this.topPos + 198, 120, 20, (Component)Component.translatable((String)"gui.integratedterminals.terminal_crafting_job.craftingplan.cancel_all"), (Component)Component.translatable((String)"gui.integratedterminals.terminal_crafting_job.craftingplan.cancel_all"), b -> this.cancelCraftingJobs(), true));
    }

    protected ResourceLocation constructGuiTexture() {
        return ResourceLocation.fromNamespaceAndPath((String)"integratedterminals", (String)"textures/gui/crafting_plan.png");
    }

    public int getBaseXSize() {
        return 256;
    }

    public int getBaseYSize() {
        return 222;
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        this.scrollBar.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.drawCraftingPlans(guiGraphics, this.leftPos, this.topPos, partialTicks, mouseX - this.leftPos, mouseY - this.topPos, ContainerScreenTerminalStorage.DrawLayer.BACKGROUND);
        guiGraphics.drawString(Minecraft.getInstance().font, IModHelpers.get().getL10NHelpers().localize("parttype.integratedterminals.terminal_crafting_job", new Object[0]), this.leftPos + 8, this.topPos + 5, ARGB.opaque((int)0xFFFFFF));
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.drawCraftingPlans(guiGraphics, 0, 0, 0.0f, mouseX, mouseY, ContainerScreenTerminalStorage.DrawLayer.FOREGROUND);
    }

    protected List<HandlerWrappedTerminalCraftingPlan> getVisiblePlans() {
        return ((ContainerTerminalCraftingJobs)this.getMenu()).getCraftingJobs().subList(this.firstRow, Math.min(((ContainerTerminalCraftingJobs)this.getMenu()).getCraftingJobs().size(), this.firstRow + this.scrollBar.getVisibleRows()));
    }

    protected void drawCraftingPlans(GuiGraphics guiGraphics, int x, int y, float partialTicks, int mouseX, int mouseY, ContainerScreenTerminalStorage.DrawLayer layer) {
        int offsetY = OUTPUT_SLOT_Y;
        for (HandlerWrappedTerminalCraftingPlan craftingPlan : this.getVisiblePlans()) {
            this.drawCraftingPlan(guiGraphics, craftingPlan, x + OUTPUT_SLOT_X, y + offsetY, layer, partialTicks, mouseX, mouseY);
            offsetY += IModHelpers.get().getGuiHelpers().getSlotSize();
        }
    }

    protected void drawCraftingPlan(GuiGraphics guiGraphics, HandlerWrappedTerminalCraftingPlan craftingPlan, int x, int y, ContainerScreenTerminalStorage.DrawLayer layer, float partialTick, int mouseX, int mouseY) {
        int xOriginal = x;
        ITerminalCraftingPlanFlat plan = craftingPlan.getCraftingPlanFlat();
        if (layer == ContainerScreenTerminalStorage.DrawLayer.BACKGROUND && IModHelpers.get().getRenderHelpers().isPointInRegion(x - this.leftPos, y - this.topPos, LINE_WIDTH, IModHelpers.get().getGuiHelpers().getSlotSize(), (double)mouseX, (double)mouseY)) {
            guiGraphics.fill(x + 1, y + 1, x + LINE_WIDTH + 1, y + IModHelpers.get().getGuiHelpers().getSlotSize(), -2130706433);
        }
        x += 4;
        for (IPrototypedIngredient<?, ?> output : plan.getOutputs()) {
            IngredientComponent ingredientComponent = output.getComponent();
            long quantity = ingredientComponent.getMatcher().getQuantity(output.getPrototype());
            int finalX = x;
            ingredientComponent.getCapability(Capabilities.IngredientComponentTerminalStorageHandler.INGREDIENT).ifPresent(h -> h.getClient().drawInstance(guiGraphics, output.getPrototype(), quantity, IModHelpers.get().getGuiHelpers().quantityToScaledString(quantity), (AbstractContainerScreen)this, layer, partialTick, finalX, y + 1, mouseX, mouseY, null));
            x += IModHelpers.get().getGuiHelpers().getSlotSizeInner();
        }
        if (layer == ContainerScreenTerminalStorage.DrawLayer.BACKGROUND) {
            long tickDuration;
            String statusString = IModHelpers.get().getL10NHelpers().localize("gui.integratedterminals.craftingplan.status", new Object[]{IModHelpers.get().getL10NHelpers().localize("gui.integratedterminals.craftingplan.status." + plan.getStatus().name().toLowerCase(Locale.ENGLISH), new Object[0])});
            IModHelpers.get().getRenderHelpers().drawScaledString(guiGraphics, this.font, statusString, xOriginal + LINE_WIDTH - 80, y + 1, 0.5f, ARGB.opaque((int)0xFFFFFF), true, Font.DisplayMode.NORMAL);
            int dependencies = plan.getEntries().size();
            String dependenciesString = IModHelpers.get().getL10NHelpers().localize("gui.integratedterminals.terminal_crafting_job.craftingplan.dependencies", new Object[]{dependencies});
            IModHelpers.get().getRenderHelpers().drawScaledString(guiGraphics, this.font, dependenciesString, xOriginal + LINE_WIDTH - 80, y + 7, 0.5f, ARGB.opaque((int)0xFFFFFF), true, Font.DisplayMode.NORMAL);
            if (plan.getChannel() != -1) {
                String channelString = IModHelpers.get().getL10NHelpers().localize("gui.integratedterminals.terminal_crafting_job.craftingplan.crafting_channel", new Object[]{plan.getChannel()});
                IModHelpers.get().getRenderHelpers().drawScaledString(guiGraphics, this.font, channelString, xOriginal + LINE_WIDTH - 40, y + 7, 0.5f, ARGB.opaque((int)0xFFFFFF), true, Font.DisplayMode.NORMAL);
            }
            if ((tickDuration = plan.getTickDuration()) >= 0L) {
                String durationString = GuiCraftingPlan.getDurationString(tickDuration);
                IModHelpers.get().getRenderHelpers().drawScaledString(guiGraphics, this.font, durationString, xOriginal + LINE_WIDTH - 80, y + 13, 0.5f, ARGB.opaque((int)0xFFFFFF), true, Font.DisplayMode.NORMAL);
            }
        }
    }

    private void cancelCraftingJobs() {
        for (HandlerWrappedTerminalCraftingPlan craftingJob : ((ContainerTerminalCraftingJobs)this.getMenu()).getCraftingJobs()) {
            PartPos center = ((PartTarget)((ContainerTerminalCraftingJobs)this.getMenu()).getTarget().get()).getCenter();
            CraftingJobGuiData data = new CraftingJobGuiData(center.getPos().getBlockPos(), center.getSide(), ((ContainerTerminalCraftingJobs)this.getMenu()).getChannel(), craftingJob.getHandler(), craftingJob.getCraftingPlanFlat().getId());
            IntegratedTerminals._instance.getPacketHandler().sendToServer((PacketBase)new CancelCraftingJobPacket(data));
        }
        this.player.closeContainer();
    }

    @Nullable
    protected HandlerWrappedTerminalCraftingPlan getHoveredPlan(double mouseX, double mouseY) {
        mouseX -= (double)this.leftPos;
        mouseY -= (double)this.topPos;
        if (mouseX > (double)OUTPUT_SLOT_X && mouseX < (double)(OUTPUT_SLOT_X + LINE_WIDTH) && mouseY > (double)OUTPUT_SLOT_Y && mouseY < (double)(OUTPUT_SLOT_Y + IModHelpers.get().getGuiHelpers().getSlotSize() * this.scrollBar.getVisibleRows())) {
            int index = ((int)mouseY - OUTPUT_SLOT_Y) / IModHelpers.get().getGuiHelpers().getSlotSize();
            List<HandlerWrappedTerminalCraftingPlan> plans = this.getVisiblePlans();
            if (index >= 0 && index < plans.size()) {
                return plans.get(index);
            }
        }
        return null;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        HandlerWrappedTerminalCraftingPlan plan = this.getHoveredPlan(mouseX, mouseY);
        if (plan != null) {
            PartPos pos = ((PartTarget)((ContainerTerminalCraftingJobs)this.getMenu()).getTarget().get()).getCenter();
            OpenCraftingJobsPlanGuiPacket.send(pos.getPos().getBlockPos(), pos.getSide(), ((ContainerTerminalCraftingJobs)this.getMenu()).getChannel(), plan);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int mouseButton, double mouseXPrev, double mouseYPrev) {
        return this.getFocused() != null && this.isDragging() && mouseButton == 0 && this.getFocused().mouseDragged(mouseX, mouseY, mouseButton, mouseXPrev, mouseYPrev) ? true : super.mouseDragged(mouseX, mouseY, mouseButton, mouseXPrev, mouseYPrev);
    }

    public void setFirstRow(int firstRow) {
        this.firstRow = firstRow;
    }

    public void onUpdate(int valueId, CompoundTag value) {
        super.onUpdate(valueId, value);
        if (valueId == ((ContainerTerminalCraftingJobs)this.getMenu()).getValueIdCraftingJobs()) {
            this.init();
        }
    }
}

