/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.core.terminalstorage;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.GameRules;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integratedterminals.IntegratedTerminals;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabCommon;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentCommon;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentServer;
import org.cyclops.integratedterminals.core.terminalstorage.button.TerminalButtonItemStackCraftingGridAutoRefill;
import org.cyclops.integratedterminals.inventory.InventoryCraftingDirtyable;
import org.cyclops.integratedterminals.inventory.SlotCraftingAutoRefill;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;
import org.cyclops.integratedterminals.network.packet.TerminalStorageIngredientItemStackCraftingGridSetResult;

public class TerminalStorageTabIngredientComponentItemStackCraftingCommon
extends TerminalStorageTabIngredientComponentCommon<ItemStack, Integer> {
    private CraftingContainer inventoryCrafting;
    private ResultContainer inventoryCraftResult;
    private ResultSlot slotCrafting;
    private List<Pair<Slot, ITerminalStorageTabCommon.ISlotPositionCallback>> slots;
    private TerminalButtonItemStackCraftingGridAutoRefill.AutoRefillType autoRefill = TerminalButtonItemStackCraftingGridAutoRefill.AutoRefillType.STORAGE;

    public TerminalStorageTabIngredientComponentItemStackCraftingCommon(ContainerTerminalStorageBase containerTerminalStorage, ResourceLocation name, IngredientComponent<ItemStack, Integer> ingredientComponent) {
        super(containerTerminalStorage, name, ingredientComponent);
    }

    public static int getCraftingResultSlotIndex(AbstractContainerMenu container, ResourceLocation name) {
        ITerminalStorageTabCommon tabCommon = ((ContainerTerminalStorageBase)container).getTabCommon(name.toString());
        TerminalStorageTabIngredientComponentItemStackCraftingCommon tabCommonCrafting = (TerminalStorageTabIngredientComponentItemStackCraftingCommon)tabCommon;
        return tabCommonCrafting.getSlotCrafting().index;
    }

    @Override
    public List<Pair<Slot, ITerminalStorageTabCommon.ISlotPositionCallback>> loadSlots(AbstractContainerMenu container, int startIndex, Player player, Optional<ITerminalStorageTabCommon.IVariableInventory> variableInventoryOptional, ValueDeseralizationContext valueDeseralizationContext) {
        ITerminalStorageTabCommon.IVariableInventory variableInventory = variableInventoryOptional.get();
        this.slots = Lists.newArrayListWithCapacity((int)10);
        final IDirtyMarkListener dirtyListener = () -> this.updateCraftingResult(player, container, variableInventory);
        this.inventoryCraftResult = new ResultContainer(this){

            public void setChanged() {
                dirtyListener.onDirty();
                super.setChanged();
            }
        };
        this.inventoryCrafting = new InventoryCraftingDirtyable(container, 3, 3, dirtyListener);
        this.slotCrafting = new SlotCraftingAutoRefill(player, this.inventoryCrafting, (Container)this.inventoryCraftResult, 0, 0, 0, this, (TerminalStorageTabIngredientComponentServer)((ContainerTerminalStorageBase)container).getTabServer(this.getName().toString()), (ContainerTerminalStorageBase)container);
        this.slots.add((Pair<Slot, ITerminalStorageTabCommon.ISlotPositionCallback>)Pair.of((Object)this.slotCrafting, factors -> Pair.of((Object)(factors.offsetX() + factors.gridXSize() / 2 - factors.playerInventoryOffsetX() + 62 - (factors.playerInventoryOffsetX() > 0 ? 47 : 0)), (Object)(factors.offsetY() + factors.gridYSize() + factors.playerInventoryOffsetY() + 10 + (factors.playerInventoryOffsetX() > 0 ? 68 : 0)))));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int finalJ = j;
                int finalI = i;
                this.slots.add((Pair<Slot, ITerminalStorageTabCommon.ISlotPositionCallback>)Pair.of((Object)new Slot((Container)this.inventoryCrafting, j + i * 3, 31 + j * 18 + 28, 58 + i * 18 + 7), factors -> Pair.of((Object)(factors.offsetX() + factors.gridXSize() / 2 - factors.playerInventoryOffsetX() + finalJ * IModHelpers.get().getGuiHelpers().getSlotSize() - 22 - (factors.playerInventoryOffsetX() > 0 ? 47 : 0)), (Object)(factors.offsetY() + factors.gridYSize() + factors.playerInventoryOffsetY() + finalI * IModHelpers.get().getGuiHelpers().getSlotSize() - 8 + (factors.playerInventoryOffsetX() > 0 ? 68 : 0)))));
            }
        }
        NonNullList<ItemStack> tabItems = variableInventory.getNamedInventory(this.getName().toString(), (HolderLookup.Provider)player.registryAccess());
        if (tabItems != null) {
            int i = 0;
            for (ItemStack tabItem : tabItems) {
                if (i == 0) {
                    this.inventoryCraftResult.setItem(i++, tabItem);
                    continue;
                }
                this.inventoryCrafting.setItem(i++ - 1, tabItem);
            }
        }
        ArrayList returnSlots = Lists.newArrayList(this.slots);
        returnSlots.addAll(((ContainerTerminalStorageBase)container).getTabSlots(this.ingredientComponent.getName().toString()));
        return returnSlots;
    }

    public CraftingContainer getInventoryCrafting() {
        return this.inventoryCrafting;
    }

    public ResultContainer getInventoryCraftResult() {
        return this.inventoryCraftResult;
    }

    public ResultSlot getSlotCrafting() {
        return this.slotCrafting;
    }

    public TerminalButtonItemStackCraftingGridAutoRefill.AutoRefillType getAutoRefill() {
        return this.autoRefill;
    }

    public void setAutoRefill(TerminalButtonItemStackCraftingGridAutoRefill.AutoRefillType autoRefill) {
        this.autoRefill = autoRefill;
    }

    public void updateCraftingResult(Player player, AbstractContainerMenu container, ITerminalStorageTabCommon.IVariableInventory variableInventory) {
        if (!player.level().isClientSide) {
            RecipeHolder recipeHolder;
            ServerPlayer entityplayermp = (ServerPlayer)player;
            ItemStack itemstack = ItemStack.EMPTY;
            CraftingInput craftInput = this.inventoryCrafting.asCraftInput();
            if (!craftInput.isEmpty() && (recipeHolder = (RecipeHolder)IModHelpers.get().getCraftingHelpers().findRecipeCached(RecipeType.CRAFTING, (RecipeInput)this.inventoryCrafting.asCraftInput(), player.level(), false).orElse(null)) != null && (((CraftingRecipe)recipeHolder.value()).isSpecial() || !entityplayermp.level().getGameRules().getBoolean(GameRules.RULE_LIMITED_CRAFTING) || entityplayermp.getRecipeBook().contains(recipeHolder.id()))) {
                this.inventoryCraftResult.setRecipeUsed(recipeHolder);
                itemstack = ((CraftingRecipe)recipeHolder.value()).assemble((RecipeInput)craftInput, (HolderLookup.Provider)player.level().registryAccess());
            }
            this.inventoryCraftResult.setItem(0, itemstack);
            IntegratedTerminals._instance.getPacketHandler().sendToPlayer((PacketBase)new TerminalStorageIngredientItemStackCraftingGridSetResult(this.getName().toString(), itemstack), (ServerPlayer)player);
        }
        NonNullList latestItems = NonNullList.create();
        for (Pair<Slot, ITerminalStorageTabCommon.ISlotPositionCallback> slot : this.slots) {
            latestItems.add((Object)((Slot)slot.getLeft()).getItem());
        }
        variableInventory.setNamedInventory(this.getName().toString(), (NonNullList<ItemStack>)latestItems, (HolderLookup.Provider)player.registryAccess());
    }
}

